/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.injection.retriever;

import dev.langchain4j.community.rag.content.retriever.neo4j.Neo4jGraph;
import dev.langchain4j.community.rag.content.retriever.neo4j.Neo4jText2CypherRetriever;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.literal.NamedLiteral;
import java.lang.annotation.Annotation;
import java.util.List;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.GraphDatabase;
import org.wildfly.extension.ai.injection.retriever.WildFlyContentRetrieverConfig;

public class Neo4JContentRetrieverConfig
implements WildFlyContentRetrieverConfig {
    private String boltUrl;
    private String userName;
    private String password;
    private PromptTemplate promptTemplate;
    private String chatLanguageModelName;

    @Override
    public ContentRetriever createContentRetriever(Instance<Object> lookup) {
        Instance chatLanguageModelInstance = lookup.select(ChatModel.class, new Annotation[]{NamedLiteral.of((String)this.chatLanguageModelName)});
        Neo4jGraph graph = this.userName != null ? new Neo4jGraph(GraphDatabase.driver((String)this.boltUrl, (AuthToken)AuthTokens.basic((String)this.userName, (String)this.password)), null, null) : new Neo4jGraph(GraphDatabase.driver((String)this.boltUrl, (AuthToken)AuthTokens.none()), null, null);
        return new Neo4jText2CypherRetriever(graph, (ChatModel)chatLanguageModelInstance.get(), this.promptTemplate, List.of(), 2, List.of(), null);
    }

    public Neo4JContentRetrieverConfig boltUrl(String boltUrl) {
        this.boltUrl = boltUrl;
        return this;
    }

    public Neo4JContentRetrieverConfig userName(String userName) {
        this.userName = userName;
        return this;
    }

    public Neo4JContentRetrieverConfig password(String password) {
        this.password = password;
        return this;
    }

    public Neo4JContentRetrieverConfig promptTemplate(PromptTemplate promptTemplate) {
        this.promptTemplate = promptTemplate;
        return this;
    }

    public Neo4JContentRetrieverConfig chatLanguageModel(String chatLanguageModelName) {
        this.chatLanguageModelName = chatLanguageModelName;
        return this;
    }
}

