/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import org.jberet.spi.BatchEnvironment;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.wildfly.extension.batch.jberet.BatchServiceNames;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet.deployment.BatchJobExecutionResource;
import org.wildfly.extension.batch.jberet.deployment.JobOperatorService;
import org.wildfly.extension.batch.jberet.deployment.WildFlyJobXmlResolver;

public class BatchDeploymentResourceProcessor
implements DeploymentUnitProcessor {
    private final String subsystemName;

    public BatchDeploymentResourceProcessor(String subsystemName) {
        this.subsystemName = subsystemName;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.hasAttachment(Attachments.MODULE) && !DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit) && deploymentUnit.hasAttachment(Attachments.DEPLOYMENT_ROOT)) {
            BatchLogger.LOGGER.tracef("Processing deployment '%s' for the batch deployment resources.", deploymentUnit.getName());
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            ModuleClassLoader moduleClassLoader = module.getClassLoader();
            DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
            JobOperatorService jobOperatorService = new JobOperatorService();
            WildFlyJobXmlResolver jobXmlResolver = (WildFlyJobXmlResolver)deploymentUnit.getAttachment(WildFlyJobXmlResolver.JOB_XML_RESOLVER);
            for (String jobXml : jobXmlResolver.getJobXmlNames((ClassLoader)moduleClassLoader)) {
                try {
                    String jobName = jobXmlResolver.resolveJobName(jobXml, (ClassLoader)moduleClassLoader);
                    jobOperatorService.addAllowedJob(jobXml, jobName);
                    BatchLogger.LOGGER.debugf("Added job XML %s with job name %s to allowed jobs for deployment %s", jobXml, jobName, deploymentUnit.getName());
                    PathAddress jobAddress = PathAddress.pathAddress((String)"job", (String)jobName);
                    if (deploymentResourceSupport.hasDeploymentSubModel(this.subsystemName, jobAddress)) continue;
                    deploymentResourceSupport.registerDeploymentSubResource(this.subsystemName, jobAddress, (Resource)new BatchJobExecutionResource(jobOperatorService, jobName));
                }
                catch (Exception e) {
                    BatchLogger.LOGGER.debugf(e, "Could not parse the XML file %s. The job will not be registered for runtime views on the deployment (%s).", jobXml, deploymentUnit.getName());
                }
            }
            phaseContext.getServiceTarget().addService(BatchServiceNames.jobOperatorServiceName(deploymentUnit), (Service)jobOperatorService).addDependency(BatchServiceNames.batchEnvironmentServiceName(deploymentUnit), BatchEnvironment.class, jobOperatorService.getBatchEnvironmentInjector()).install();
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

