/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

enum Namespace {
    UNKNOWN(null),
    BATCH_1_0("urn:jboss:domain:batch-jberet:1.0"),
    BATCH_2_0("urn:jboss:domain:batch-jberet:2.0"),
    BATCH_3_0("urn:jboss:domain:batch-jberet:3.0");

    private static final Map<String, Namespace> MAP;
    public static final Namespace CURRENT;
    private final String name;

    private Namespace(String name) {
        this.name = name;
    }

    public String getUriString() {
        return this.name;
    }

    public static Namespace forUri(String uri) {
        if (uri == null) {
            return UNKNOWN;
        }
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        map.put(Namespace.BATCH_1_0.name, BATCH_1_0);
        map.put(Namespace.BATCH_2_0.name, BATCH_2_0);
        map.put(Namespace.BATCH_3_0.name, BATCH_3_0);
        MAP = Collections.unmodifiableMap(map);
        CURRENT = BATCH_3_0;
    }
}

