/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jberet.repository.JobRepository;
import org.jberet.spi.JobExecutor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.batch.jberet.BatchConfiguration;
import org.wildfly.security.auth.server.SecurityDomain;

class BatchConfigurationService
implements BatchConfiguration,
Service<BatchConfiguration> {
    private final Consumer<BatchConfiguration> batchConfigurationConsumer;
    private final Supplier<JobRepository> jobRepositorySupplier;
    private final Supplier<JobExecutor> jobExecutorSupplier;
    private final Supplier<SecurityDomain> securityDomainSupplier;
    private volatile boolean restartOnResume;

    BatchConfigurationService(Consumer<BatchConfiguration> batchConfigurationConsumer, Supplier<JobRepository> jobRepositorySupplier, Supplier<JobExecutor> jobExecutorSupplier, Supplier<SecurityDomain> securityDomainSupplier) {
        this.batchConfigurationConsumer = batchConfigurationConsumer;
        this.jobRepositorySupplier = jobRepositorySupplier;
        this.jobExecutorSupplier = jobExecutorSupplier;
        this.securityDomainSupplier = securityDomainSupplier;
    }

    @Override
    public boolean isRestartOnResume() {
        return this.restartOnResume;
    }

    protected void setRestartOnResume(boolean restartOnResume) {
        this.restartOnResume = restartOnResume;
    }

    @Override
    public JobRepository getDefaultJobRepository() {
        return this.jobRepositorySupplier.get();
    }

    @Override
    public JobExecutor getDefaultJobExecutor() {
        return this.jobExecutorSupplier.get();
    }

    @Override
    public SecurityDomain getSecurityDomain() {
        return this.securityDomainSupplier != null ? this.securityDomainSupplier.get() : null;
    }

    public void start(StartContext context) throws StartException {
        this.batchConfigurationConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.batchConfigurationConsumer.accept(null);
    }

    public BatchConfiguration getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

