/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.utils.ObjectInputStreamWithClassLoader;

public class HornetQObjectMessage
extends HornetQMessage
implements ObjectMessage {
    public static final byte TYPE = 2;
    private byte[] data;

    protected HornetQObjectMessage(ClientSession session) {
        super((byte)2, session);
    }

    protected HornetQObjectMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public HornetQObjectMessage(ObjectMessage foreign, ClientSession session) throws JMSException {
        super(foreign, (byte)2, session);
        this.setObject(foreign.getObject());
    }

    @Override
    public byte getType() {
        return 2;
    }

    @Override
    public void doBeforeSend() throws Exception {
        this.message.getBodyBuffer().clear();
        if (this.data != null) {
            this.message.getBodyBuffer().writeInt(this.data.length);
            this.message.getBodyBuffer().writeBytes(this.data);
        }
        super.doBeforeSend();
    }

    @Override
    public void doBeforeReceive() throws HornetQException {
        super.doBeforeReceive();
        try {
            int len = this.message.getBodyBuffer().readInt();
            this.data = new byte[len];
            this.message.getBodyBuffer().readBytes(this.data);
        }
        catch (Exception e) {
            this.data = null;
        }
    }

    @Override
    public void setObject(Serializable object) throws JMSException {
        this.checkWrite();
        if (object != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(object);
                oos.flush();
                this.data = baos.toByteArray();
            }
            catch (Exception e) {
                JMSException je = new JMSException("Failed to serialize object");
                je.setLinkedException(e);
                je.initCause(e);
                throw je;
            }
        }
    }

    @Override
    public Serializable getObject() throws JMSException {
        if (this.data == null || this.data.length == 0) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
            ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader(bais);
            Serializable object = (Serializable)ois.readObject();
            return object;
        }
        catch (Exception e) {
            JMSException je = new JMSException(e.getMessage());
            je.setStackTrace(e.getStackTrace());
            throw je;
        }
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.data = null;
    }

    @Override
    protected <T> T getBodyInternal(Class<T> c) throws MessageFormatException {
        try {
            return (T)this.getObject();
        }
        catch (JMSException e) {
            throw new MessageFormatException("Deserialization error on HornetQObjectMessage");
        }
    }

    @Override
    public boolean isBodyAssignableTo(Class c) {
        if (this.data == null) {
            return true;
        }
        try {
            return Serializable.class == c || Object.class == c || c.isInstance(this.getObject());
        }
        catch (JMSException e) {
            return false;
        }
    }
}

