/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.qourum;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.qourum.Quorum;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumManager;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumVoteServerConnect;

public class SharedNothingBackupQuorum
implements Quorum,
SessionFailureListener {
    private QuorumManager quorumManager;
    private String targetServerID = "";
    private final NodeManager nodeManager;
    private final StorageManager storageManager;
    private final ScheduledExecutorService scheduledPool;
    private CountDownLatch latch;
    private ClientSessionFactoryInternal sessionFactory;
    private CoreRemotingConnection connection;
    public static final int WAIT_TIME_AFTER_FIRST_LIVE_STOPPING_MSG = 60;
    private volatile BACKUP_ACTIVATION signal;
    private static final int LATCH_TIMEOUT = 30;
    private static final int RECONNECT_ATTEMPTS = 5;
    private final Object decisionGuard = new Object();

    public SharedNothingBackupQuorum(StorageManager storageManager, NodeManager nodeManager, ScheduledExecutorService scheduledPool) {
        this.storageManager = storageManager;
        this.scheduledPool = scheduledPool;
        this.latch = new CountDownLatch(1);
        this.nodeManager = nodeManager;
    }

    @Override
    public String getName() {
        return "SharedNothingBackupQuorum";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decideOnAction(Topology topology) {
        Object object = this.decisionGuard;
        synchronized (object) {
            block7: {
                if (this.signal == BACKUP_ACTIVATION.FAIL_OVER) {
                    return;
                }
                if (!this.isLiveDown()) {
                    try {
                        this.sessionFactory.connect(5, false);
                        return;
                    }
                    catch (ActiveMQException e) {
                        if (e.getType() == ActiveMQExceptionType.NOT_CONNECTED) break block7;
                        ActiveMQServerLogger.LOGGER.errorReConnecting(e);
                    }
                }
            }
            this.signal = BACKUP_ACTIVATION.FAIL_OVER;
        }
        this.latch.countDown();
    }

    public void liveIDSet(String liveID) {
        this.targetServerID = liveID;
        this.nodeManager.setNodeID(liveID);
    }

    @Override
    public void setQuorumManager(QuorumManager quorumManager) {
        this.quorumManager = quorumManager;
    }

    @Override
    public void nodeDown(Topology topology, long eventUID, String nodeID) {
        if (this.targetServerID.equals(nodeID)) {
            this.decideOnAction(topology);
        }
    }

    @Override
    public void nodeUp(Topology topology) {
    }

    @Override
    public void connectionFailed(ActiveMQException exception, boolean failedOver) {
        this.decideOnAction(this.sessionFactory.getServerLocator().getTopology());
    }

    @Override
    public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
        this.connectionFailed(me, failedOver);
    }

    @Override
    public void beforeReconnect(ActiveMQException exception) {
    }

    @Override
    public void close() {
        this.causeExit(BACKUP_ACTIVATION.STOP);
    }

    public void setSessionFactory(ClientSessionFactoryInternal sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.connection = (CoreRemotingConnection)sessionFactory.getConnection();
        this.connection.addFailureListener(this);
        sessionFactory.addFailureListener(this);
    }

    public synchronized void failOver(ReplicationLiveIsStoppingMessage.LiveStopping finalMessage) {
        this.removeListener();
        this.signal = BACKUP_ACTIVATION.FAIL_OVER;
        if (finalMessage == ReplicationLiveIsStoppingMessage.LiveStopping.FAIL_OVER) {
            this.latch.countDown();
        }
        if (finalMessage == ReplicationLiveIsStoppingMessage.LiveStopping.STOP_CALLED) {
            final CountDownLatch localLatch = this.latch;
            this.scheduledPool.schedule(new Runnable(){

                @Override
                public void run() {
                    localLatch.countDown();
                }
            }, 60L, TimeUnit.SECONDS);
        }
    }

    public void notifyRegistrationFailed() {
        this.signal = BACKUP_ACTIVATION.FAILURE_REPLICATING;
        this.latch.countDown();
    }

    public void notifyAlreadyReplicating() {
        this.signal = BACKUP_ACTIVATION.ALREADY_REPLICATING;
        this.latch.countDown();
    }

    private void removeListener() {
        if (this.connection != null) {
            this.connection.removeFailureListener(this);
        }
    }

    public BACKUP_ACTIVATION waitForStatusChange() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            return BACKUP_ACTIVATION.STOP;
        }
        return this.signal;
    }

    public synchronized void causeExit(BACKUP_ACTIVATION explicitSignal) {
        this.removeListener();
        this.signal = explicitSignal;
        this.latch.countDown();
    }

    public synchronized void reset() {
        this.latch = new CountDownLatch(1);
    }

    private boolean isLiveDown() {
        int size = this.quorumManager.getMaxClusterSize() - 1;
        QuorumVoteServerConnect quorumVote = new QuorumVoteServerConnect(size, this.storageManager);
        this.quorumManager.vote(quorumVote);
        try {
            quorumVote.await(30, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.quorumManager.voteComplete(quorumVote);
        return quorumVote.getDecision();
    }

    public static enum BACKUP_ACTIVATION {
        FAIL_OVER,
        FAILURE_REPLICATING,
        ALREADY_REPLICATING,
        STOP;

    }
}

