/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class ActiveMQThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final int threadPriority;
    private final boolean daemon;
    private final ClassLoader tccl;
    private final AccessControlContext acc;
    private final String prefix;

    public ActiveMQThreadFactory(String groupName, boolean daemon, ClassLoader tccl) {
        this(groupName, "Thread-", daemon, tccl);
    }

    public ActiveMQThreadFactory(String groupName, String prefix, boolean daemon, ClassLoader tccl) {
        this.group = new ThreadGroup(groupName + "-" + System.identityHashCode(this));
        this.prefix = prefix;
        this.threadPriority = 5;
        this.tccl = tccl;
        this.daemon = daemon;
        this.acc = AccessController.getContext();
    }

    @Override
    public Thread newThread(Runnable command) {
        if (this.acc != null) {
            return AccessController.doPrivileged(new ThreadCreateAction(command), this.acc);
        }
        return this.createThread(command);
    }

    private Thread createThread(Runnable command) {
        Thread t = new Thread(this.group, command, this.prefix + this.threadCount.getAndIncrement() + " (" + this.group.getName() + ")");
        t.setDaemon(this.daemon);
        t.setPriority(this.threadPriority);
        t.setContextClassLoader(this.tccl);
        return t;
    }

    public static ActiveMQThreadFactory defaultThreadFactory() {
        String callerClassName = Thread.currentThread().getStackTrace()[2].getClassName();
        return new ActiveMQThreadFactory(callerClassName, false, null);
    }

    private final class ThreadCreateAction
    implements PrivilegedAction<Thread> {
        private final Runnable target;

        private ThreadCreateAction(Runnable target) {
            this.target = target;
        }

        @Override
        public Thread run() {
            return ActiveMQThreadFactory.this.createThread(this.target);
        }
    }
}

