/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBTransportProvider;
import org.jboss.ejb.protocol.remote.EJBClientChannel;
import org.jboss.ejb.protocol.remote.RemoteEJBReceiver;
import org.wildfly.discovery.ServiceRegistration;
import org.wildfly.discovery.ServiceRegistry;
import org.wildfly.discovery.impl.LocalRegistryAndDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;

public final class RemoteTransportProvider
implements EJBTransportProvider {
    static final AttachmentKey<RemoteEJBReceiver> ATTACHMENT_KEY = new AttachmentKey();
    private final ServiceRegistry persistentClusterRegistry;
    private final DiscoveryProvider persistentClusterDiscoveryProvider;
    private final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<EJBClientChannel.ClusterDiscKey, ServiceRegistration>>> clusterRegistrationsMap = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<EJBClientChannel.ClusterDiscKey, ServiceRegistration>>>();

    public RemoteTransportProvider() {
        LocalRegistryAndDiscoveryProvider provider = new LocalRegistryAndDiscoveryProvider();
        this.persistentClusterDiscoveryProvider = provider;
        this.persistentClusterRegistry = ServiceRegistry.create(provider);
    }

    @Override
    public void notifyRegistered(EJBReceiverContext receiverContext) {
        EJBClientContext clientContext = receiverContext.getClientContext();
        clientContext.putAttachmentIfAbsent(ATTACHMENT_KEY, new RemoteEJBReceiver(this, receiverContext, this.persistentClusterRegistry, this.clusterRegistrationsMap));
    }

    @Override
    public boolean supportsProtocol(String uriScheme) {
        switch (uriScheme) {
            case "remote": 
            case "remote+http": 
            case "remote+https": 
            case "remoting": 
            case "http-remoting": 
            case "https-remoting": {
                return true;
            }
        }
        return false;
    }

    @Override
    public EJBReceiver getReceiver(EJBReceiverContext receiverContext, String uriScheme) throws IllegalArgumentException {
        switch (uriScheme) {
            case "remote": 
            case "remote+http": 
            case "remote+https": 
            case "remoting": 
            case "http-remoting": 
            case "https-remoting": {
                RemoteEJBReceiver receiver = receiverContext.getClientContext().getAttachment(ATTACHMENT_KEY);
                if (receiver == null) break;
                return receiver;
            }
        }
        throw new IllegalArgumentException("Unsupported EJB receiver protocol " + uriScheme);
    }

    DiscoveryProvider getClusterDiscoveryProvider() {
        return this.persistentClusterDiscoveryProvider;
    }
}

