/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.common.function.ExceptionConsumer;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionObjIntConsumer;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.common.function.ExceptionToIntBiFunction;
import org.wildfly.common.function.ExceptionToIntFunction;
import org.wildfly.transaction.TransactionPermission;
import org.wildfly.transaction.client.AssociationListener;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client._private.Log;

public abstract class AbstractTransaction
implements Transaction {
    private static final TransactionPermission ASSOCIATION_LISTENER_PERMISSION = TransactionPermission.forName("registerAssociationListener");
    private final Object outflowLock = new Object();
    private final long start = System.nanoTime();
    final List<AssociationListener> associationListeners = new CopyOnWriteArrayList<AssociationListener>();

    AbstractTransaction() {
    }

    abstract void registerInterposedSynchronization(Synchronization var1) throws IllegalStateException;

    abstract Object getResource(Object var1) throws NullPointerException;

    abstract void putResource(Object var1, Object var2) throws NullPointerException;

    abstract Object getKey();

    boolean getRollbackOnly() {
        try {
            return this.getStatus() == 1;
        }
        catch (SystemException e) {
            return false;
        }
    }

    abstract void suspend() throws SystemException;

    void notifyAssociationListeners(boolean associated) {
        for (AssociationListener associationListener : this.associationListeners) {
            try {
                associationListener.associationChanged(this, associated);
            }
            catch (Throwable t) {
                Log.log.tracef(t, "An association listener %s threw an exception on transaction %s", (Object)associationListener, (Object)this);
            }
        }
    }

    abstract void resume() throws SystemException;

    abstract void verifyAssociation();

    public abstract int getTransactionTimeout();

    public final int getEstimatedRemainingTime() {
        long elapsed = System.nanoTime() - this.start;
        int transactionTimeout = this.getTransactionTimeout();
        return transactionTimeout - (int)Math.min((Math.max(elapsed, 0L) + 999999999L) / 1000000000L, (long)transactionTimeout);
    }

    public <T> T getProviderInterface(Class<T> providerInterfaceType) {
        return null;
    }

    public void registerAssociationListener(AssociationListener associationListener) {
        Assert.checkNotNullParam("associationListener", associationListener);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ASSOCIATION_LISTENER_PERMISSION);
        }
        this.associationListeners.add(associationListener);
    }

    @Override
    public abstract void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException;

    abstract void commitAndDissociate() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException;

    @Override
    public abstract void rollback() throws IllegalStateException, SystemException;

    abstract void rollbackAndDissociate() throws IllegalStateException, SystemException;

    private static void doNothing() {
    }

    private static SysExTry whileSuspended() throws SystemException {
        ContextTransactionManager tm = ContextTransactionManager.INSTANCE;
        AbstractTransaction suspended = tm.suspend();
        return suspended == null ? AbstractTransaction::doNothing : () -> tm.resume(suspended);
    }

    private static SysExTry whileResumed(AbstractTransaction transaction) throws SystemException {
        if (transaction == null) {
            return AbstractTransaction::doNothing;
        }
        ContextTransactionManager tm = ContextTransactionManager.INSTANCE;
        tm.resume(transaction);
        return tm::suspend;
    }

    /*
     * Exception decompiling
     */
    public <T, U, R, E extends Exception> R performFunction(ExceptionBiFunction<T, U, R, E> function, T param1, U param2) throws E, SystemException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T, R, E extends Exception> R performFunction(ExceptionFunction<T, R, E> function, T param) throws E, SystemException {
        return (R)this.performFunction(ExceptionFunction::apply, function, param);
    }

    public <R, E extends Exception> R performSupplier(ExceptionSupplier<R, E> function) throws E, SystemException {
        return (R)this.performFunction(ExceptionSupplier::get, function);
    }

    public <T, E extends Exception> void performConsumer(ExceptionObjIntConsumer<T, E> consumer, T param1, int param2) throws E, SystemException {
        ContextTransactionManager tm = ContextTransactionManager.INSTANCE;
        if (tm.getStateRef().get().transaction == this) {
            consumer.accept(param1, param2);
            return;
        }
        try (SysExTry ignored = AbstractTransaction.whileSuspended();
             SysExTry ignored2 = AbstractTransaction.whileResumed(this);){
            consumer.accept(param1, param2);
        }
    }

    public <T, U, E extends Exception> void performConsumer(ExceptionBiConsumer<T, U, E> consumer, T param1, U param2) throws E, SystemException {
        ContextTransactionManager tm = ContextTransactionManager.INSTANCE;
        if (tm.getStateRef().get().transaction == this) {
            consumer.accept(param1, param2);
            return;
        }
        try (SysExTry ignored = AbstractTransaction.whileSuspended();
             SysExTry ignored2 = AbstractTransaction.whileResumed(this);){
            consumer.accept(param1, param2);
        }
    }

    public <T, E extends Exception> void performConsumer(ExceptionConsumer<T, E> consumer, T param) throws E, SystemException {
        this.performConsumer(ExceptionConsumer::accept, consumer, param);
    }

    /*
     * Exception decompiling
     */
    public <T, U, E extends Exception> int performToIntFunction(ExceptionToIntBiFunction<T, U, E> function, T param1, U param2) throws E, SystemException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T, E extends Exception> int performToIntFunction(ExceptionToIntFunction<T, E> function, T param) throws E, SystemException {
        return this.performToIntFunction(ExceptionToIntFunction::apply, function, param);
    }

    public <E extends Exception> void performAction(ExceptionRunnable<E> action) throws E, SystemException {
        this.performConsumer(ExceptionRunnable::run, action);
    }

    Object getOutflowLock() {
        return this.outflowLock;
    }

    static interface SysExTry
    extends AutoCloseable {
        @Override
        public void close() throws SystemException;
    }
}

