/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.standalone.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;

public class DeploymentActionImpl
implements DeploymentAction,
Serializable {
    private static final long serialVersionUID = 613098200977026475L;
    private static final InputStream EMPTY_STREAM = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    private final UUID uuid = UUID.randomUUID();
    private final DeploymentAction.Type type;
    private final String deploymentUnitName;
    private final String oldDeploymentUnitName;
    private final String newContentFileName;
    private final InputStream contentStream;
    private final Map<String, InputStream> contents;
    private final boolean internalStream;

    public static DeploymentActionImpl getAddAction(String deploymentName, String fileName, InputStream in, boolean internalStream) {
        return new DeploymentActionImpl(DeploymentAction.Type.ADD, deploymentName, fileName, in, internalStream, null);
    }

    public static DeploymentActionImpl getAddContentAction(String deploymentName, Map<String, InputStream> contents) {
        return new DeploymentActionImpl(DeploymentAction.Type.ADD_CONTENT, deploymentName, contents, true, null);
    }

    public static DeploymentActionImpl getDeployAction(String deploymentName) {
        return new DeploymentActionImpl(DeploymentAction.Type.DEPLOY, deploymentName, null, null, false, null);
    }

    public static DeploymentActionImpl getExplodeAction(String deploymentName) {
        return new DeploymentActionImpl(DeploymentAction.Type.EXPLODE, deploymentName, null, null, false, null);
    }

    public static DeploymentActionImpl getRedeployAction(String deploymentName) {
        return new DeploymentActionImpl(DeploymentAction.Type.REDEPLOY, deploymentName, null, null, false, null);
    }

    public static DeploymentActionImpl getUndeployAction(String deploymentName) {
        return new DeploymentActionImpl(DeploymentAction.Type.UNDEPLOY, deploymentName, null, null, false, null);
    }

    public static DeploymentActionImpl getReplaceAction(String deploymentName, String replacedName) {
        return new DeploymentActionImpl(DeploymentAction.Type.REPLACE, deploymentName, null, null, false, replacedName);
    }

    public static DeploymentActionImpl getFullReplaceAction(String deploymentName, String fileName, InputStream in, boolean internalStream) {
        return new DeploymentActionImpl(DeploymentAction.Type.FULL_REPLACE, deploymentName, fileName, in, internalStream, null);
    }

    public static DeploymentActionImpl getRemoveAction(String deploymentName) {
        return new DeploymentActionImpl(DeploymentAction.Type.REMOVE, deploymentName, null, null, false, null);
    }

    public static DeploymentActionImpl getRemoveContentAction(String deploymentName, List<String> fileNames) {
        HashMap<String, InputStream> contents = new HashMap<String, InputStream>(fileNames.size());
        for (String file : fileNames) {
            contents.put(file, EMPTY_STREAM);
        }
        return new DeploymentActionImpl(DeploymentAction.Type.REMOVE_CONTENT, deploymentName, contents, false, null);
    }

    private DeploymentActionImpl(DeploymentAction.Type type, String deploymentUnitName, String newContentFileName, InputStream contents, boolean internalStream, String replacedDeploymentUnitName) {
        this.type = type;
        this.deploymentUnitName = deploymentUnitName;
        this.newContentFileName = newContentFileName;
        this.contents = newContentFileName != null && contents != null ? Collections.singletonMap(newContentFileName, contents) : Collections.emptyMap();
        this.contentStream = contents != null ? contents : null;
        this.oldDeploymentUnitName = replacedDeploymentUnitName;
        this.internalStream = internalStream;
    }

    private DeploymentActionImpl(DeploymentAction.Type type, String deploymentUnitName, Map<String, InputStream> contents, boolean internalStream, String replacedDeploymentUnitName) {
        this.type = type;
        this.deploymentUnitName = deploymentUnitName;
        this.newContentFileName = null;
        this.contentStream = null;
        this.contents = contents;
        this.oldDeploymentUnitName = replacedDeploymentUnitName;
        this.internalStream = internalStream;
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    @Override
    public DeploymentAction.Type getType() {
        return this.type;
    }

    @Override
    public String getDeploymentUnitUniqueName() {
        return this.deploymentUnitName;
    }

    @Override
    public String getReplacedDeploymentUnitUniqueName() {
        return this.oldDeploymentUnitName;
    }

    public String getNewContentFileName() {
        return this.newContentFileName;
    }

    public InputStream getContentStream() {
        return this.contentStream;
    }

    public Map<String, InputStream> getContents() {
        return this.contents;
    }

    public boolean isInternalStream() {
        return this.internalStream;
    }
}

