/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.DelegatingModelControllerClient;
import org.jboss.as.host.controller.DomainModelControllerService;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.Main;
import org.jboss.as.server.FutureServiceContainer;
import org.jboss.as.server.SystemExiter;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.stdio.StdioContext;
import org.wildfly.common.Assert;
import org.wildfly.core.embedded.EmbeddedHostControllerBootstrap;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.HostController;
import org.wildfly.core.embedded.logging.EmbeddedLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class EmbeddedHostControllerFactory {
    public static final String JBOSS_EMBEDDED_ROOT = "jboss.embedded.root";
    private static final String MODULE_PATH = "-mp";
    private static final String PC_ADDRESS = "--pc-address";
    private static final String PC_PORT = "--pc-port";

    private EmbeddedHostControllerFactory() {
    }

    public static HostController create(File jbossHomeDir, ModuleLoader moduleLoader, Properties systemProps, Map<String, String> systemEnv, String[] cmdargs) {
        Assert.checkNotNullParam("jbossHomeDir", jbossHomeDir);
        Assert.checkNotNullParam("moduleLoader", moduleLoader);
        Assert.checkNotNullParam("systemProps", systemProps);
        Assert.checkNotNullParam("systemEnv", systemEnv);
        Assert.checkNotNullParam("cmdargs", cmdargs);
        EmbeddedHostControllerFactory.setupCleanDirectories(jbossHomeDir, systemProps);
        return new HostControllerImpl(jbossHomeDir, cmdargs, systemProps, systemEnv, moduleLoader);
    }

    static void setupCleanDirectories(File jbossHomeDir, Properties props) {
        File tempRoot = EmbeddedHostControllerFactory.getTempRoot(props);
        if (tempRoot == null) {
            return;
        }
        File originalConfigDir = EmbeddedHostControllerFactory.getFileUnderAsRoot(jbossHomeDir, props, "jboss.domain.config.dir", "configuration", true);
        File originalDataDir = EmbeddedHostControllerFactory.getFileUnderAsRoot(jbossHomeDir, props, "jboss.domain.data.dir", "data", false);
        try {
            File configDir = new File(tempRoot, "config");
            Files.createDirectory(configDir.toPath(), new FileAttribute[0]);
            File dataDir = new File(tempRoot, "data");
            Files.createDirectory(dataDir.toPath(), new FileAttribute[0]);
            File deploymentsDir = new File(tempRoot, "deployments");
            Files.createDirectory(deploymentsDir.toPath(), new FileAttribute[0]);
            EmbeddedHostControllerFactory.copyDirectory(originalConfigDir, configDir);
            if (originalDataDir.exists()) {
                EmbeddedHostControllerFactory.copyDirectory(originalDataDir, dataDir);
            }
            props.put("jboss.domain.base.dir", tempRoot.getAbsolutePath());
            props.put("jboss.domain.config.dir", configDir.getAbsolutePath());
            props.put("jboss.domain.data.dir", dataDir.getAbsolutePath());
        }
        catch (IOException e) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotSetupEmbeddedServer(e);
        }
    }

    private static File getFileUnderAsRoot(File jbossHomeDir, Properties props, String propName, String relativeLocation, boolean mustExist) {
        String prop = props.getProperty(propName, null);
        if (prop == null) {
            prop = props.getProperty("jboss.domain.base.dir", null);
            if (prop == null) {
                File dir = new File(jbossHomeDir, "domain" + File.separator + relativeLocation);
                if (!(!mustExist || dir.exists() && dir.isDirectory())) {
                    throw ServerLogger.ROOT_LOGGER.embeddedServerDirectoryNotFound("domain" + File.separator + relativeLocation, jbossHomeDir.getAbsolutePath());
                }
                return dir;
            }
            File server = new File(prop);
            EmbeddedHostControllerFactory.validateDirectory("jboss.domain.base.dir", server);
            return new File(server, relativeLocation);
        }
        File dir = new File(prop);
        EmbeddedHostControllerFactory.validateDirectory("jboss.domain.base.dir", dir);
        return dir;
    }

    private static File getTempRoot(Properties props) {
        String tempRoot = props.getProperty(JBOSS_EMBEDDED_ROOT, null);
        if (tempRoot == null) {
            return null;
        }
        try {
            File root = new File(tempRoot);
            if (!root.exists()) {
                Files.createDirectories(root.toPath(), new FileAttribute[0]);
            }
            EmbeddedHostControllerFactory.validateDirectory("jboss.test.clean.root", root);
            root = new File(root, "configs");
            Files.createDirectories(root.toPath(), new FileAttribute[0]);
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            root = new File(root, format.format(new Date()));
            Files.createDirectory(root.toPath(), new FileAttribute[0]);
            return root;
        }
        catch (IOException e) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotSetupEmbeddedServer(e);
        }
    }

    private static void validateDirectory(String property, File file) {
        if (!file.exists()) {
            throw ServerLogger.ROOT_LOGGER.propertySpecifiedFileDoesNotExist(property, file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw ServerLogger.ROOT_LOGGER.propertySpecifiedFileIsNotADirectory(property, file.getAbsolutePath());
        }
    }

    private static void copyDirectory(File src, File dest) {
        if (src.list() != null) {
            for (String current : src.list()) {
                File srcFile = new File(src, current);
                File destFile = new File(dest, current);
                try {
                    Files.copy(srcFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    if (!srcFile.isDirectory()) continue;
                    EmbeddedHostControllerFactory.copyDirectory(srcFile, destFile);
                }
                catch (IOException e) {
                    throw ServerLogger.ROOT_LOGGER.errorCopyingFile(srcFile.getAbsolutePath(), destFile.getAbsolutePath(), e);
                }
            }
        }
    }

    private static class HostControllerImpl
    implements HostController {
        private final PropertyChangeListener processStateListener;
        private final String[] cmdargs;
        private final File jbossHomeDir;
        private final Properties systemProps;
        private final Map<String, String> systemEnv;
        private final ModuleLoader moduleLoader;
        private ServiceContainer serviceContainer;
        private ControlledProcessState.State currentProcessState;
        private ModelControllerClient modelControllerClient;
        private ExecutorService executorService;
        private ControlledProcessStateService controlledProcessStateService;
        private boolean uninstallStdIo;

        public HostControllerImpl(File jbossHomeDir, String[] cmdargs, Properties systemProps, Map<String, String> systemEnv, ModuleLoader moduleLoader) {
            this.cmdargs = cmdargs;
            this.jbossHomeDir = jbossHomeDir;
            this.systemProps = systemProps;
            this.systemEnv = systemEnv;
            this.moduleLoader = moduleLoader;
            this.processStateListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("currentState".equals(evt.getPropertyName())) {
                        ControlledProcessState.State newState = (ControlledProcessState.State)evt.getNewValue();
                        this.establishModelControllerClient(newState, true);
                    }
                }
            };
        }

        @Override
        public void start() throws EmbeddedProcessStartException {
            EmbeddedHostControllerBootstrap hostControllerBootstrap = null;
            try {
                long startTime = System.currentTimeMillis();
                SystemExiter.initialize((SystemExiter.Exiter)new SystemExiter.Exiter(){

                    public void exit(int status) {
                        this.exit();
                    }
                });
                try {
                    StdioContext.install();
                    this.uninstallStdIo = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                HostControllerEnvironment environment = HostControllerImpl.createHostControllerEnvironment(this.jbossHomeDir, this.cmdargs, startTime);
                FutureServiceContainer futureContainer = new FutureServiceContainer();
                byte[] authBytes = new byte[16];
                new Random(new SecureRandom().nextLong()).nextBytes(authBytes);
                String authCode = Base64.getEncoder().encodeToString(authBytes);
                hostControllerBootstrap = new EmbeddedHostControllerBootstrap(futureContainer, environment, authCode);
                hostControllerBootstrap.bootstrap();
                this.serviceContainer = (ServiceContainer)futureContainer.get();
                this.executorService = Executors.newCachedThreadPool();
                ServiceController<?> processStateServiceValue = this.serviceContainer.getRequiredService(ControlledProcessStateService.SERVICE_NAME);
                this.controlledProcessStateService = (ControlledProcessStateService)processStateServiceValue.getValue();
                this.controlledProcessStateService.addPropertyChangeListener(this.processStateListener);
                this.establishModelControllerClient(this.controlledProcessStateService.getCurrentState(), false);
            }
            catch (RuntimeException rte) {
                if (hostControllerBootstrap != null) {
                    hostControllerBootstrap.failed();
                }
                throw rte;
            }
            catch (Exception ex) {
                if (hostControllerBootstrap != null) {
                    hostControllerBootstrap.failed();
                }
                throw EmbeddedLogger.ROOT_LOGGER.cannotStartEmbeddedServer(ex);
            }
        }

        @Override
        public synchronized ModelControllerClient getModelControllerClient() {
            return this.modelControllerClient == null ? null : new DelegatingModelControllerClient(new DelegatingModelControllerClient.DelegateProvider(){

                @Override
                public ModelControllerClient getDelegate() {
                    return this.getActiveModelControllerClient();
                }
            });
        }

        private synchronized void establishModelControllerClient(ControlledProcessState.State state, boolean storeState) {
            LocalModelControllerClient newClient = null;
            if (state != ControlledProcessState.State.STOPPING && state != ControlledProcessState.State.STOPPED && this.serviceContainer != null) {
                ModelControllerClientFactory clientFactory;
                try {
                    ServiceController<?> clientFactorySvc = this.serviceContainer.getService(DomainModelControllerService.CLIENT_FACTORY_SERVICE_NAME);
                    clientFactory = (ModelControllerClientFactory)clientFactorySvc.getValue();
                }
                catch (RuntimeException e) {
                    clientFactory = null;
                }
                if (clientFactory != null) {
                    newClient = clientFactory.createSuperUserClient((Executor)this.executorService);
                }
            }
            this.modelControllerClient = newClient;
            if (storeState || this.currentProcessState == null) {
                this.currentProcessState = state;
            }
        }

        private synchronized ModelControllerClient getActiveModelControllerClient() {
            switch (this.currentProcessState) {
                case STOPPING: {
                    throw EmbeddedLogger.ROOT_LOGGER.processIsStopping();
                }
                case STOPPED: {
                    throw EmbeddedLogger.ROOT_LOGGER.processIsStopped();
                }
                case STARTING: 
                case RUNNING: {
                    if (this.modelControllerClient != null) break;
                    this.establishModelControllerClient(this.currentProcessState, false);
                    if (this.modelControllerClient != null) break;
                    throw EmbeddedLogger.ROOT_LOGGER.processIsReloading();
                }
            }
            return this.modelControllerClient;
        }

        @Override
        public void stop() {
            this.exit();
        }

        private void exit() {
            if (this.serviceContainer != null) {
                try {
                    this.serviceContainer.shutdown();
                    this.serviceContainer.awaitTermination();
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (InterruptedException ite) {
                    ite.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (this.controlledProcessStateService != null) {
                this.controlledProcessStateService.removePropertyChangeListener(this.processStateListener);
                this.controlledProcessStateService = null;
            }
            if (this.executorService != null) {
                try {
                    this.executorService.shutdown();
                    this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (InterruptedException ite) {
                    ite.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (this.uninstallStdIo) {
                try {
                    StdioContext.uninstall();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            SystemExiter.initialize((SystemExiter.Exiter)SystemExiter.Exiter.DEFAULT);
        }

        private static HostControllerEnvironment createHostControllerEnvironment(File jbossHome, String[] cmdargs, long startTime) {
            WildFlySecurityManager.setPropertyPrivileged("jboss.home.dir", jbossHome.getAbsolutePath());
            ArrayList<String> cmds = new ArrayList<String>(Arrays.asList(cmdargs));
            if (WildFlySecurityManager.getPropertyPrivileged("jboss.domain.master.address", null) == null) {
                WildFlySecurityManager.setPropertyPrivileged("jboss.domain.master.address", "127.0.0.1");
            }
            cmds.add(EmbeddedHostControllerFactory.MODULE_PATH);
            cmds.add(WildFlySecurityManager.getPropertyPrivileged("module.path", ""));
            cmds.add(EmbeddedHostControllerFactory.PC_ADDRESS);
            cmds.add("0");
            cmds.add(EmbeddedHostControllerFactory.PC_PORT);
            cmds.add("0");
            cmds.add("--admin-only");
            for (String prop : EmbeddedProcessFactory.DOMAIN_KEYS) {
                String value = WildFlySecurityManager.getPropertyPrivileged(prop, null);
                if (value == null) continue;
                cmds.add("-D" + prop + "=" + value);
            }
            return Main.determineEnvironment((String[])cmds.toArray(new String[cmds.size()]), (long)startTime, (ProcessType)ProcessType.EMBEDDED_HOST_CONTROLLER).getHostControllerEnvironment();
        }
    }
}

