/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.legacy;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.legacy.CommonLegacyConfiguration;
import org.jboss.ejb.client.legacy.JBossEJBProperties;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointBuilder;
import org.jboss.remoting3.spi.EndpointConfigurator;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;

public final class RemotingLegacyConfiguration
implements EndpointConfigurator {
    @Override
    public Endpoint getConfiguredEndpoint() {
        Endpoint endpoint;
        OptionMap endpointCreationOptions;
        JBossEJBProperties properties = JBossEJBProperties.getCurrent();
        if (properties == null) {
            return null;
        }
        Logs.MAIN.legacyEJBPropertiesRemotingConfigurationInUse();
        EndpointBuilder endpointBuilder = Endpoint.builder();
        String endpointName = properties.getEndpointName();
        if (endpointName != null) {
            endpointBuilder.setEndpointName(endpointName);
        }
        if ((endpointCreationOptions = properties.getEndpointCreationOptions()) != null && endpointCreationOptions.size() > 0) {
            if (!endpointCreationOptions.contains(Options.THREAD_DAEMON)) {
                endpointCreationOptions = OptionMap.builder().addAll(endpointCreationOptions).set(Options.THREAD_DAEMON, true).getMap();
            }
            endpointBuilder.buildXnioWorker(Xnio.getInstance()).populateFromOptions(endpointCreationOptions);
        }
        try {
            endpoint = endpointBuilder.build();
        }
        catch (IOException e) {
            throw Logs.MAIN.failedToConstructEndpoint(e);
        }
        List<JBossEJBProperties.ConnectionConfiguration> connectionList = properties.getConnectionList();
        for (JBossEJBProperties.ConnectionConfiguration connectionConfiguration : connectionList) {
            OptionMap connectionOptions;
            URI uri = CommonLegacyConfiguration.getUri(connectionConfiguration, connectionOptions = connectionConfiguration.getConnectionOptions());
            if (uri == null || !connectionConfiguration.isConnectEagerly()) continue;
            endpoint.getConnection(uri, "ejb", "jboss");
        }
        return endpoint;
    }
}

