/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.rules;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.protocols.rules.EventHandler;
import org.jgroups.protocols.rules.Rule;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@MBean(description="Supervises the running stack, taking corrective actions if necessary")
public class SUPERVISOR
extends Protocol {
    protected Address local_addr;
    protected volatile View view;
    protected TimeScheduler timer;
    protected final BoundedList<String> executions = new BoundedList(50);
    @Property(description="Location of an XML file listing the rules to be installed")
    protected String config;
    protected final Map<String, Tuple<Rule, Future<?>>> rules = new HashMap();
    protected final List<EventHandler> event_handlers = new ArrayList<EventHandler>();
    @ManagedAttribute(description="The number of registered EventHandler")
    protected volatile int num_event_handlers;
    protected static final String RULES = "rules";
    protected static final String RULE = "rule";
    protected static final String NAME = "name";
    protected static final String CLASS = "class";
    protected static final String INTERVAL = "interval";

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public View getView() {
        return this.view;
    }

    @ManagedOperation(description="Prints the last N conditions that triggered a rule action")
    public String executions() {
        StringBuilder sb = new StringBuilder();
        for (String execution : this.executions) {
            sb.append(execution + "\n");
        }
        return sb.toString();
    }

    public void addCondition(String cond) {
        this.executions.add(new Date() + ": " + cond);
    }

    @ManagedAttribute(description="The number of rules currently installed")
    public int getNumRules() {
        return this.rules.size();
    }

    @ManagedOperation(description="Prints all currently installed rules")
    public String dumpRules() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Tuple<Rule, Future<?>>> entry : this.rules.entrySet()) {
            String key = entry.getKey();
            Tuple<Rule, Future<?>> tuple = entry.getValue();
            Rule rule = tuple.getVal1();
            sb.append(key + ": " + rule.description() + "\n");
        }
        return sb.toString();
    }

    public void register(EventHandler handler) {
        if (handler != null) {
            this.event_handlers.add(handler);
            this.num_event_handlers = this.event_handlers.size();
        }
    }

    public void unregister(EventHandler handler) {
        if (handler != null) {
            this.event_handlers.remove(handler);
            this.num_event_handlers = this.event_handlers.size();
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new IllegalStateException("timer not found");
        }
        if (this.config != null) {
            this.parseConfig(this.config);
        }
    }

    @Override
    public void destroy() {
        for (Tuple<Rule, Future<?>> tuple : this.rules.values()) {
            tuple.getVal2().cancel(true);
        }
        this.rules.clear();
        super.destroy();
    }

    public void installRule(long interval, Rule rule) {
        this.installRule(null, interval, rule);
    }

    public void installRule(String name, long interval, Rule rule) {
        rule.supervisor(this).log(this.log).init();
        Future<?> future = this.timer.scheduleAtFixedRate(rule, interval, interval, TimeUnit.MILLISECONDS);
        Tuple<Rule, Future<?>> existing = this.rules.put(name != null ? name : rule.name(), new Tuple(rule, future));
        if (existing != null) {
            existing.getVal2().cancel(true);
        }
    }

    @ManagedOperation(description="Installs the given rule with the given classname")
    public void installRule(String name, long interval, String classname) throws Exception {
        Class clazz = Util.loadClass(classname, this.getClass());
        Rule rule = (Rule)clazz.newInstance();
        this.installRule(name, interval, rule);
    }

    @ManagedOperation(description="Installs the given rule with the given classname")
    public void installRule(long interval, String classname) throws Exception {
        this.installRule(null, interval, classname);
    }

    @ManagedOperation(description="Uninstalls the named rule")
    public void uninstallRule(String name) {
        Tuple<Rule, Future<?>> tuple;
        if (name != null && (tuple = this.rules.remove(name)) != null) {
            tuple.getVal2().cancel(true);
            tuple.getVal1().destroy();
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        if (this.num_event_handlers > 0) {
            for (EventHandler handler : this.event_handlers) {
                try {
                    handler.down(evt);
                }
                catch (Throwable t) {
                    this.log.error(Util.getMessage("EventHandlerFailedHandlingDownEvent"), t);
                }
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        if (this.num_event_handlers > 0) {
            for (EventHandler handler : this.event_handlers) {
                try {
                    handler.down(msg);
                }
                catch (Throwable t) {
                    this.log.error(Util.getMessage("EventHandlerFailedHandlingDownEvent"), t);
                }
            }
        }
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        if (this.num_event_handlers > 0) {
            for (EventHandler handler : this.event_handlers) {
                try {
                    handler.up(evt);
                }
                catch (Throwable t) {
                    this.log.error(Util.getMessage("EventHandlerFailedHandlingUpEvent"), t);
                }
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        if (this.num_event_handlers > 0) {
            for (Message msg : batch) {
                for (EventHandler handler : this.event_handlers) {
                    try {
                        handler.up(msg);
                    }
                    catch (Throwable t) {
                        this.log.error(Util.getMessage("EventHandlerFailedHandlingUpEvent"), t);
                    }
                }
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void handleView(View view) {
        this.view = view;
    }

    protected void parseConfig(String filename) throws Exception {
        InputStream input = null;
        try {
            input = ConfiguratorFactory.getConfigStream(filename);
            this.parseRules(input);
        }
        finally {
            Util.close((Closeable)input);
        }
    }

    protected void parseRules(InputStream input) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(input);
        Element root = document.getDocumentElement();
        SUPERVISOR.match(RULES, root.getNodeName(), true);
        NodeList children = root.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            String element_name = node.getNodeName();
            if (RULE.equals(element_name)) {
                this.parseRule(node);
                continue;
            }
            throw new Exception("expected <rule>, but got <" + element_name + ">");
        }
    }

    protected void parseRule(Node root) throws Exception {
        if (root.getNodeType() != 1) {
            return;
        }
        NamedNodeMap attrs = root.getAttributes();
        if (attrs == null || attrs.getLength() == 0) {
            return;
        }
        Attr name_attr = (Attr)attrs.getNamedItem(NAME);
        Attr classname_attr = (Attr)attrs.getNamedItem(CLASS);
        Attr interval_attr = (Attr)attrs.getNamedItem(INTERVAL);
        Class clazz = Util.loadClass(classname_attr.getValue(), this.getClass());
        Rule rule = (Rule)clazz.newInstance();
        long interval = Long.parseLong(interval_attr.getValue());
        this.installRule(name_attr.getValue(), interval, rule);
    }

    protected static void match(String expected_name, String name, boolean is_element) throws Exception {
        if (!expected_name.equals(name)) {
            throw new Exception((is_element ? "Element " : "Attribute ") + "\"" + name + "\" didn't match \"" + expected_name + "\"");
        }
    }
}

