/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineFormat;
import org.jboss.as.cli.EscapeSelector;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestHeader;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.ParsedOperationRequestHeader;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.SegmentParsingInitialState;
import org.jboss.as.cli.parsing.StateParser;
import org.jboss.logging.Logger;

public class OperationRequestCompleter
implements CommandLineCompleter {
    public static final OperationRequestCompleter INSTANCE = new OperationRequestCompleter();
    public static final CommandLineCompleter ARG_VALUE_COMPLETER = new CommandLineCompleter(){
        final DefaultCallbackHandler parsedOp = new DefaultCallbackHandler(false);

        @Override
        public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
            try {
                this.parsedOp.parseOperation(ctx.getCurrentNodePath(), buffer, ctx);
            }
            catch (CommandFormatException e) {
                return -1;
            }
            return INSTANCE.complete(ctx, this.parsedOp, buffer, cursor, candidates);
        }
    };
    public static final EscapeSelector ESCAPE_SELECTOR = new EscapeSelector(){

        @Override
        public boolean isEscape(char ch) {
            return ch == ':' || ch == '/' || ch == '=' || ch == ' ' || ch == '\"' || ch == '\\' || ch == '\'';
        }
    };
    public static final EscapeSelector ESCAPE_SELECTOR_INSIDE_QUOTES = new EscapeSelector(){

        @Override
        public boolean isEscape(char ch) {
            return ch == '\"' || ch == '\\';
        }
    };
    private static final Logger LOGGER = Logger.getLogger(OperationRequestCompleter.class);

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        return this.complete(ctx, ctx.getParsedCommandLine(), buffer, cursor, candidates);
    }

    public int complete(CommandContext ctx, OperationCandidatesProvider candidatesProvider, String buffer, int cursor, List<String> candidates) {
        return this.complete(ctx, ctx.getParsedCommandLine(), candidatesProvider, buffer, cursor, candidates);
    }

    public int complete(CommandContext ctx, ParsedCommandLine parsedCmd, String buffer, int cursor, List<String> candidates) {
        return this.complete(ctx, parsedCmd, ctx.getOperationCandidatesProvider(), buffer, cursor, candidates);
    }

    private int completeHeaders(CommandContext ctx, ParsedCommandLine parsedCmd, OperationCandidatesProvider candidatesProvider, String buffer, int cursor, List<String> candidates) {
        Map<String, OperationRequestHeader> headers = candidatesProvider.getHeaders(ctx);
        if (headers.isEmpty()) {
            return -1;
        }
        int result = buffer.length();
        if (parsedCmd.getLastHeaderName() != null) {
            if (buffer.endsWith(parsedCmd.getLastHeaderName())) {
                result = parsedCmd.getLastChunkIndex();
                for (String name : headers.keySet()) {
                    if (name.equals(parsedCmd.getLastHeaderName())) {
                        result = this.completeHeader(headers, ctx, parsedCmd, buffer, cursor, candidates);
                        break;
                    }
                    if (parsedCmd.hasHeader(name) || !name.startsWith(parsedCmd.getLastHeaderName())) continue;
                    candidates.add(name);
                }
            } else {
                result = this.completeHeader(headers, ctx, parsedCmd, buffer, cursor, candidates);
            }
        } else if (!parsedCmd.hasHeaders()) {
            candidates.addAll(headers.keySet());
        } else if (parsedCmd.endsOnHeaderSeparator()) {
            candidates.addAll(headers.keySet());
            for (ParsedOperationRequestHeader parsed : parsedCmd.getHeaders()) {
                candidates.remove(parsed.getName());
            }
        } else {
            ParsedOperationRequestHeader lastParsedHeader = parsedCmd.getLastHeader();
            OperationRequestHeader lastHeader = headers.get(lastParsedHeader.getName());
            if (lastHeader == null) {
                return -1;
            }
            CommandLineCompleter headerCompleter = lastHeader.getCompleter();
            if (headerCompleter == null) {
                return -1;
            }
            result = headerCompleter.complete(ctx, buffer, cursor, candidates);
        }
        Collections.sort(candidates);
        return result;
    }

    private int completeOperationName(CommandContext ctx, ParsedCommandLine parsedCmd, OperationCandidatesProvider candidatesProvider, String buffer, List<String> candidates) {
        if (parsedCmd.getAddress().endsOnType()) {
            return -1;
        }
        Collection<String> names = candidatesProvider.getOperationNames(ctx, parsedCmd.getAddress());
        if (names.isEmpty()) {
            return -1;
        }
        String chunk = parsedCmd.getOperationName();
        if (chunk == null) {
            candidates.addAll(names);
        } else {
            for (String name : names) {
                if (!name.startsWith(chunk)) continue;
                candidates.add(name);
            }
        }
        Collections.sort(candidates);
        if (parsedCmd.endsOnSeparator()) {
            return buffer.length();
        }
        if (chunk != null && candidates.size() == 1 && chunk.equals(candidates.get(0)) && parsedCmd.getFormat().getPropertyListStart().length() > 0) {
            candidates.set(0, chunk + parsedCmd.getFormat().getPropertyListStart());
        }
        return parsedCmd.getLastChunkIndex();
    }

    private int completeAddress(CommandContext ctx, ParsedCommandLine parsedCmd, OperationCandidatesProvider candidatesProvider, String buffer, List<String> candidates) {
        int offset;
        String chunk;
        OperationRequestAddress address = parsedCmd.getAddress();
        if (buffer.endsWith("..")) {
            return -1;
        }
        if (address.isEmpty() || parsedCmd.endsOnNodeSeparator() || parsedCmd.endsOnNodeTypeNameSeparator() || address.equals(ctx.getCurrentNodePath())) {
            chunk = null;
        } else if (address.endsOnType()) {
            chunk = address.getNodeType();
            address.toParentNode();
        } else {
            chunk = address.toNodeType();
        }
        Collection<String> names = address.endsOnType() ? candidatesProvider.getNodeNames(ctx, address) : candidatesProvider.getNodeTypes(ctx, address);
        if (names.isEmpty()) {
            return -1;
        }
        if (chunk == null) {
            candidates.addAll(names);
        } else {
            for (String name : names) {
                if (!name.startsWith(chunk)) continue;
                candidates.add(name);
            }
        }
        String lastSegment = "";
        if (parsedCmd.getSubstitutedLine().length() >= parsedCmd.getLastSeparatorIndex()) {
            lastSegment = parsedCmd.getSubstitutedLine().substring(parsedCmd.getLastSeparatorIndex() + 1);
        }
        SegmentParsingInitialState.SegmentParsingCallbackHandler parsedSegment = this.parseLastSegment(lastSegment);
        if (candidates.size() == 1) {
            String candidate = candidates.get(0);
            if (address.endsOnType()) {
                if (chunk != null && chunk.equals(candidate)) {
                    if (parsedSegment.isOpenQuotes()) {
                        candidates.set(0, "\"");
                    } else {
                        candidates.set(0, parsedCmd.getFormat().getAddressOperationSeparator());
                        candidates.add(parsedCmd.getFormat().getNodeSeparator());
                    }
                    return buffer.length();
                }
                if (parsedSegment.isOpenQuotes()) {
                    String escapedCandidate = Util.escapeString(candidate, ESCAPE_SELECTOR_INSIDE_QUOTES);
                    offset = parsedSegment.getOffset() - 1;
                    candidates.set(0, "\"" + escapedCandidate + "\"");
                } else {
                    String escapedCandidate = Util.escapeString(candidate, ESCAPE_SELECTOR);
                    offset = parsedSegment.getOffset();
                    candidates.set(0, escapedCandidate);
                }
            } else {
                if (chunk != null && chunk.equals(candidate)) {
                    if (parsedSegment.isOpenQuotes()) {
                        candidates.set(0, "\"");
                    } else {
                        candidates.set(0, "=");
                    }
                    return buffer.length();
                }
                if (parsedSegment.isOpenQuotes()) {
                    String escapedCandidate = Util.escapeString(candidate, ESCAPE_SELECTOR_INSIDE_QUOTES);
                    offset = parsedSegment.getOffset() - 1;
                    candidates.set(0, "\"" + escapedCandidate + "\"=");
                } else {
                    String escapedCandidate = Util.escapeString(candidate, ESCAPE_SELECTOR);
                    offset = parsedSegment.getOffset();
                    candidates.set(0, escapedCandidate + "=");
                }
            }
        } else {
            if (parsedSegment.isOpenQuotes()) {
                Util.sortAndEscape(candidates, ESCAPE_SELECTOR_INSIDE_QUOTES);
            } else {
                Util.sortAndEscape(candidates, ESCAPE_SELECTOR);
            }
            offset = parsedSegment.getOffset();
        }
        return parsedCmd.getLastSeparatorIndex() + 1 + offset;
    }

    private int completeImplicitValueProperties(CommandContext ctx, String buffer, Collection<CommandArgument> allArgs, List<String> candidates) {
        try {
            for (CommandArgument arg : allArgs) {
                if (!arg.canAppearNext(ctx) || arg.isValueRequired()) continue;
                candidates.add(arg.getDecoratedName());
            }
            Collections.sort(candidates);
            return buffer.length();
        }
        catch (CommandFormatException e) {
            return -1;
        }
    }

    private int completeNoPropertiesProvided(CommandContext ctx, String buffer, Collection<CommandArgument> allArgs, List<String> candidates) {
        try {
            boolean needNeg = false;
            for (CommandArgument arg : allArgs) {
                if (!arg.canAppearNext(ctx)) continue;
                if (arg.getIndex() >= 0) {
                    CommandLineCompleter valCompl = arg.getValueCompleter();
                    if (valCompl == null) continue;
                    valCompl.complete(ctx, "", 0, candidates);
                    continue;
                }
                candidates.add(arg.getDecoratedName());
                if (arg.isValueRequired()) continue;
                needNeg = true;
            }
            if (needNeg) {
                candidates.add("!");
            }
            Collections.sort(candidates);
            return buffer.length();
        }
        catch (CommandFormatException e) {
            return -1;
        }
    }

    private int completeNoProperties(ParsedCommandLine parsedCmd, String buffer, List<String> candidates) {
        CommandLineFormat format = parsedCmd.getFormat();
        if (!parsedCmd.hasProperties() && format != null && format.getPropertyListEnd() != null && format.getPropertyListEnd().length() > 0) {
            candidates.add(format.getPropertyListEnd());
        }
        return buffer.length();
    }

    private int completeNoValueCompleter(CommandContext ctx, ParsedCommandLine parsedCmd, Collection<CommandArgument> allArgs, String argName, String buffer, List<String> candidates) {
        CommandLineFormat format;
        if (parsedCmd.endsOnSeparator()) {
            return -1;
        }
        for (CommandArgument arg : allArgs) {
            try {
                if (!arg.canAppearNext(ctx) || arg.getFullName().equals(argName)) continue;
                return -1;
            }
            catch (CommandFormatException e) {
                break;
            }
        }
        if ((format = parsedCmd.getFormat()) != null && format.getPropertyListEnd() != null && format.getPropertyListEnd().length() > 0) {
            candidates.add(format.getPropertyListEnd());
        }
        return buffer.length();
    }

    private int completeWithValueCompleter(CommandContext ctx, ParsedCommandLine parsedCmd, Collection<CommandArgument> allArgs, String argName, String buffer, List<String> candidates, String chunk, int result, CommandLineCompleter valueCompleter) {
        CommandLineFormat format;
        if (chunk == null) {
            for (CommandArgument arg : allArgs) {
                String argFullName = arg.getFullName();
                if (!argFullName.equals(argName) || arg.isValueRequired()) continue;
                candidates.add("false");
                return parsedCmd.getLastChunkIndex();
            }
        }
        StateParser.SubstitutedLine substitutions = parsedCmd.getSubstitutions();
        String normalizedChunk = chunk == null ? "" : chunk;
        int valueResult = valueCompleter.complete(ctx, normalizedChunk, normalizedChunk.length(), candidates);
        if (valueResult < 0) {
            return valueResult;
        }
        if (this.suggestionEqualsUserEntry(candidates, chunk, valueResult) && (format = parsedCmd.getFormat()) != null) {
            for (CommandArgument arg : allArgs) {
                try {
                    if (!arg.canAppearNext(ctx)) continue;
                    candidates.set(0, "" + format.getPropertySeparator());
                    return buffer.length();
                }
                catch (CommandFormatException e) {
                    return -1;
                }
            }
            candidates.set(0, format.getPropertyListEnd());
            return buffer.length();
        }
        int trailOffset = substitutions.getSubstitued().substring(result).length() - normalizedChunk.length();
        return result + valueResult + trailOffset;
    }

    private int completeArgumentValueAndPropertyNames(CommandContext ctx, ParsedCommandLine parsedCmd, Collection<CommandArgument> allArgs, List<String> candidates, String chunk, int result) {
        CommandLineFormat format;
        String argFullName;
        CommandArgument lastArg = null;
        boolean allPropertiesPresent = true;
        for (CommandArgument arg : allArgs) {
            try {
                if (arg.canAppearNext(ctx)) {
                    allPropertiesPresent = false;
                    continue;
                }
                if (!arg.getFullName().equals(chunk)) continue;
                lastArg = arg;
            }
            catch (CommandFormatException e) {
                return -1;
            }
        }
        boolean needNeg = false;
        boolean optionMatch = false;
        for (CommandArgument arg : allArgs) {
            try {
                if (!arg.canAppearNext(ctx) || arg.getIndex() >= 0) continue;
                argFullName = arg.getFullName();
                if (chunk == null || !argFullName.startsWith(chunk)) continue;
                if (!parsedCmd.isLastPropertyNegated()) {
                    optionMatch = true;
                    break;
                }
                if (arg.isValueRequired()) continue;
                optionMatch = true;
                break;
            }
            catch (CommandFormatException e) {
                return -1;
            }
        }
        for (CommandArgument arg : allArgs) {
            try {
                if (!arg.canAppearNext(ctx)) continue;
                if (arg.getIndex() >= 0) {
                    CommandLineCompleter valCompl;
                    if (optionMatch || (valCompl = arg.getValueCompleter()) == null) continue;
                    String value = chunk == null ? "" : chunk;
                    valCompl.complete(ctx, value, value.length(), candidates);
                    continue;
                }
                argFullName = arg.getFullName();
                if (chunk == null || argFullName.startsWith(chunk)) {
                    if (!parsedCmd.isLastPropertyNegated()) {
                        candidates.add(arg.getDecoratedName());
                    } else if (!arg.isValueRequired()) {
                        candidates.add(arg.getDecoratedName());
                    }
                }
                if (arg.isValueRequired() || parsedCmd.isLastPropertyNegated()) continue;
                needNeg = true;
            }
            catch (CommandFormatException e) {
                return -1;
            }
        }
        if (needNeg && parsedCmd.endsOnPropertySeparator()) {
            candidates.add("!");
        }
        if (lastArg != null) {
            if (lastArg.isValueRequired()) {
                candidates.add(lastArg.getFullName() + "=");
            } else if (lastArg instanceof ArgumentWithoutValue) {
                CommandLineFormat format2;
                ArgumentWithoutValue argWithoutValue = (ArgumentWithoutValue)lastArg;
                if (!argWithoutValue.isExclusive() && !allPropertiesPresent && (format2 = parsedCmd.getFormat()) != null && format2.getPropertySeparator() != null) {
                    candidates.add(lastArg.getFullName() + format2.getPropertySeparator());
                }
            } else {
                format = parsedCmd.getFormat();
                if (!parsedCmd.isLastPropertyNegated()) {
                    candidates.add("=false");
                }
                if (format != null && format.getPropertyListEnd() != null && format.getPropertyListEnd().length() > 0) {
                    candidates.add(format.getPropertyListEnd());
                    if (!allPropertiesPresent) {
                        candidates.add(format.getPropertySeparator());
                    }
                }
            }
        }
        if (candidates.isEmpty()) {
            if (chunk == null && !parsedCmd.endsOnSeparator() && (format = parsedCmd.getFormat()) != null && format.getPropertyListEnd() != null && format.getPropertyListEnd().length() > 0) {
                candidates.add(format.getPropertyListEnd());
            }
        } else {
            Collections.sort(candidates);
        }
        return result;
    }

    private int completeProperties(CommandContext ctx, ParsedCommandLine parsedCmd, OperationCandidatesProvider candidatesProvider, String buffer, List<String> candidates) {
        if (!parsedCmd.hasOperationName()) {
            return -1;
        }
        Collection<CommandArgument> allArgs = candidatesProvider.getProperties(ctx, parsedCmd.getOperationName(), parsedCmd.getAddress());
        if (allArgs.isEmpty()) {
            return this.completeNoProperties(parsedCmd, buffer, candidates);
        }
        if (parsedCmd.endsOnNotOperator()) {
            return this.completeImplicitValueProperties(ctx, buffer, allArgs, candidates);
        }
        if (!parsedCmd.hasProperties()) {
            return this.completeNoPropertiesProvided(ctx, buffer, allArgs, candidates);
        }
        int result = buffer.length();
        String chunk = null;
        if (!parsedCmd.endsOnPropertySeparator()) {
            String argName = parsedCmd.getLastParsedPropertyName();
            String argValue = parsedCmd.getLastParsedPropertyValue();
            if (argValue != null || parsedCmd.endsOnPropertyValueSeparator()) {
                result = parsedCmd.getLastChunkIndex();
                if (parsedCmd.endsOnPropertyValueSeparator()) {
                    ++result;
                }
                chunk = argValue;
                CommandLineCompleter valueCompleter = null;
                valueCompleter = argName != null ? this.getValueCompleter(ctx, allArgs, argName) : this.getValueCompleter(ctx, allArgs, parsedCmd.getOtherProperties().size() - 1);
                if (valueCompleter == null) {
                    return this.completeNoValueCompleter(ctx, parsedCmd, allArgs, argName, buffer, candidates);
                }
                return this.completeWithValueCompleter(ctx, parsedCmd, allArgs, argName, buffer, candidates, chunk, result, valueCompleter);
            }
            chunk = argName;
            result = parsedCmd.getLastChunkIndex();
        }
        return this.completeArgumentValueAndPropertyNames(ctx, parsedCmd, allArgs, candidates, chunk, result);
    }

    protected int complete(CommandContext ctx, ParsedCommandLine parsedCmd, OperationCandidatesProvider candidatesProvider, String buffer, int cursor, List<String> candidates) {
        if (parsedCmd.isRequestComplete()) {
            return -1;
        }
        if (parsedCmd.endsOnHeaderListStart() || parsedCmd.hasHeaders()) {
            return this.completeHeaders(ctx, parsedCmd, candidatesProvider, buffer, cursor, candidates);
        }
        if (parsedCmd.endsOnPropertyListEnd()) {
            return buffer.length();
        }
        if (parsedCmd.hasProperties() || parsedCmd.endsOnPropertyListStart() || parsedCmd.endsOnNotOperator()) {
            return this.completeProperties(ctx, parsedCmd, candidatesProvider, buffer, candidates);
        }
        if (parsedCmd.hasOperationName() || parsedCmd.endsOnAddressOperationNameSeparator()) {
            return this.completeOperationName(ctx, parsedCmd, candidatesProvider, buffer, candidates);
        }
        return this.completeAddress(ctx, parsedCmd, candidatesProvider, buffer, candidates);
    }

    private SegmentParsingInitialState.SegmentParsingCallbackHandler parseLastSegment(String chunk) {
        SegmentParsingInitialState.SegmentParsingCallbackHandler handler = new SegmentParsingInitialState.SegmentParsingCallbackHandler();
        try {
            StateParser.parse(chunk, handler, SegmentParsingInitialState.INSTANCE, false);
        }
        catch (CommandFormatException e) {
            LOGGER.debug((Object)"Error when parsing last chunk of operation request", e);
        }
        return handler;
    }

    private boolean suggestionEqualsUserEntry(List<String> candidates, String chunk, int suggestionOffset) {
        if (chunk == null || candidates.size() != 1) {
            return false;
        }
        if (suggestionOffset > 0) {
            return chunk.substring(suggestionOffset).equals(candidates.get(0));
        }
        return chunk.equals(candidates.get(0));
    }

    protected CommandLineCompleter getValueCompleter(CommandContext ctx, Iterable<CommandArgument> allArgs, String argName) {
        CommandLineCompleter result = null;
        for (CommandArgument arg : allArgs) {
            if (arg.getFullName().equals(argName)) {
                return arg.getValueCompleter();
            }
            if (arg.getIndex() != Integer.MAX_VALUE) continue;
            result = arg.getValueCompleter();
        }
        return result;
    }

    protected CommandLineCompleter getValueCompleter(CommandContext ctx, Iterable<CommandArgument> allArgs, int index) {
        CommandLineCompleter maxIndex = null;
        for (CommandArgument arg : allArgs) {
            if (arg.getIndex() == index) {
                return arg.getValueCompleter();
            }
            if (arg.getIndex() != Integer.MAX_VALUE) continue;
            maxIndex = arg.getValueCompleter();
        }
        return maxIndex;
    }

    private int completeHeader(Map<String, OperationRequestHeader> headers, CommandContext ctx, ParsedCommandLine parsedCmd, String buffer, int cursor, List<String> candidates) {
        OperationRequestHeader header = headers.get(parsedCmd.getLastHeaderName());
        if (header == null) {
            return -1;
        }
        CommandLineCompleter headerCompleter = header.getCompleter();
        if (headerCompleter == null) {
            return -1;
        }
        int valueResult = headerCompleter.complete(ctx, buffer.substring(parsedCmd.getLastChunkIndex()), cursor, candidates);
        if (valueResult < 0) {
            return -1;
        }
        return parsedCmd.getLastChunkIndex() + valueResult;
    }
}

