/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.util.EnumSet;
import java.util.Iterator;
import org.wildfly.security.ssl.Authentication;
import org.wildfly.security.ssl.CipherSuitePredicate;
import org.wildfly.security.ssl.MechanismDatabase;

final class AuthenticationCipherSuitePredicate
extends CipherSuitePredicate {
    private final boolean accept;
    private final EnumSet<Authentication> set;

    AuthenticationCipherSuitePredicate(boolean accept, EnumSet<Authentication> set) {
        this.accept = accept;
        this.set = set;
    }

    @Override
    void toString(StringBuilder b) {
        b.append("authentication is one of (");
        Iterator iterator = this.set.iterator();
        if (iterator.hasNext()) {
            Authentication authentication = (Authentication)((Object)iterator.next());
            b.append((Object)authentication);
            while (iterator.hasNext()) {
                authentication = (Authentication)((Object)iterator.next());
                b.append(", ");
                b.append((Object)authentication);
            }
        }
        b.append(')');
    }

    @Override
    boolean test(MechanismDatabase.Entry entry) {
        return this.set.contains((Object)entry.getAuthentication()) == this.accept;
    }

    @Override
    boolean isAlwaysTrue() {
        return this.set.size() == Authentication.fullSize;
    }

    @Override
    boolean isAlwaysFalse() {
        return this.set.isEmpty();
    }
}

