/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.command.AeshCommandRuntimeBuilder;
import org.aesh.command.Command;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandRuntime;
import org.aesh.command.Executor;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.converter.ConverterInvocation;
import org.aesh.command.export.ExportCommand;
import org.aesh.command.export.ExportCompletion;
import org.aesh.command.export.ExportManager;
import org.aesh.command.export.ExportPreProcessor;
import org.aesh.command.impl.AeshCommandResolver;
import org.aesh.command.impl.completer.AeshCompletionHandler;
import org.aesh.command.impl.invocation.AeshCommandInvocationBuilder;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.operator.OperatorType;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.registry.MutableCommandRegistry;
import org.aesh.command.settings.Settings;
import org.aesh.command.settings.SettingsBuilder;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.command.validator.ValidatorInvocation;
import org.aesh.complete.AeshCompleteOperation;
import org.aesh.readline.AeshContext;
import org.aesh.readline.Console;
import org.aesh.readline.DefaultAeshContext;
import org.aesh.readline.ProcessManager;
import org.aesh.readline.Prompt;
import org.aesh.readline.Readline;
import org.aesh.readline.ShellImpl;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.readline.history.InMemoryHistory;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.aesh.terminal.Connection;
import org.aesh.util.LoggerUtil;
import org.aesh.utils.Config;

public class ReadlineConsole
implements Console,
Consumer<Connection> {
    private Settings<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation, ? extends ConverterInvocation, ? extends CompleterInvocation, ? extends ValidatorInvocation, ? extends OptionActivator, ? extends CommandActivator> settings;
    private Prompt prompt;
    private List<Completion> completions;
    private Connection connection;
    private AeshCommandResolver<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation> commandResolver;
    private AeshContext context;
    private Readline readline;
    private AeshCompletionHandler completionHandler;
    private CommandRuntime<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation> runtime;
    private ProcessManager processManager;
    private ExportManager exportManager;
    private static List<Function<String, Optional<String>>> preProcessors = new ArrayList<Function<String, Optional<String>>>();
    private static final Logger LOGGER = LoggerUtil.getLogger(ReadlineConsole.class.getName());
    private volatile boolean running = false;
    private ShellImpl shell;

    public ReadlineConsole(Settings<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation, ? extends ConverterInvocation, ? extends CompleterInvocation, ? extends ValidatorInvocation, ? extends OptionActivator, ? extends CommandActivator> givenSettings) {
        LoggerUtil.doLog();
        this.settings = givenSettings == null ? SettingsBuilder.builder().build() : givenSettings;
        this.commandResolver = new AeshCommandResolver<Command<? extends CommandInvocation>, CommandInvocation>(this.settings.commandRegistry());
        this.addCompletion(new AeshCompletion());
        if (this.settings.connection() != null) {
            this.connection = this.settings.connection();
        }
        if (this.settings.exportEnabled()) {
            this.exportManager = new ExportManager(this.settings.exportFile(), this.settings.exportUsesSystemEnvironment(), this.settings.exportListener());
            preProcessors.add(new ExportPreProcessor(this.exportManager));
            this.completions.add(new ExportCompletion(this.exportManager));
            if (this.commandResolver.getRegistry() != null && this.commandResolver.getRegistry() instanceof MutableCommandRegistry) {
                try {
                    ((MutableCommandRegistry)this.commandResolver.getRegistry()).addCommand(new ExportCommand(this.exportManager));
                }
                catch (CommandLineParserException e) {
                    e.printStackTrace();
                }
            }
        }
        this.context = new DefaultAeshContext(this.exportManager);
    }

    public void start() throws IOException {
        this.init();
        if (this.connection == null) {
            new TerminalConnection(Charset.defaultCharset(), this.settings.stdIn(), this.settings.stdOut(), this);
        } else {
            this.accept(this.connection);
        }
    }

    @Override
    public void stop() {
        this.running = false;
    }

    @Override
    public boolean running() {
        return this.running;
    }

    @Override
    public void accept(Connection connection) {
        if (this.connection == null) {
            this.connection = connection;
        }
        this.runtime = this.generateRuntime();
        this.read(this.connection, this.readline);
        this.processManager = new ProcessManager(this);
        this.connection.openBlocking();
    }

    private void init() {
        this.completionHandler = new AeshCompletionHandler(this.context);
        if (this.prompt == null) {
            this.prompt = new Prompt("");
        }
        this.readline = new Readline(EditModeBuilder.builder(this.settings.mode()).create(), new InMemoryHistory(50), this.completionHandler);
        this.running = true;
    }

    @Override
    public void read() {
        this.read(this.connection, this.readline);
    }

    @Override
    public void read(Connection conn, Readline readline) {
        this.shell.printCollectedOutput();
        if (this.running) {
            readline.readline(conn, this.prompt, line -> {
                if (line == null) {
                    conn.write("logout\n").close();
                    return;
                }
                if (line.trim().length() > 0) {
                    this.shell.startCollectOutput();
                    this.processLine((String)line, conn);
                } else {
                    this.read(conn, readline);
                }
            }, this.completions, preProcessors);
        } else {
            LOGGER.info("not running, returning");
            conn.close();
            if (this.settings.quitHandler() != null) {
                this.settings.quitHandler().quit();
            }
        }
    }

    private void processLine(String line, Connection conn) {
        try {
            Executor<? extends CommandInvocation> executor = this.runtime.buildExecutor(line);
            this.processManager.execute(executor, conn);
        }
        catch (IllegalArgumentException e) {
            conn.write(line + ": command not found\n");
        }
        catch (CommandNotFoundException cnfe) {
            if (this.settings.commandNotFoundHandler() != null) {
                this.settings.commandNotFoundHandler().handleCommandNotFound(line, new ShellImpl(conn, this.readline));
            } else {
                conn.write(cnfe.getMessage() + Config.getLineSeparator());
            }
            this.read(conn, this.readline);
        }
        catch (CommandLineParserException | CommandValidatorException | OptionValidatorException e) {
            conn.write(e.getMessage() + Config.getLineSeparator());
            this.read(conn, this.readline);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Got exception while starting new process", e);
            this.read(conn, this.readline);
        }
    }

    @Override
    public Prompt prompt() {
        return this.prompt;
    }

    @Override
    public void setPrompt(Prompt prompt) {
        if (prompt != null) {
            this.prompt = prompt;
        }
    }

    @Override
    public void setPrompt(String prompt) {
        if (prompt != null) {
            this.prompt = new Prompt(prompt);
        }
    }

    @Override
    public AeshContext context() {
        return this.context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String helpInfo(String commandName) {
        try (CommandContainer<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation> commandContainer = this.commandResolver.resolveCommand(commandName);){
            if (commandContainer == null) return "";
            String string = commandContainer.printHelp(commandName);
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void addCompletion(Completion completion) {
        if (this.completions == null) {
            this.completions = new ArrayList<Completion>();
        }
        this.completions.add(completion);
    }

    public void addCompletions(List<Completion> completions) {
        if (this.completions == null) {
            this.completions = new ArrayList<Completion>();
        }
        this.completions.addAll(completions);
    }

    private CommandRuntime<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation> generateRuntime() {
        this.shell = new ShellImpl(this.connection, this.readline);
        return AeshCommandRuntimeBuilder.builder().settings(this.settings).commandInvocationBuilder(new AeshCommandInvocationBuilder(this.shell, this)).aeshContext(this.context).operators(EnumSet.allOf(OperatorType.class)).build();
    }

    class AeshCompletion
    implements Completion<AeshCompleteOperation> {
        AeshCompletion() {
        }

        @Override
        public void complete(AeshCompleteOperation completeOperation) {
            ReadlineConsole.this.runtime.complete(completeOperation);
        }
    }
}

