/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import io.undertow.util.ObjectPool;
import io.undertow.util.PooledObject;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SimpleObjectPool<T>
implements ObjectPool {
    private final Supplier<T> supplier;
    private final Consumer<T> consumer;
    private final LinkedBlockingDeque<T> pool;

    public SimpleObjectPool(int poolSize, Supplier<T> supplier, Consumer<T> consumer) {
        this.supplier = supplier;
        this.consumer = consumer;
        this.pool = new LinkedBlockingDeque(poolSize);
    }

    public PooledObject allocate() {
        T obj = this.pool.poll();
        if (obj == null) {
            obj = this.supplier.get();
        }
        final T finObj = obj;
        return new PooledObject(){
            private volatile boolean closed = false;

            @Override
            public T getObject() {
                if (this.closed) {
                    throw UndertowMessages.MESSAGES.objectIsClosed();
                }
                return finObj;
            }

            @Override
            public void close() {
                this.closed = true;
                if (!SimpleObjectPool.this.pool.offer(finObj)) {
                    SimpleObjectPool.this.consumer.accept(finObj);
                }
            }
        };
    }
}

