/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.Protocol;
import org.jgroups.util.NameCache;

@MBean(description="Protocol to inject an arbitrary view in nodes")
public class INJECT_VIEW
extends Protocol {
    public static final String NODE_VIEWS_SEPARATOR = ";";
    public static final String VIEW_SEPARATOR = "=";
    public static final String NAMES_SEPARATOR = "/";

    @ManagedOperation(description="Inject a view (example of view string format: A=A/B/C;B=B/C;C=C)")
    public synchronized void injectView(String newView) {
        try {
            this.log.info("Received request to inject view %s", newView);
            String[] perNode = newView.split(NODE_VIEWS_SEPARATOR);
            String thisNodeAddress = this.getProtocolStack().getChannel().getAddressAsString();
            for (String nodeView : perNode) {
                if (!nodeView.startsWith(thisNodeAddress)) continue;
                this.log.info("[channel: %s] Injecting a new view: %s", thisNodeAddress, nodeView);
                long viewId = this.getProtocolStack().getChannel().getView().getViewId().getId() + 1L;
                ArrayList<Address> nodes = new ArrayList<Address>();
                block3: for (String nodeName : nodeView.split(VIEW_SEPARATOR)[1].split(NAMES_SEPARATOR)) {
                    for (Map.Entry<Address, String> entry : NameCache.getContents().entrySet()) {
                        if (!nodeName.equals(entry.getValue())) continue;
                        this.log.debug("[channel: %s] Found name: <%s> for address: <%s>", entry.getValue(), entry.getKey().toString());
                        nodes.add(entry.getKey());
                        continue block3;
                    }
                }
                View view = new View((Address)nodes.get(0), viewId, nodes);
                GMS gms = (GMS)this.getProtocolStack().findProtocol((Class<? extends Protocol>)GMS.class);
                gms.installView(view);
                this.log.info("[channel: %s] Injection finished of view: %s", thisNodeAddress, nodeView);
            }
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), e);
        }
    }
}

