/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.util.concurrent.CountDownLatch;
import org.aesh.command.shell.Shell;
import org.aesh.readline.Prompt;
import org.aesh.readline.Readline;
import org.aesh.readline.action.ActionDecoder;
import org.aesh.readline.terminal.Key;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Size;
import org.aesh.utils.ANSI;
import org.aesh.utils.Config;

class ShellImpl
implements Shell {
    private Connection connection;
    private Readline readline;
    private StringBuilder outputCollector;

    ShellImpl(Connection connection, Readline readline) {
        this.connection = connection;
        this.readline = readline;
    }

    void startCollectOutput() {
        this.outputCollector = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printCollectedOutput() {
        if (this.outputCollector == null) {
            return;
        }
        try {
            String line = this.outputCollector.toString();
            if (line.isEmpty()) {
                return;
            }
            String[] lines = line.split("\\R", -1);
            int max = this.connection.size().getHeight();
            int currentLines = 0;
            int allLines = 0;
            while (allLines < lines.length) {
                if (currentLines > max - 2) {
                    try {
                        this.connection.write(ANSI.CURSOR_SAVE);
                        int percentage = allLines * 100 / lines.length;
                        this.connection.write("--More(" + percentage + "%)--");
                        Key k = this.read();
                        this.connection.write(ANSI.CURSOR_RESTORE);
                        this.connection.stdoutHandler().accept(ANSI.ERASE_LINE_FROM_CURSOR);
                        if (k == null) {
                            allLines = lines.length;
                            continue;
                        }
                        switch (k) {
                            case SPACE: {
                                currentLines = 0;
                                break;
                            }
                            case ENTER: 
                            case CTRL_M: {
                                --currentLines;
                                break;
                            }
                            case q: {
                                allLines = lines.length;
                            }
                        }
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(ex);
                    }
                }
                String l = lines[allLines];
                ++currentLines;
                if (++allLines == lines.length && l.isEmpty()) continue;
                this.connection.write(l + Config.getLineSeparator());
            }
        }
        finally {
            this.outputCollector = null;
        }
    }

    @Override
    public void write(String msg, boolean page) {
        if (this.connection.supportsAnsi() && page) {
            if (this.outputCollector == null) {
                this.outputCollector = new StringBuilder();
            }
            this.outputCollector.append(msg);
        } else {
            this.connection.write(msg);
        }
    }

    @Override
    public void writeln(String msg, boolean page) {
        if (this.connection.supportsAnsi() && page) {
            if (this.outputCollector == null) {
                this.outputCollector = new StringBuilder();
            }
            this.outputCollector.append(msg).append(Config.getLineSeparator());
        } else {
            this.connection.write(msg + Config.getLineSeparator());
        }
    }

    @Override
    public void write(int[] out) {
        this.connection.stdoutHandler().accept(out);
    }

    @Override
    public void write(char out) {
        this.connection.stdoutHandler().accept(new int[]{out});
    }

    @Override
    public String readLine() throws InterruptedException {
        return this.readLine(new Prompt(""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLine(Prompt prompt) throws InterruptedException {
        this.printCollectedOutput();
        this.startCollectOutput();
        String[] out = new String[]{null};
        CountDownLatch latch = new CountDownLatch(1);
        this.readline.readline(this.connection, prompt, event -> {
            out[0] = event;
            latch.countDown();
        });
        try {
            latch.await();
        }
        finally {
            this.connection.setStdinHandler(null);
        }
        return out[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key read() throws InterruptedException {
        ActionDecoder decoder = new ActionDecoder();
        Key[] key = new Key[]{null};
        CountDownLatch latch = new CountDownLatch(1);
        Attributes attributes = this.connection.enterRawMode();
        try {
            this.connection.setStdinHandler(keys -> {
                decoder.add((int[])keys);
                if (decoder.hasNext()) {
                    key[0] = Key.findStartKey(decoder.next().buffer().array());
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            finally {
                this.connection.setStdinHandler(null);
            }
        }
        finally {
            this.connection.setAttributes(attributes);
        }
        return key[0];
    }

    @Override
    public Key read(Prompt prompt) throws InterruptedException {
        return null;
    }

    @Override
    public boolean enableAlternateBuffer() {
        return this.connection.put(Capability.enter_ca_mode, new Object[0]);
    }

    @Override
    public boolean enableMainBuffer() {
        return this.connection.put(Capability.exit_ca_mode, new Object[0]);
    }

    @Override
    public Size size() {
        return this.connection.size();
    }

    @Override
    public void clear() {
        this.connection.put(Capability.clear_screen, new Object[0]);
    }
}

