/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.security.SecureRandom;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Constructable;
import org.jgroups.util.NameCache;

public class UUID
implements Address,
Constructable<UUID> {
    protected long mostSigBits;
    protected long leastSigBits;
    protected static volatile SecureRandom numberGenerator = null;
    protected static final int SIZE = 16;

    public UUID() {
    }

    public UUID(long mostSigBits, long leastSigBits) {
        this.mostSigBits = mostSigBits;
        this.leastSigBits = leastSigBits;
    }

    protected UUID(byte[] data) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        if (data.length != 16) {
            throw new RuntimeException("UUID needs a 16-byte array");
        }
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        this.mostSigBits = msb;
        this.leastSigBits = lsb;
    }

    @Override
    public Supplier<? extends UUID> create() {
        return UUID::new;
    }

    public static UUID randomUUID() {
        return new UUID(UUID.generateRandomBytes(16));
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public String toString() {
        String val = NameCache.get(this);
        return val != null ? val : this.toStringLong();
    }

    public String toStringLong() {
        return UUID.digits(this.mostSigBits >> 32, 8) + "-" + UUID.digits(this.mostSigBits >> 16, 4) + "-" + UUID.digits(this.mostSigBits, 4) + "-" + UUID.digits(this.leastSigBits >> 48, 4) + "-" + UUID.digits(this.leastSigBits, 12);
    }

    public static UUID fromString(String name) {
        String[] components = name.split("-");
        if (components.length != 5) {
            throw new IllegalArgumentException("Invalid UUID string: " + name);
        }
        for (int i = 0; i < 5; ++i) {
            components[i] = "0x" + components[i];
        }
        long mostSigBits = Long.decode(components[0]);
        mostSigBits <<= 16;
        mostSigBits |= Long.decode(components[1]).longValue();
        mostSigBits <<= 16;
        long leastSigBits = Long.decode(components[3]);
        leastSigBits <<= 48;
        return new UUID(mostSigBits |= Long.decode(components[2]).longValue(), leastSigBits |= Long.decode(components[4]).longValue());
    }

    protected static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public int hashCode() {
        return (int)(this.mostSigBits >> 32 ^ this.mostSigBits ^ this.leastSigBits >> 32 ^ this.leastSigBits);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UUID)) {
            return false;
        }
        UUID id = (UUID)obj;
        return this == id || this.mostSigBits == id.mostSigBits && this.leastSigBits == id.leastSigBits;
    }

    @Override
    public int compareTo(Address other) {
        UUID val = (UUID)other;
        if (this == val) {
            return 0;
        }
        return this.mostSigBits < val.mostSigBits ? -1 : (this.mostSigBits > val.mostSigBits ? 1 : (this.leastSigBits < val.leastSigBits ? -1 : (this.leastSigBits > val.leastSigBits ? 1 : 0)));
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        out.writeLong(this.leastSigBits);
        out.writeLong(this.mostSigBits);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.leastSigBits = in.readLong();
        this.mostSigBits = in.readLong();
    }

    @Override
    public int serializedSize() {
        return 16;
    }

    public UUID copy() {
        return new UUID(this.mostSigBits, this.leastSigBits);
    }

    public static byte[] generateRandomBytes() {
        return UUID.generateRandomBytes(16);
    }

    public static byte[] generateRandomBytes(int size) {
        SecureRandom ng = numberGenerator;
        if (ng == null) {
            numberGenerator = ng = new SecureRandom();
        }
        byte[] randomBytes = new byte[size];
        ng.nextBytes(randomBytes);
        return randomBytes;
    }
}

