/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Version;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.NioBaseServer;
import org.jgroups.blocks.cs.Receiver;
import org.jgroups.nio.Buffers;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.CondVar;
import org.jgroups.util.Condition;
import org.jgroups.util.Util;

public class NioConnection
extends Connection {
    protected SocketChannel channel;
    protected SelectionKey key;
    protected final NioBaseServer server;
    protected final Buffers send_buf;
    protected boolean write_interest_set;
    protected boolean copy_on_partial_write = true;
    protected int partial_writes;
    protected final Lock send_lock = new ReentrantLock();
    protected Buffers recv_buf = new Buffers(4).add(ByteBuffer.allocate(cookie.length));
    protected Reader reader = new Reader();
    protected long reader_idle_time = 20000L;
    protected boolean connected;

    public NioConnection(Address peer_addr, NioBaseServer server) throws Exception {
        this.server = server;
        if (peer_addr == null) {
            throw new IllegalArgumentException("Invalid parameter peer_addr=" + peer_addr);
        }
        this.peer_addr = peer_addr;
        this.send_buf = new Buffers(server.maxSendBuffers() * 2);
        this.channel = SocketChannel.open();
        this.channel.configureBlocking(false);
        this.setSocketParameters(this.channel.socket());
        this.last_access = this.getTimestamp();
    }

    public NioConnection(SocketChannel channel, NioBaseServer server) throws Exception {
        this.channel = channel;
        this.server = server;
        this.setSocketParameters(this.channel.socket());
        channel.configureBlocking(false);
        this.connected = channel.isConnected();
        this.send_buf = new Buffers(server.maxSendBuffers() * 2);
        this.peer_addr = server.usePeerConnections() ? null : new IpAddress((InetSocketAddress)channel.getRemoteAddress());
        this.last_access = this.getTimestamp();
    }

    @Override
    public boolean isOpen() {
        return this.channel != null && this.channel.isOpen();
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isConnectionPending() {
        return this.channel != null && this.channel.isConnectionPending();
    }

    @Override
    public boolean isExpired(long now) {
        return this.server.connExpireTime() > 0L && now - this.last_access >= this.server.connExpireTime();
    }

    protected void updateLastAccessed() {
        if (this.server.connExpireTime() > 0L) {
            this.last_access = this.getTimestamp();
        }
    }

    @Override
    public Address localAddress() {
        InetSocketAddress local_addr = null;
        if (this.channel != null) {
            try {
                local_addr = (InetSocketAddress)this.channel.getLocalAddress();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return local_addr != null ? new IpAddress(local_addr) : null;
    }

    @Override
    public Address peerAddress() {
        return this.peer_addr;
    }

    public SelectionKey key() {
        return this.key;
    }

    public NioConnection key(SelectionKey k) {
        this.key = k;
        return this;
    }

    public NioConnection copyOnPartialWrite(boolean b) {
        this.copy_on_partial_write = b;
        return this;
    }

    public boolean copyOnPartialWrite() {
        return this.copy_on_partial_write;
    }

    public int numPartialWrites() {
        return this.partial_writes;
    }

    public long readerIdleTime() {
        return this.reader_idle_time;
    }

    public NioConnection readerIdleTime(long t) {
        this.reader_idle_time = t;
        return this;
    }

    public boolean readerRunning() {
        return this.reader.isRunning();
    }

    public NioConnection connected(boolean c) {
        this.connected = c;
        return this;
    }

    public synchronized void registerSelectionKey(int interest_ops) {
        if (this.key == null) {
            return;
        }
        this.key.interestOps(this.key.interestOps() | interest_ops);
    }

    public synchronized void clearSelectionKey(int interest_ops) {
        if (this.key == null) {
            return;
        }
        this.key.interestOps(this.key.interestOps() & ~interest_ops);
    }

    @Override
    public void connect(Address dest) throws Exception {
        this.connect(dest, this.server.usePeerConnections());
    }

    protected void connect(Address dest, boolean send_local_addr) throws Exception {
        InetSocketAddress destAddr = new InetSocketAddress(((IpAddress)dest).getIpAddress(), ((IpAddress)dest).getPort());
        try {
            if (!this.server.deferClientBinding()) {
                this.channel.bind(new InetSocketAddress(this.server.clientBindAddress(), this.server.clientBindPort()));
            }
            this.key = this.server.register(this.channel, 9, this);
            if (Util.connect(this.channel, destAddr) && this.channel.finishConnect()) {
                this.clearSelectionKey(8);
                this.connected = this.channel.isConnected();
            }
            if (this.channel.getLocalAddress() != null && this.channel.getLocalAddress().equals(destAddr)) {
                throw new IllegalStateException("socket's bind and connect address are the same: " + destAddr);
            }
            if (send_local_addr) {
                this.sendLocalAddress(this.server.localAddress());
            }
        }
        catch (Exception t) {
            this.close();
            throw t;
        }
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void send(byte[] buf, int offset, int length) throws Exception {
        this.send(ByteBuffer.wrap(buf, offset, length));
    }

    @Override
    public void send(ByteBuffer buf) throws Exception {
        this.send(buf, true);
    }

    public void send() throws Exception {
        this.send_lock.lock();
        try {
            boolean success = this.send_buf.write(this.channel);
            this.writeInterest(!success);
            if (success) {
                this.updateLastAccessed();
            }
            if (!success) {
                if (this.copy_on_partial_write) {
                    this.send_buf.copy();
                }
                ++this.partial_writes;
            }
        }
        finally {
            this.send_lock.unlock();
        }
    }

    public void receive() throws Exception {
        this.reader.receive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(ByteBuffer buf, boolean send_length) throws Exception {
        this.send_lock.lock();
        try {
            if (send_length) {
                this.send_buf.add(NioConnection.makeLengthBuffer(buf), buf);
            } else {
                this.send_buf.add(buf);
            }
            boolean success = this.send_buf.write(this.channel);
            this.writeInterest(!success);
            if (success) {
                this.updateLastAccessed();
            }
            if (!success) {
                if (this.copy_on_partial_write) {
                    this.send_buf.copy();
                }
                ++this.partial_writes;
            }
        }
        finally {
            this.send_lock.unlock();
        }
    }

    protected boolean _receive(boolean update) throws Exception {
        Receiver receiver = this.server.receiver();
        if (this.peer_addr == null && this.server.usePeerConnections() && (this.peer_addr = this.readPeerAddress()) != null) {
            this.recv_buf = new Buffers(2).add(ByteBuffer.allocate(4), null);
            this.server.addConnection(this.peer_addr, this);
            return true;
        }
        ByteBuffer msg = this.recv_buf.readLengthAndData(this.channel);
        if (msg == null) {
            return false;
        }
        if (receiver != null) {
            receiver.receive(this.peer_addr, msg);
        }
        if (update) {
            this.updateLastAccessed();
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        this.send_lock.lock();
        try {
            if (this.send_buf.remaining() > 0) {
                try {
                    this.send();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Util.close(this.channel, this.reader);
        }
        finally {
            this.connected = false;
            this.send_lock.unlock();
        }
    }

    public String toString() {
        InetSocketAddress local = null;
        InetSocketAddress remote = null;
        try {
            local = this.channel != null ? (InetSocketAddress)this.channel.getLocalAddress() : null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            remote = this.channel != null ? (InetSocketAddress)this.channel.getRemoteAddress() : null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String loc = local == null ? "n/a" : local.getHostString() + ":" + local.getPort();
        String rem = remote == null ? "n/a" : remote.getHostString() + ":" + remote.getPort();
        return String.format("<%s --> %s> (%d secs old) [%s] [recv_buf: %d, reader=%b]", loc, rem, TimeUnit.SECONDS.convert(this.getTimestamp() - this.last_access, TimeUnit.NANOSECONDS), this.status(), this.recv_buf.get(1) != null ? this.recv_buf.get(1).capacity() : 0, this.readerRunning());
    }

    @Override
    public String status() {
        if (this.channel == null) {
            return "n/a";
        }
        if (this.isConnected()) {
            return "connected";
        }
        if (this.isConnectionPending()) {
            return "connection pending";
        }
        if (this.isOpen()) {
            return "open";
        }
        return "closed";
    }

    protected long getTimestamp() {
        return this.server.timeService() != null ? this.server.timeService().timestamp() : System.nanoTime();
    }

    protected void writeInterest(boolean register) {
        if (register) {
            if (!this.write_interest_set) {
                this.write_interest_set = true;
                this.registerSelectionKey(4);
            }
        } else if (this.write_interest_set) {
            this.write_interest_set = false;
            this.clearSelectionKey(4);
        }
    }

    protected void setSocketParameters(Socket client_sock) throws SocketException {
        try {
            client_sock.setSendBufferSize(this.server.sendBufferSize());
        }
        catch (IllegalArgumentException ex) {
            this.server.log().error("%s: exception setting send buffer to %d bytes: %s", this.server.localAddress(), this.server.sendBufferSize(), ex);
        }
        try {
            client_sock.setReceiveBufferSize(this.server.receiveBufferSize());
        }
        catch (IllegalArgumentException ex) {
            this.server.log().error("%s: exception setting receive buffer to %d bytes: %s", this.server.localAddress(), this.server.receiveBufferSize(), ex);
        }
        client_sock.setKeepAlive(true);
        client_sock.setTcpNoDelay(this.server.tcpNodelay());
        if (this.server.linger() > 0) {
            client_sock.setSoLinger(true, this.server.linger());
        } else {
            client_sock.setSoLinger(false, -1);
        }
    }

    protected void sendLocalAddress(Address local_addr) throws Exception {
        try {
            int addr_size = local_addr.serializedSize();
            int expected_size = cookie.length + 4 + addr_size;
            ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(expected_size + 2);
            out.write(cookie, 0, cookie.length);
            out.writeShort(Version.version);
            out.writeShort(addr_size);
            local_addr.writeTo(out);
            ByteBuffer buf = out.getByteBuffer();
            this.send(buf, false);
            this.updateLastAccessed();
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }

    protected Address readPeerAddress() throws Exception {
        block6: while (this.recv_buf.read(this.channel)) {
            int current_position = this.recv_buf.position() - 1;
            ByteBuffer buf = this.recv_buf.get(current_position);
            if (buf == null) {
                return null;
            }
            buf.flip();
            switch (current_position) {
                case 0: {
                    byte[] cookie_buf = NioConnection.getBuffer(buf);
                    if (!Arrays.equals(cookie, cookie_buf)) {
                        throw new IllegalStateException("BaseServer.NioConnection.readPeerAddress(): cookie read by " + this.server.localAddress() + " does not match own cookie; terminating connection");
                    }
                    this.recv_buf.add(ByteBuffer.allocate(2));
                    continue block6;
                }
                case 1: {
                    short version = buf.getShort();
                    if (!Version.isBinaryCompatible(version)) {
                        throw new IOException("packet from " + this.channel.getRemoteAddress() + " has different version (" + Version.print(version) + ") from ours (" + Version.printVersion() + "); discarding it");
                    }
                    this.recv_buf.add(ByteBuffer.allocate(2));
                    continue block6;
                }
                case 2: {
                    short addr_len = buf.getShort();
                    this.recv_buf.add(ByteBuffer.allocate(addr_len));
                    continue block6;
                }
                case 3: {
                    byte[] addr_buf = NioConnection.getBuffer(buf);
                    ByteArrayDataInputStream in = new ByteArrayDataInputStream(addr_buf);
                    IpAddress addr = new IpAddress();
                    addr.readFrom(in);
                    return addr;
                }
            }
            throw new IllegalStateException(String.format("position %d is invalid", this.recv_buf.position()));
        }
        return null;
    }

    protected static byte[] getBuffer(ByteBuffer buf) {
        byte[] retval = new byte[buf.limit()];
        buf.get(retval, buf.position(), buf.limit());
        return retval;
    }

    protected static ByteBuffer makeLengthBuffer(ByteBuffer buf) {
        return (ByteBuffer)ByteBuffer.allocate(4).putInt(buf.remaining()).clear();
    }

    protected class Reader
    implements Runnable,
    Closeable {
        protected final Lock lock = new ReentrantLock();
        protected State state = State.done;
        protected volatile boolean data_available = true;
        protected final CondVar data_available_cond = new CondVar();
        protected volatile Thread thread;
        protected volatile boolean running;

        protected Reader() {
        }

        protected void start() {
            this.running = true;
            this.thread = NioConnection.this.server.factory.newThread(this, String.format("NioConnection.Reader [%s]", NioConnection.this.peer_addr));
            this.thread.setDaemon(true);
            this.thread.start();
        }

        protected void stop() {
            this.running = false;
            this.data_available = true;
            this.data_available_cond.signal(false);
        }

        @Override
        public void close() throws IOException {
            this.stop();
        }

        public boolean isRunning() {
            Thread tmp = this.thread;
            return tmp != null && tmp.isAlive();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void receive() {
            this.lock.lock();
            try {
                this.data_available = true;
                this.clear(1);
                switch (this.state) {
                    case reading: {
                        return;
                    }
                    case waiting_to_terminate: {
                        this.data_available_cond.signal(false);
                        return;
                    }
                    case done: {
                        this.state = State.reading;
                        this.start();
                        return;
                    }
                }
                return;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void run() {
            try {
                this._run();
            }
            finally {
                this.register(1);
            }
        }

        protected void _run() {
            Condition is_data_available = () -> this.data_available || !this.running;
            while (this.running) {
                try {
                    while (NioConnection.this._receive(false)) {
                    }
                }
                catch (Throwable ex) {
                    NioConnection.this.server.closeConnection(NioConnection.this, ex);
                    this.state(State.done);
                    return;
                }
                NioConnection.this.updateLastAccessed();
                this.state(State.waiting_to_terminate);
                this.data_available = false;
                this.register(1);
                if (this.data_available_cond.waitFor(is_data_available, NioConnection.this.server.readerIdleTime(), TimeUnit.MILLISECONDS)) {
                    this.state(State.reading);
                    continue;
                }
                this.state(State.done);
                return;
            }
        }

        protected void register(int op) {
            try {
                NioConnection.this.registerSelectionKey(op);
                NioConnection.this.key.selector().wakeup();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        protected void clear(int op) {
            try {
                NioConnection.this.clearSelectionKey(op);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        protected void state(State st) {
            this.lock.lock();
            try {
                this.state = st;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected static enum State {
        reading,
        waiting_to_terminate,
        done;

    }
}

