/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.parser;

import java.util.ArrayList;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.parser.AeshCommandLineCompletionParser;
import org.aesh.command.impl.parser.CommandLineCompletionParser;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.impl.parser.CompleteStatus;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.InvocationProviders;
import org.aesh.command.map.MapCommand;
import org.aesh.command.map.MapCommandPopulator;
import org.aesh.command.map.MapProcessedCommand;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.parser.OptionParserException;
import org.aesh.command.parser.RequiredOptionException;
import org.aesh.command.populator.CommandPopulator;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.complete.AeshCompleteOperation;
import org.aesh.parser.LineParser;
import org.aesh.parser.ParsedLine;
import org.aesh.parser.ParsedLineIterator;
import org.aesh.parser.ParsedWord;
import org.aesh.parser.ParserStatus;
import org.aesh.readline.AeshContext;
import org.aesh.utils.ANSIBuilder;
import org.aesh.utils.Config;

public class AeshCommandLineParser<CI extends CommandInvocation>
implements CommandLineParser<CI> {
    private final ProcessedCommand<Command<CI>, CI> processedCommand;
    private List<CommandLineParser<CI>> childParsers;
    private boolean isChild = false;
    private ProcessedOption lastParsedOption;
    private boolean parsedCommand = false;
    private final LineParser lineParser;
    private CompleteStatus completeStatus;
    private AeshCommandLineParser<CI> parent;
    private boolean ansiMode = true;

    public AeshCommandLineParser(ProcessedCommand<Command<CI>, CI> processedCommand) {
        this.processedCommand = processedCommand;
        this.lineParser = new LineParser();
    }

    @Override
    public void addChildParser(CommandLineParser<CI> commandLineParser) throws CommandLineParserException {
        if (this.processedCommand.hasArgument() || this.processedCommand.hasArguments()) {
            throw new CommandLineParserException("Group commands can not have arguments defined");
        }
        if (this.childParsers == null) {
            this.childParsers = new ArrayList<CommandLineParser<CI>>();
        }
        commandLineParser.setChild(true);
        this.childParsers.add(commandLineParser);
        if (commandLineParser instanceof AeshCommandLineParser) {
            ((AeshCommandLineParser)commandLineParser).setParent(this);
        }
    }

    public List<CommandLineParser<CI>> getChildParsers() {
        return this.childParsers;
    }

    @Override
    public void setChild(boolean child) {
        this.isChild = child;
    }

    private void setParent(AeshCommandLineParser<CI> parent) {
        this.parent = parent;
    }

    @Override
    public CommandLineParser<CI> parsedCommand() {
        if (this.parsedCommand) {
            return this;
        }
        if (this.isGroupCommand()) {
            for (CommandLineParser<CI> child : this.childParsers) {
                CommandLineParser<CI> correct = child.parsedCommand();
                if (correct == null) continue;
                return correct;
            }
        }
        return null;
    }

    @Override
    public void complete(AeshCompleteOperation completeOperation, InvocationProviders invocationProviders) {
        this.complete(completeOperation, new LineParser().parseLine(completeOperation.getBuffer(), completeOperation.getCursor(), true), invocationProviders);
    }

    @Override
    public void complete(AeshCompleteOperation completeOperation, ParsedLine line, InvocationProviders invocationProviders) {
        this.parse(line.iterator(), CommandLineParser.Mode.COMPLETION);
        this.parsedCommand().getCompletionParser().injectValuesAndComplete(completeOperation, invocationProviders, line);
    }

    @Override
    public List<String> getAllNames() {
        if (this.isGroupCommand()) {
            List<CommandLineParser<CI>> parsers = this.getChildParsers();
            ArrayList<String> names = new ArrayList<String>(parsers.size());
            for (CommandLineParser<CI> child : parsers) {
                names.add(this.processedCommand.name() + " " + child.getProcessedCommand().name());
            }
            return names;
        }
        ArrayList<String> names = new ArrayList<String>(1);
        names.add(this.processedCommand.name());
        return names;
    }

    public boolean isChild() {
        return this.isChild;
    }

    @Override
    public CommandLineParser<CI> getChildParser(String name) {
        if (!this.isGroupCommand()) {
            return null;
        }
        for (CommandLineParser<CI> clp : this.getChildParsers()) {
            if (!clp.getProcessedCommand().name().equals(name)) continue;
            return clp;
        }
        return null;
    }

    @Override
    public List<CommandLineParser<CI>> getAllChildParsers() {
        if (this.isGroupCommand()) {
            return this.getChildParsers();
        }
        return new ArrayList<CommandLineParser<CI>>();
    }

    @Override
    public ProcessedCommand<Command<CI>, CI> getProcessedCommand() {
        return this.processedCommand;
    }

    @Override
    public Command<CI> getCommand() {
        return this.processedCommand.getCommand();
    }

    @Override
    public CommandLineCompletionParser getCompletionParser() {
        return new AeshCommandLineCompletionParser(this);
    }

    @Override
    public CommandPopulator<Object, CI> getCommandPopulator() {
        return this.processedCommand.getCommandPopulator();
    }

    @Override
    public void populateObject(String line, InvocationProviders invocationProviders, AeshContext aeshContext, CommandLineParser.Mode mode) throws CommandLineParserException, OptionValidatorException {
        this.parse(line, mode);
        if (mode == CommandLineParser.Mode.VALIDATE && this.getProcessedCommand().parserExceptions().size() > 0) {
            throw this.getProcessedCommand().parserExceptions().get(0);
        }
        this.doPopulate(this.processedCommand, invocationProviders, aeshContext, mode);
    }

    @Override
    public void doPopulate(ProcessedCommand<Command<CI>, CI> processedCommand, InvocationProviders invocationProviders, AeshContext aeshContext, CommandLineParser.Mode mode) throws CommandLineParserException, OptionValidatorException {
        this.getCommandPopulator().populateObject(processedCommand, invocationProviders, aeshContext, mode);
        if (this.isGroupCommand()) {
            for (CommandLineParser<CI> parser : this.getChildParsers()) {
                parser.doPopulate(parser.getProcessedCommand(), invocationProviders, aeshContext, mode);
            }
        }
    }

    @Override
    public String printHelp() {
        List<CommandLineParser<CI>> parsers = this.getChildParsers();
        if (parsers != null && parsers.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.processedCommand.printHelp(this.helpNames())).append(Config.getLineSeparator()).append(this.processedCommand.name()).append(" commands:").append(Config.getLineSeparator());
            int maxLength = 0;
            for (CommandLineParser<CI> child : parsers) {
                int length = child.getProcessedCommand().name().length();
                if (length <= maxLength) continue;
                maxLength = length;
            }
            for (CommandLineParser<CI> child : parsers) {
                sb.append(child.getFormattedCommand(4, maxLength + 2)).append(Config.getLineSeparator());
            }
            return sb.toString();
        }
        return this.processedCommand.printHelp(this.helpNames());
    }

    private String helpNames() {
        if (this.isChild()) {
            return super.helpNames() + " " + this.processedCommand.name();
        }
        return this.processedCommand.name();
    }

    @Override
    public void parse(String line) {
        this.parse(line, CommandLineParser.Mode.STRICT);
    }

    @Override
    public void parse(ParsedLineIterator iterator, CommandLineParser.Mode mode) {
        this.clear();
        if (iterator.hasNextWord()) {
            String command = iterator.pollWord();
            if (this.processedCommand.name().equals(command) || this.processedCommand.getAliases().contains(command)) {
                if (this.isGroupCommand() && iterator.hasNextWord()) {
                    CommandLineParser<CI> clp = this.getChildParser(iterator.peekWord());
                    if (clp == null) {
                        if (iterator.isNextWordCursorWord() || iterator.peekWord().startsWith("--") || iterator.peekWord().startsWith("-")) {
                            this.doParse(iterator, mode);
                        } else {
                            this.processedCommand.addParserException(new CommandLineParserException(command + " '" + iterator.peekWord() + "' is not a " + command + " command. See '" + command + " --help'."));
                            if (mode == CommandLineParser.Mode.COMPLETION) {
                                this.parsedCommand = true;
                                this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.INVALID_INPUT, ""));
                            }
                        }
                    } else {
                        clp.parse(iterator, mode);
                    }
                } else {
                    this.doParse(iterator, mode);
                }
            }
        } else if (iterator.parserError() != null) {
            this.processedCommand.addParserException(new CommandLineParserException(iterator.parserError()));
        }
    }

    private void doParse(ParsedLineIterator iter, CommandLineParser.Mode mode) {
        this.parsedCommand = true;
        if (mode == CommandLineParser.Mode.COMPLETION) {
            this.doParseCompletion(iter);
        } else {
            try {
                boolean argumentMarker = false;
                while (iter.hasNextWord()) {
                    ParsedWord word = iter.peekParsedWord();
                    if (argumentMarker) {
                        this.setArgStatus(word.word());
                        iter.pollParsedWord();
                        continue;
                    }
                    this.lastParsedOption = this.processedCommand.searchAllOptions(word.word());
                    if (this.lastParsedOption != null) {
                        this.lastParsedOption.parser().parse(iter, this.lastParsedOption);
                        continue;
                    }
                    if (word.word().equals("--") && !iter.isNextWordCursorWord()) {
                        argumentMarker = true;
                    } else {
                        boolean unknown = false;
                        if (word.word().startsWith("-") && (word.word().startsWith("--") || word.word().length() == 2)) {
                            if (!(this.processedCommand.getCommand() instanceof MapCommand)) {
                                this.processedCommand.addParserException(new OptionParserException("The option " + word.word() + " is unknown."));
                            } else {
                                unknown = true;
                            }
                        }
                        if (unknown) {
                            MapCommandPopulator pop = (MapCommandPopulator)this.processedCommand.getCommandPopulator();
                            pop.addUnknownOption(word.word());
                        } else {
                            this.setArgStatus(word.word());
                        }
                    }
                    iter.pollParsedWord();
                }
            }
            catch (OptionParserException ope) {
                this.processedCommand.addParserException(ope);
            }
            if (mode == CommandLineParser.Mode.STRICT) {
                MapCommand mc;
                ProcessedCommand<Command<CI>, CI> copy = this.processedCommand;
                if (copy instanceof MapProcessedCommand && !(mc = (MapCommand)copy.getCommand()).checkForRequiredOptions(iter.baseLine())) {
                    return;
                }
                RequiredOptionException re = this.checkForMissingRequiredOptions(this.processedCommand);
                if (re != null) {
                    this.processedCommand.addParserException(re);
                }
            }
        }
    }

    private void setArgStatus(String word) {
        if (this.processedCommand.hasArguments()) {
            this.processedCommand.getArguments().addValue(word);
        } else if (this.processedCommand.hasArgumentWithNoValue()) {
            this.processedCommand.getArgument().addValue(word);
        } else {
            this.processedCommand.addParserException(new OptionParserException("A value " + word + " was given as an argument, but the command do not support it."));
        }
    }

    private void doParseCompletion(ParsedLineIterator iter) {
        ProcessedCommand<Command<CI>, CI> copy = this.processedCommand;
        if (copy instanceof MapProcessedCommand) {
            ((MapProcessedCommand)copy).setMode(CommandLineParser.Mode.COMPLETION);
        }
        if (!iter.hasNextWord()) {
            if (this.isGroupCommand()) {
                this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.GROUP_COMMAND, ""));
            } else if (iter.baseLine().size() == iter.baseLine().selectedIndex() + 1 && this.lastParsedOption == null) {
                if (iter.baseLine().status() == ParserStatus.OK) {
                    this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.APPEND_SPACE, ""));
                } else {
                    this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.ARGUMENT, ""));
                }
            } else {
                this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.COMPLETE_OPTION, ""));
            }
        } else {
            try {
                boolean argumentMarker = false;
                while (iter.hasNextWord()) {
                    if (iter.baseLine().selectedIndex() > -1 && iter.pastCursorWord() && this.processedCommand.completeStatus() != null) {
                        return;
                    }
                    ParsedWord word = iter.peekParsedWord();
                    if (argumentMarker) {
                        this.setCompletionArgStatus(word.word());
                        iter.pollParsedWord();
                        continue;
                    }
                    this.lastParsedOption = this.processedCommand.searchAllOptions(word.word());
                    if (this.lastParsedOption != null) {
                        if (iter.isNextWordCursorWord() && !word.word().contains("=") && this.processedCommand.findPossibleLongNames(word.word()).size() > 1) {
                            this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.LONG_OPTION, word.word().substring(2)));
                            iter.pollParsedWord();
                            continue;
                        }
                        this.lastParsedOption.parser().parse(iter, this.lastParsedOption);
                        if (iter.hasNextWord()) continue;
                        if (this.lastParsedOption.hasValue() || iter.baseLine().spaceAtEnd()) {
                            this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.COMPLETE_OPTION, ""));
                            continue;
                        }
                        this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.OPTION_MISSING_VALUE, ""));
                        continue;
                    }
                    if (word.word().equals("--") && !iter.isNextWordCursorWord()) {
                        argumentMarker = true;
                        iter.pollParsedWord();
                        continue;
                    }
                    if (word.word().startsWith("--")) {
                        this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.LONG_OPTION, word.word().substring(2)));
                        iter.pollParsedWord();
                        continue;
                    }
                    if (word.word().startsWith("-")) {
                        this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.SHORT_OPTION, word.word().substring(1)));
                        iter.pollParsedWord();
                        continue;
                    }
                    if (this.lastParsedOption == null && this.isGroupCommand()) {
                        if (iter.isNextWordCursorWord()) {
                            this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.GROUP_COMMAND, word.word()));
                        } else if (iter.baseLine().cursorAtEnd() && iter.baseLine().spaceAtEnd()) {
                            this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.GROUP_COMMAND, ""));
                        }
                    } else if (iter.isNextWordCursorWord()) {
                        if (this.processedCommand.getArguments() != null || this.processedCommand.getArgument() != null && this.processedCommand.getArgument().getValue() == null) {
                            this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.ARGUMENT, word.word()));
                        } else {
                            this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.ARGUMENT_ERROR, null));
                        }
                    } else {
                        this.setCompletionArgStatus(word.word());
                    }
                    iter.pollParsedWord();
                }
                if (argumentMarker && this.processedCommand.completeStatus() == null) {
                    this.setCompletionArgStatus(null);
                }
            }
            catch (OptionParserException e) {
                this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.OPTION_MISSING_VALUE, ""));
            }
        }
    }

    private void setCompletionArgStatus(String word) {
        if (this.processedCommand.hasArguments()) {
            this.processedCommand.getArguments().addValue(word);
            this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.ARGUMENT, null));
        } else if (this.processedCommand.hasArgument()) {
            if (this.processedCommand.getArgument().getValue() == null) {
                this.processedCommand.getArgument().addValue(word);
                this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.ARGUMENT, null));
            } else {
                this.processedCommand.setCompleteStatus(new CompleteStatus(CompleteStatus.Status.ARGUMENT_ERROR, null));
            }
        }
    }

    private RequiredOptionException checkForMissingRequiredOptions(ProcessedCommand<? extends Command<CI>, CI> command) {
        for (ProcessedOption o : command.getOptions()) {
            if (!this.doCheckForMissingRequiredOption(o)) continue;
            return new RequiredOptionException("Option: " + o.getDisplayName() + " is required for this command.");
        }
        if (command.getArgument() != null) {
            if (this.doCheckForMissingRequiredOption(command.getArgument())) {
                return new RequiredOptionException("Argument is required for this command.");
            }
        } else if (command.getArguments() != null && this.doCheckForMissingRequiredOption(command.getArguments())) {
            return new RequiredOptionException("Arguments is required for this command.");
        }
        return null;
    }

    private boolean doCheckForMissingRequiredOption(ProcessedOption o) {
        if (o.isRequired() && o.getValue() == null) {
            boolean found = false;
            for (ProcessedOption po : this.processedCommand.getOptions()) {
                if (po.getValue() == null || !po.doOverrideRequired()) continue;
                found = true;
                break;
            }
            if (!found) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ProcessedOption lastParsedOption() {
        return this.lastParsedOption;
    }

    @Override
    public void parse(String line, CommandLineParser.Mode mode) {
        this.parse(this.lineParser.parseLine(line, line.length()).iterator(), mode);
    }

    @Override
    public void clear() {
        if (this.parsedCommand) {
            this.processedCommand.clear();
            this.lastParsedOption = null;
            this.parsedCommand = false;
            this.completeStatus = null;
        } else {
            CommandLineParser<CI> parsed;
            if (this.processedCommand != null) {
                this.processedCommand.clear();
            }
            if ((parsed = this.parsedCommand()) != null) {
                parsed.clear();
            }
        }
    }

    @Override
    public boolean isGroupCommand() {
        List<CommandLineParser<CI>> parsers = this.getChildParsers();
        return parsers != null && parsers.size() > 0;
    }

    @Override
    public String getFormattedCommand(int offset, int descriptionStart) {
        ANSIBuilder ansiBuilder = ANSIBuilder.builder(this.ansiMode);
        if (offset > 0) {
            ansiBuilder.append(String.format("%" + offset + "s", ""));
        }
        ansiBuilder.blueText(this.getProcessedCommand().name());
        int descOffset = descriptionStart - this.getProcessedCommand().name().length();
        if (descOffset > 0) {
            ansiBuilder.append(String.format("%" + descOffset + "s", ""));
        } else {
            ansiBuilder.append(" ");
        }
        ansiBuilder.append(this.getProcessedCommand().description());
        return ansiBuilder.toString();
    }

    @Override
    public void updateAnsiMode(boolean mode) {
        this.ansiMode = mode;
    }

    public String toString() {
        return "AeshCommandLineParser{processedCommand=" + this.processedCommand + ", childParsers=" + this.childParsers + ", isChild=" + this.isChild + ", lastParsedOption=" + this.lastParsedOption + ", parsedCommand=" + this.parsedCommand + ", completeStatus=" + this.completeStatus + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AeshCommandLineParser)) {
            return false;
        }
        AeshCommandLineParser that = (AeshCommandLineParser)o;
        return this.processedCommand.equals(that.processedCommand);
    }

    public int hashCode() {
        return this.processedCommand.hashCode();
    }
}

