/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.impl.AbstractPasswordImpl;
import org.wildfly.security.password.impl.PasswordUtil;
import org.wildfly.security.password.interfaces.MaskedPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.IteratedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.MaskedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.MaskedPasswordSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

final class MaskedPasswordImpl
extends AbstractPasswordImpl
implements MaskedPassword {
    private static final long serialVersionUID = -4107081797004604247L;
    private static final char[] DEFAULT_PBE_KEY = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
    private static final int DEFAULT_SALT_SIZE = 8;
    private static final int DEFAULT_ITERATION_COUNT = 1000;
    private final String algorithm;
    private final char[] initialKeyMaterial;
    private final int iterationCount;
    private final byte[] salt;
    private final byte[] maskedPasswordBytes;

    private MaskedPasswordImpl(String algorithm, char[] initialKeyMaterial, int iterationCount, byte[] salt, byte[] maskedPasswordBytes, boolean validated) throws InvalidKeySpecException {
        Assert.checkMinimumParameter("iterationCount", 1, iterationCount);
        if (!validated) {
            MaskedPasswordImpl.unmask(algorithm, initialKeyMaterial, iterationCount, salt, maskedPasswordBytes);
        }
        this.algorithm = algorithm;
        this.initialKeyMaterial = initialKeyMaterial;
        this.iterationCount = iterationCount;
        this.salt = salt;
        this.maskedPasswordBytes = maskedPasswordBytes;
    }

    private MaskedPasswordImpl(String algorithm, char[] initialKeyMaterial, int iterationCount, byte[] salt, char[] chars) throws InvalidKeySpecException {
        this(algorithm, initialKeyMaterial, iterationCount, salt, MaskedPasswordImpl.mask(algorithm, initialKeyMaterial, iterationCount, salt, chars), true);
    }

    MaskedPasswordImpl(String algorithm, MaskedPasswordSpec passwordSpec) throws InvalidKeySpecException {
        this(algorithm, (char[])passwordSpec.getInitialKeyMaterial().clone(), passwordSpec.getIterationCount(), (byte[])passwordSpec.getSalt().clone(), (byte[])passwordSpec.getMaskedPasswordBytes().clone(), false);
    }

    MaskedPasswordImpl(String algorithm, char[] clearPassword) throws InvalidKeySpecException {
        this(algorithm, DEFAULT_PBE_KEY, 1000, PasswordUtil.generateRandomSalt(8), clearPassword);
    }

    MaskedPasswordImpl(String algorithm, char[] clearPassword, MaskedPasswordAlgorithmSpec parameterSpec) throws InvalidKeySpecException {
        this(algorithm, (char[])parameterSpec.getInitialKeyMaterial().clone(), parameterSpec.getIterationCount(), (byte[])parameterSpec.getSalt().clone(), clearPassword);
    }

    MaskedPasswordImpl(String algorithm, char[] clearPassword, IteratedSaltedPasswordAlgorithmSpec parameterSpec) throws InvalidKeySpecException {
        this(algorithm, DEFAULT_PBE_KEY, parameterSpec.getIterationCount(), (byte[])parameterSpec.getSalt().clone(), clearPassword);
    }

    MaskedPasswordImpl(String algorithm, char[] clearPassword, SaltedPasswordAlgorithmSpec parameterSpec) throws InvalidKeySpecException {
        this(algorithm, DEFAULT_PBE_KEY, 1000, (byte[])parameterSpec.getSalt().clone(), clearPassword);
    }

    MaskedPasswordImpl(String algorithm, char[] clearPassword, IteratedPasswordAlgorithmSpec parameterSpec) throws InvalidKeySpecException {
        this(algorithm, DEFAULT_PBE_KEY, parameterSpec.getIterationCount(), PasswordUtil.generateRandomSalt(8), clearPassword);
    }

    MaskedPasswordImpl(String algorithm, ClearPasswordSpec keySpec) throws InvalidKeySpecException {
        this(algorithm, keySpec.getEncodedPassword());
    }

    MaskedPasswordImpl(MaskedPassword password) throws InvalidKeySpecException {
        this(password.getAlgorithm(), (char[])password.getInitialKeyMaterial().clone(), password.getIterationCount(), (byte[])password.getSalt().clone(), (byte[])password.getMaskedPasswordBytes().clone(), false);
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public char[] getInitialKeyMaterial() {
        return (char[])this.initialKeyMaterial.clone();
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public byte[] getMaskedPasswordBytes() {
        return (byte[])this.maskedPasswordBytes.clone();
    }

    @Override
    <S extends KeySpec> S getKeySpec(Class<S> keySpecType) throws InvalidKeySpecException {
        if (keySpecType.isAssignableFrom(MaskedPasswordSpec.class)) {
            return (S)((KeySpec)keySpecType.cast(new MaskedPasswordSpec((char[])this.initialKeyMaterial.clone(), this.iterationCount, (byte[])this.salt.clone(), (byte[])this.maskedPasswordBytes.clone())));
        }
        if (keySpecType.isAssignableFrom(ClearPasswordSpec.class)) {
            return (S)((KeySpec)keySpecType.cast(new ClearPasswordSpec(MaskedPasswordImpl.unmask(this.algorithm, this.initialKeyMaterial, this.iterationCount, this.salt, this.maskedPasswordBytes))));
        }
        throw new InvalidKeySpecException();
    }

    @Override
    boolean verify(char[] guess) throws InvalidKeyException {
        try {
            return Arrays.equals(guess, MaskedPasswordImpl.unmask(this.algorithm, this.initialKeyMaterial, this.iterationCount, this.salt, this.maskedPasswordBytes));
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e);
        }
    }

    @Override
    <T extends KeySpec> boolean convertibleTo(Class<T> keySpecType) {
        return keySpecType.isAssignableFrom(MaskedPasswordSpec.class) || keySpecType.isAssignableFrom(ClearPasswordSpec.class);
    }

    @Override
    public MaskedPasswordImpl clone() {
        return this;
    }

    private static byte[] mask(String algorithm, char[] initialKeyMaterial, int iterationCount, byte[] salt, char[] chars) throws InvalidKeySpecException {
        Cipher cipher = MaskedPasswordImpl.getCipher(algorithm, initialKeyMaterial, iterationCount, salt, 1);
        try {
            return cipher.doFinal(CodePointIterator.ofChars(chars).asUtf8().drain());
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new InvalidKeySpecException(e);
        }
    }

    private static char[] unmask(String algorithm, char[] initialKeyMaterial, int iterationCount, byte[] salt, byte[] bytes) throws InvalidKeySpecException {
        Cipher cipher = MaskedPasswordImpl.getCipher(algorithm, initialKeyMaterial, iterationCount, salt, 2);
        try {
            return ByteIterator.ofBytes(cipher.doFinal(bytes)).asUtf8String().drainToString().toCharArray();
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new InvalidKeySpecException(e);
        }
    }

    private static Cipher getCipher(String algorithm, char[] initialKeyMaterial, int iterationCount, byte[] salt, int mode) throws InvalidKeySpecException {
        try {
            String pbeName = MaskedPassword.getPBEName(algorithm);
            Assert.assertNotNull(pbeName);
            SecretKeyFactory factory = SecretKeyFactory.getInstance(pbeName);
            Cipher cipher = Cipher.getInstance(pbeName);
            PBEParameterSpec cipherSpec = new PBEParameterSpec(salt, iterationCount);
            PBEKeySpec keySpec = new PBEKeySpec(initialKeyMaterial);
            SecretKey cipherKey = factory.generateSecret(keySpec);
            cipher.init(mode, (Key)cipherKey, cipherSpec);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new InvalidKeySpecException(e);
        }
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(HashMath.multiHashOrdered(HashMath.multiHashOrdered(Arrays.hashCode(this.initialKeyMaterial), Arrays.hashCode(this.salt)), Arrays.hashCode(this.maskedPasswordBytes)), this.iterationCount), this.algorithm.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MaskedPasswordImpl)) {
            return false;
        }
        MaskedPasswordImpl other = (MaskedPasswordImpl)obj;
        return this.iterationCount == other.iterationCount && Arrays.equals(this.initialKeyMaterial, other.initialKeyMaterial) && Arrays.equals(this.salt, other.salt) && Arrays.equals(this.maskedPasswordBytes, other.maskedPasswordBytes) && this.algorithm.equals(other.algorithm);
    }

    Object writeReplace() {
        return MaskedPassword.createRaw(this.algorithm, (char[])this.initialKeyMaterial.clone(), this.iterationCount, (byte[])this.salt.clone(), (byte[])this.maskedPasswordBytes.clone());
    }

    private void readObject(ObjectInputStream ignored) throws NotSerializableException {
        throw new NotSerializableException();
    }
}

