/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.http.ElytronMessages;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.Scope;
import org.wildfly.security.password.interfaces.ClearPassword;

public class HttpAuthenticator {
    private static final String AUTHENTICATED_IDENTITY_KEY = HttpAuthenticator.class.getName() + ".authenticated-identity";
    private final Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
    private final SecurityDomain securityDomain;
    private final HttpExchangeSpi httpExchangeSpi;
    private final boolean required;
    private final boolean ignoreOptionalFailures;
    private final String programaticMechanismName;
    private final Consumer<Runnable> logoutHandlerConsumer;
    private volatile boolean authenticated = false;

    private HttpAuthenticator(Builder builder) {
        this.mechanismSupplier = builder.mechanismSupplier;
        this.securityDomain = builder.securityDomain;
        this.programaticMechanismName = builder.programmaticMechanismName;
        this.logoutHandlerConsumer = builder.logoutHandlerConsumer;
        this.httpExchangeSpi = builder.httpExchangeSpi;
        this.required = builder.required;
        this.ignoreOptionalFailures = builder.ignoreOptionalFailures;
    }

    public boolean authenticate() throws HttpAuthenticationException {
        if (this.restoreIdentity()) {
            return true;
        }
        return new AuthenticationExchange().authenticate();
    }

    private boolean isAuthenticated() {
        return this.authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityIdentity login(String username, String password) {
        PasswordGuessEvidence evidence = new PasswordGuessEvidence(Assert.checkNotNullParam("password", password).toCharArray());
        try {
            SecurityIdentity securityIdentity = this.login(username, evidence, this.programaticMechanismName);
            return securityIdentity;
        }
        finally {
            evidence.destroy();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SecurityIdentity login(String username, Evidence evidence, String mechanismName) {
        if (this.securityDomain == null) {
            return null;
        }
        try (ServerAuthenticationContext authenticationContext = this.createServerAuthenticationContext();){
            authenticationContext.setAuthenticationName(username);
            if (authenticationContext.verifyEvidence(evidence)) {
                if (evidence instanceof PasswordGuessEvidence) {
                    ElytronMessages.log.tracef("Associating credential for '%s' with identity.", (Object)username);
                    authenticationContext.addPrivateCredential(new PasswordCredential(ClearPassword.createRaw("clear", ((PasswordGuessEvidence)evidence).getGuess())));
                }
                if (!authenticationContext.authorize()) {
                    this.httpExchangeSpi.authenticationFailed("Authorization Failed", mechanismName);
                    return null;
                }
                SecurityIdentity authorizedIdentity = authenticationContext.getAuthorizedIdentity();
                HttpScope sessionScope = this.httpExchangeSpi.getScope(Scope.SESSION);
                if (sessionScope != null && sessionScope.supportsAttachments() && (sessionScope.exists() || sessionScope.create())) {
                    ElytronMessages.log.tracef("Caching identity for '%s' against session scope.", (Object)username);
                    sessionScope.setAttachment(AUTHENTICATED_IDENTITY_KEY, new CachedIdentity(mechanismName, authorizedIdentity));
                } else {
                    ElytronMessages.log.tracef("Unable to cache identity for '%s'.", (Object)username);
                }
                this.setupProgramaticLogout(sessionScope);
                this.httpExchangeSpi.authenticationComplete(authorizedIdentity, mechanismName);
                SecurityIdentity securityIdentity = authorizedIdentity;
                return securityIdentity;
            }
            this.httpExchangeSpi.authenticationFailed("Authentication Failed", mechanismName);
            return null;
        }
        catch (IllegalArgumentException | IllegalStateException | RealmUnavailableException e) {
            this.httpExchangeSpi.authenticationFailed(e.getMessage(), mechanismName);
        }
        return null;
    }

    private ServerAuthenticationContext createServerAuthenticationContext() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> this.securityDomain.createNewAuthenticationContext());
        }
        return this.securityDomain.createNewAuthenticationContext();
    }

    private boolean restoreIdentity() {
        if (this.securityDomain == null) {
            return false;
        }
        HttpScope sessionScope = this.httpExchangeSpi.getScope(Scope.SESSION);
        if (sessionScope != null && sessionScope.supportsAttachments()) {
            CachedIdentity cachedIdentity = sessionScope.getAttachment(AUTHENTICATED_IDENTITY_KEY, CachedIdentity.class);
            if (cachedIdentity != null) {
                ServerAuthenticationContext authenticationContext = this.securityDomain.createNewAuthenticationContext();
                SecurityIdentity securityIdentity = cachedIdentity.getSecurityIdentity();
                try {
                    boolean authorized = securityIdentity != null && authenticationContext.importIdentity(securityIdentity);
                    boolean cache = false;
                    if (!authorized) {
                        ElytronMessages.log.trace("Unable to use SecurityIdentity from CachedIdentity - attempting to recreate");
                        authenticationContext.setAuthenticationName(cachedIdentity.getName());
                        authorized = authenticationContext.authorize();
                        cache = true;
                    }
                    if (authorized) {
                        securityIdentity = authenticationContext.getAuthorizedIdentity();
                        this.httpExchangeSpi.authenticationComplete(securityIdentity, cachedIdentity.getMechanismName());
                        this.setupProgramaticLogout(sessionScope);
                        if (cache) {
                            ElytronMessages.log.tracef("Replacing cached identity for '%s' against session scope.", (Object)cachedIdentity.getName());
                            sessionScope.setAttachment(AUTHENTICATED_IDENTITY_KEY, new CachedIdentity(cachedIdentity.getMechanismName(), securityIdentity));
                        }
                        return true;
                    }
                }
                catch (IllegalArgumentException | IllegalStateException | RealmUnavailableException e) {
                    this.httpExchangeSpi.authenticationFailed(e.getMessage(), this.programaticMechanismName);
                }
                ElytronMessages.log.tracef("Restoring identify '%s' failed, clearing cache from scope.", (Object)cachedIdentity.getName());
                sessionScope.setAttachment(AUTHENTICATED_IDENTITY_KEY, null);
            } else {
                ElytronMessages.log.trace("No CachedIdentity to restore.");
            }
        }
        return false;
    }

    private void setupProgramaticLogout(HttpScope sessionScope) {
        this.logoutHandlerConsumer.accept(() -> sessionScope.setAttachment(AUTHENTICATED_IDENTITY_KEY, null));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
        private SecurityDomain securityDomain;
        private HttpExchangeSpi httpExchangeSpi;
        private boolean required;
        private boolean ignoreOptionalFailures;
        private Consumer<Runnable> logoutHandlerConsumer;
        private String programmaticMechanismName;

        Builder() {
        }

        public Builder setMechanismSupplier(Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier) {
            this.mechanismSupplier = mechanismSupplier;
            return this;
        }

        public Builder setSecurityDomain(SecurityDomain securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        public Builder setHttpExchangeSpi(HttpExchangeSpi httpExchangeSpi) {
            this.httpExchangeSpi = httpExchangeSpi;
            return this;
        }

        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder setIgnoreOptionalFailures(boolean ignoreOptionalFailures) {
            this.ignoreOptionalFailures = ignoreOptionalFailures;
            return this;
        }

        public Builder registerLogoutHandler(Consumer<Runnable> logoutHandlerConsumer) {
            this.logoutHandlerConsumer = Assert.checkNotNullParam("logoutHandlerConsumer", logoutHandlerConsumer);
            return this;
        }

        public Builder setProgrammaticMechanismName(String programmaticMechanismName) {
            this.programmaticMechanismName = programmaticMechanismName;
            return this;
        }

        public HttpAuthenticator build() {
            return new HttpAuthenticator(this);
        }
    }

    private class AuthenticationExchange
    implements HttpServerRequest,
    HttpServerResponse {
        private volatile HttpServerAuthenticationMechanism currentMechanism;
        private volatile boolean authenticationAttempted = false;
        private volatile int statusCode = -1;
        private volatile boolean statusCodeAllowed = false;
        private volatile List<HttpServerMechanismsResponder> responders;
        private volatile HttpServerMechanismsResponder successResponder;

        private AuthenticationExchange() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean authenticate() throws HttpAuthenticationException {
            List authenticationMechanisms = (List)HttpAuthenticator.this.mechanismSupplier.get();
            if (HttpAuthenticator.this.required && authenticationMechanisms.size() == 0) {
                throw ElytronMessages.log.httpAuthenticationNoMechanisms();
            }
            this.responders = new ArrayList<HttpServerMechanismsResponder>(authenticationMechanisms.size());
            boolean evaluationFailed = false;
            try {
                Iterator iterator = authenticationMechanisms.iterator();
                while (iterator.hasNext()) {
                    HttpServerAuthenticationMechanism nextMechanism;
                    this.currentMechanism = nextMechanism = (HttpServerAuthenticationMechanism)iterator.next();
                    try {
                        nextMechanism.evaluateRequest(this);
                    }
                    catch (HttpAuthenticationException e) {
                        evaluationFailed = true;
                        ElytronMessages.log.trace("Request evaluation for mechanism '%s' failed.", nextMechanism.getMechanismName(), e);
                    }
                    if (!HttpAuthenticator.this.isAuthenticated()) continue;
                    if (this.successResponder != null) {
                        this.statusCodeAllowed = true;
                        this.successResponder.sendResponse(this);
                        if (this.statusCode > 0) {
                            HttpAuthenticator.this.httpExchangeSpi.setStatusCode(this.statusCode);
                            boolean e = false;
                            return e;
                        }
                    }
                    boolean e = true;
                    return e;
                }
                this.currentMechanism = null;
                if (HttpAuthenticator.this.required || this.authenticationAttempted && !HttpAuthenticator.this.ignoreOptionalFailures) {
                    this.statusCodeAllowed = true;
                    if (this.responders.size() > 0) {
                        boolean atLeastOneChallenge = false;
                        int defaultStatusCode = 200;
                        boolean statusSet = false;
                        for (HttpServerMechanismsResponder responder : this.responders) {
                            try {
                                responder.sendResponse(this);
                                atLeastOneChallenge = true;
                                if (statusSet || this.statusCode <= 0) continue;
                                if (this.statusCode == 403) {
                                    defaultStatusCode = this.statusCode;
                                    continue;
                                }
                                if (this.statusCode == 200) continue;
                                statusSet = true;
                                HttpAuthenticator.this.httpExchangeSpi.setStatusCode(this.statusCode);
                            }
                            catch (HttpAuthenticationException e) {
                                ElytronMessages.log.trace("HTTP Authentication mechanism unable to send challenge.", e);
                            }
                        }
                        if (!atLeastOneChallenge) {
                            throw ElytronMessages.log.httpAuthenticationNoSuccessfulResponder();
                        }
                        if (!statusSet) {
                            HttpAuthenticator.this.httpExchangeSpi.setStatusCode(defaultStatusCode);
                        }
                    } else {
                        if (evaluationFailed) {
                            throw ElytronMessages.log.httpAuthenticationFailedEvaluatingRequest();
                        }
                        HttpAuthenticator.this.httpExchangeSpi.setStatusCode(403);
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                for (HttpServerAuthenticationMechanism current : authenticationMechanisms) {
                    current.dispose();
                }
            }
        }

        @Override
        public List<String> getRequestHeaderValues(String headerName) {
            return HttpAuthenticator.this.httpExchangeSpi.getRequestHeaderValues(headerName);
        }

        @Override
        public String getFirstRequestHeaderValue(String headerName) {
            return HttpAuthenticator.this.httpExchangeSpi.getFirstRequestHeaderValue(headerName);
        }

        @Override
        public SSLSession getSSLSession() {
            return HttpAuthenticator.this.httpExchangeSpi.getSSLSession();
        }

        @Override
        public Certificate[] getPeerCertificates() {
            return HttpAuthenticator.this.httpExchangeSpi.getPeerCertificates(HttpAuthenticator.this.required);
        }

        @Override
        public HttpScope getScope(Scope scope) {
            return HttpAuthenticator.this.httpExchangeSpi.getScope(scope);
        }

        @Override
        public Collection<String> getScopeIds(Scope scope) {
            return HttpAuthenticator.this.httpExchangeSpi.getScopeIds(scope);
        }

        @Override
        public HttpScope getScope(Scope scope, String id) {
            return HttpAuthenticator.this.httpExchangeSpi.getScope(scope, id);
        }

        @Override
        public void noAuthenticationInProgress(HttpServerMechanismsResponder responder) {
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public void authenticationInProgress(HttpServerMechanismsResponder responder) {
            this.authenticationAttempted = true;
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public void authenticationComplete(HttpServerMechanismsResponder responder) {
            HttpAuthenticator.this.authenticated = true;
            HttpAuthenticator.this.httpExchangeSpi.authenticationComplete(this.currentMechanism.getNegotiationProperty("wildfly.http.security-identity", SecurityIdentity.class), this.currentMechanism.getMechanismName());
            this.successResponder = responder;
        }

        @Override
        public void authenticationComplete(HttpServerMechanismsResponder responder, Runnable logoutHandler) {
            this.authenticationComplete(responder);
            if (HttpAuthenticator.this.logoutHandlerConsumer != null) {
                HttpAuthenticator.this.logoutHandlerConsumer.accept(logoutHandler);
            }
        }

        @Override
        public void authenticationFailed(String message, HttpServerMechanismsResponder responder) {
            this.authenticationAttempted = true;
            HttpAuthenticator.this.httpExchangeSpi.authenticationFailed(message, this.currentMechanism.getMechanismName());
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public void badRequest(HttpAuthenticationException failure, HttpServerMechanismsResponder responder) {
            this.authenticationAttempted = true;
            HttpAuthenticator.this.httpExchangeSpi.badRequest(failure, this.currentMechanism.getMechanismName());
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public String getRequestMethod() {
            return HttpAuthenticator.this.httpExchangeSpi.getRequestMethod();
        }

        @Override
        public URI getRequestURI() {
            return HttpAuthenticator.this.httpExchangeSpi.getRequestURI();
        }

        @Override
        public String getRequestPath() {
            return HttpAuthenticator.this.httpExchangeSpi.getRequestPath();
        }

        @Override
        public Map<String, List<String>> getParameters() {
            return HttpAuthenticator.this.httpExchangeSpi.getRequestParameters();
        }

        @Override
        public Set<String> getParameterNames() {
            return HttpAuthenticator.this.httpExchangeSpi.getRequestParameterNames();
        }

        @Override
        public List<String> getParameterValues(String name) {
            return HttpAuthenticator.this.httpExchangeSpi.getRequestParameterValues(name);
        }

        @Override
        public String getFirstParameterValue(String name) {
            return HttpAuthenticator.this.httpExchangeSpi.getFirstRequestParameterValue(name);
        }

        @Override
        public List<HttpServerCookie> getCookies() {
            return HttpAuthenticator.this.httpExchangeSpi.getCookies();
        }

        @Override
        public InputStream getInputStream() {
            return HttpAuthenticator.this.httpExchangeSpi.getRequestInputStream();
        }

        @Override
        public InetSocketAddress getSourceAddress() {
            return HttpAuthenticator.this.httpExchangeSpi.getSourceAddress();
        }

        @Override
        public void addResponseHeader(String headerName, String headerValue) {
            HttpAuthenticator.this.httpExchangeSpi.addResponseHeader(headerName, headerValue);
        }

        @Override
        public void setStatusCode(int statusCode) {
            if (!this.statusCodeAllowed) {
                throw ElytronMessages.log.statusCodeNotNow();
            }
            if (this.statusCode < 0 || statusCode != 200) {
                this.statusCode = statusCode;
            }
        }

        @Override
        public OutputStream getOutputStream() {
            return HttpAuthenticator.this.httpExchangeSpi.getResponseOutputStream();
        }

        @Override
        public void setResponseCookie(HttpServerCookie cookie) {
            HttpAuthenticator.this.httpExchangeSpi.setResponseCookie(cookie);
        }

        @Override
        public boolean forward(String path) {
            int statusCode = HttpAuthenticator.this.httpExchangeSpi.forward(path);
            if (statusCode > 0) {
                this.setStatusCode(statusCode);
                return true;
            }
            return false;
        }

        @Override
        public boolean suspendRequest() {
            return HttpAuthenticator.this.httpExchangeSpi.suspendRequest();
        }

        @Override
        public boolean resumeRequest() {
            return HttpAuthenticator.this.httpExchangeSpi.resumeRequest();
        }
    }
}

