/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.security.password.OneWayPassword;
import org.wildfly.security.password.interfaces.RawBCryptPassword;
import org.wildfly.security.password.spec.IteratedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

public interface BCryptPassword
extends OneWayPassword {
    public static final String ALGORITHM_BCRYPT = "bcrypt";
    public static final int BCRYPT_SALT_SIZE = 16;
    public static final int BCRYPT_HASH_SIZE = 23;
    public static final int DEFAULT_ITERATION_COUNT = 10;

    public byte[] getHash();

    public byte[] getSalt();

    public int getIterationCount();

    @Override
    public BCryptPassword clone();

    @Override
    default public IteratedSaltedPasswordAlgorithmSpec getParameterSpec() {
        return new IteratedSaltedPasswordAlgorithmSpec(this.getIterationCount(), this.getSalt());
    }

    @Override
    default public boolean impliesParameters(AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam("parameterSpec", parameterSpec);
        if (parameterSpec instanceof IteratedSaltedPasswordAlgorithmSpec) {
            IteratedSaltedPasswordAlgorithmSpec spec = (IteratedSaltedPasswordAlgorithmSpec)parameterSpec;
            return this.getIterationCount() <= spec.getIterationCount() && Arrays.equals(this.getSalt(), spec.getSalt());
        }
        if (parameterSpec instanceof SaltedPasswordAlgorithmSpec) {
            return Arrays.equals(this.getSalt(), ((SaltedPasswordAlgorithmSpec)parameterSpec).getSalt());
        }
        if (parameterSpec instanceof IteratedPasswordAlgorithmSpec) {
            return this.getIterationCount() <= ((IteratedPasswordAlgorithmSpec)parameterSpec).getIterationCount();
        }
        return false;
    }

    public static BCryptPassword createRaw(String algorithm, byte[] hash, byte[] salt, int iterationCount) {
        Assert.checkNotNullParam("hash", hash);
        Assert.checkNotNullParam("salt", salt);
        Assert.checkNotNullParam("algorithm", algorithm);
        return new RawBCryptPassword(algorithm, (byte[])hash.clone(), (byte[])salt.clone(), iterationCount);
    }
}

