/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.core.PriorityAware;
import org.apache.activemq.artemis.utils.collections.ArrayResettableIterator;
import org.apache.activemq.artemis.utils.collections.MultiIterator;
import org.apache.activemq.artemis.utils.collections.MultiResettableIterator;
import org.apache.activemq.artemis.utils.collections.ResettableIterator;

public class PriorityCollection<T extends PriorityAware>
extends AbstractCollection<T> {
    private final Supplier<Collection<T>> supplier;
    private volatile PriorityHolder<T>[] priorityHolders = PriorityCollection.newPrioritySetArrayInstance(0);
    private volatile int size;

    private void setArray(PriorityHolder<T>[] priorityHolders) {
        this.priorityHolders = priorityHolders;
    }

    private PriorityHolder<T>[] getArray() {
        return this.priorityHolders;
    }

    public PriorityCollection(Supplier<Collection<T>> supplier) {
        this.supplier = supplier;
    }

    private static <T> PriorityHolder<T>[] newPrioritySetArrayInstance(int length) {
        return (PriorityHolder[])Array.newInstance(PriorityHolder.class, length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set<Integer> getPriorites() {
        PriorityHolder<T>[] snapshot = this.getArray();
        return Arrays.stream(snapshot).map(PriorityAware::getPriority).collect(Collectors.toSet());
    }

    @Override
    public Iterator<T> iterator() {
        Iterator<T>[] iterators = this.getIterators();
        return new MultiIterator<T>(iterators);
    }

    private Iterator<T>[] getIterators() {
        PriorityHolder<T>[] snapshot = this.getArray();
        int size = snapshot.length;
        Iterator<T>[] iterators = PriorityCollection.newIteratorArrayInstance(size);
        for (int i = 0; i < size; ++i) {
            iterators[i] = snapshot[i].getValues().iterator();
        }
        return iterators;
    }

    private static <T> Iterator<T>[] newIteratorArrayInstance(int length) {
        return (Iterator[])Array.newInstance(Iterator.class, length);
    }

    public ResettableIterator<T> resettableIterator() {
        return new MultiResettableIterator<T>(this.getResettableIterators());
    }

    private ResettableIterator<T>[] getResettableIterators() {
        PriorityHolder<T>[] snapshot = this.getArray();
        int size = snapshot.length;
        ResettableIterator<T>[] iterators = PriorityCollection.newResettableIteratorArrayInstance(size);
        for (int i = 0; i < size; ++i) {
            iterators[i] = ArrayResettableIterator.iterator(snapshot[i].getValues());
        }
        return iterators;
    }

    private static <T> ResettableIterator<T>[] newResettableIteratorArrayInstance(int length) {
        return (ResettableIterator[])Array.newInstance(ResettableIterator.class, length);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        PriorityHolder<T>[] current = this.getArray();
        int len = current.length;
        for (int i = 0; i < len; ++i) {
            current[i].getValues().forEach(action);
        }
    }

    private Collection<T> getCollection(int priority, boolean createIfMissing) {
        PriorityHolder<T>[] current = this.getArray();
        int low = 0;
        int high = current.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            PriorityHolder<T> midVal = current[mid];
            if (midVal.getPriority() > priority) {
                low = mid + 1;
                continue;
            }
            if (midVal.getPriority() < priority) {
                high = mid - 1;
                continue;
            }
            return midVal.getValues();
        }
        if (createIfMissing) {
            PriorityHolder<T>[] newArray = PriorityCollection.newPrioritySetArrayInstance(current.length + 1);
            if (low > 0) {
                System.arraycopy(current, 0, newArray, 0, low);
            }
            if (current.length - low > 0) {
                System.arraycopy(current, low, newArray, low + 1, current.length - low);
            }
            newArray[low] = new PriorityHolder(priority, this.supplier);
            this.setArray(newArray);
            return newArray[low].getValues();
        }
        return null;
    }

    @Override
    public synchronized boolean add(T t) {
        if (this.size() == Integer.MAX_VALUE) {
            return false;
        }
        boolean result = this.addInternal(t);
        this.calcSize();
        return result;
    }

    private boolean addInternal(T t) {
        if (t == null) {
            return false;
        }
        Collection<T> priority = this.getCollection(t.getPriority(), true);
        return priority.add(t);
    }

    @Override
    public synchronized boolean remove(Object o) {
        boolean result = this.removeInternal(o);
        this.calcSize();
        return result;
    }

    private boolean removeInternal(Object o) {
        if (o instanceof PriorityAware) {
            boolean result;
            PriorityAware priorityAware = (PriorityAware)o;
            Collection<T> priority = this.getCollection(priorityAware.getPriority(), false);
            boolean bl = result = priority != null && priority.remove(priorityAware);
            if (priority != null && priority.isEmpty()) {
                this.removeCollection(priorityAware.getPriority());
            }
            return result;
        }
        return false;
    }

    private Collection<T> removeCollection(int priority) {
        PriorityHolder<T>[] current = this.getArray();
        int len = current.length;
        int low = 0;
        int high = len - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            PriorityHolder<T> midVal = current[mid];
            if (midVal.getPriority() > priority) {
                low = mid + 1;
                continue;
            }
            if (midVal.getPriority() < priority) {
                high = mid - 1;
                continue;
            }
            PriorityHolder<T>[] newArray = PriorityCollection.newPrioritySetArrayInstance(len - 1);
            System.arraycopy(current, 0, newArray, 0, mid);
            System.arraycopy(current, mid + 1, newArray, mid, len - mid - 1);
            this.setArray(newArray);
            return midVal.getValues();
        }
        return null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Objects.requireNonNull(c);
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends T> c) {
        Objects.requireNonNull(c);
        if (this.size() >= Integer.MAX_VALUE - c.size()) {
            return false;
        }
        boolean modified = false;
        for (PriorityAware e : c) {
            if (!this.addInternal(e)) continue;
            modified = true;
        }
        this.calcSize();
        return modified;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        boolean modified = false;
        for (Object o : c) {
            if (!this.removeInternal(o)) continue;
            modified = true;
        }
        this.calcSize();
        return modified;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        PriorityHolder<T>[] snapshot;
        Objects.requireNonNull(c);
        boolean modified = false;
        for (PriorityHolder<T> priorityHolder : snapshot = this.getArray()) {
            if (!priorityHolder.getValues().retainAll(c)) continue;
            modified = true;
            if (!priorityHolder.getValues().isEmpty()) continue;
            this.removeCollection(priorityHolder.getPriority());
        }
        this.calcSize();
        return modified;
    }

    @Override
    public synchronized void clear() {
        PriorityHolder<T>[] snapshot;
        for (PriorityHolder<T> priorityHolder : snapshot = this.getArray()) {
            priorityHolder.getValues().clear();
        }
        this.calcSize();
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof PriorityAware && this.contains((PriorityAware)o);
    }

    public boolean contains(PriorityAware priorityAware) {
        if (priorityAware == null) {
            return false;
        }
        Collection<T> prioritySet = this.getCollection(priorityAware.getPriority(), false);
        return prioritySet != null && prioritySet.contains(priorityAware);
    }

    private void calcSize() {
        PriorityHolder<T>[] current = this.getArray();
        int size = 0;
        for (PriorityHolder<T> priorityHolder : current) {
            size += priorityHolder.getValues().size();
        }
        this.size = size;
    }

    public static class PriorityHolder<E>
    implements PriorityAware {
        private final int priority;
        private final Collection<E> values;

        public PriorityHolder(int priority, Supplier<Collection<E>> supplier) {
            this.priority = priority;
            this.values = supplier.get();
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        public Collection<E> getValues() {
            return this.values;
        }
    }
}

