/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.ClientStatistics;
import io.undertow.client.UndertowClientMessages;
import io.undertow.client.http.ClientFixedLengthStreamSinkConduit;
import io.undertow.client.http.HttpClientExchange;
import io.undertow.client.http.HttpRequestConduit;
import io.undertow.client.http.HttpResponseBuilder;
import io.undertow.client.http.HttpResponseParser;
import io.undertow.client.http.ResponseParseState;
import io.undertow.client.http2.Http2ClearClientProvider;
import io.undertow.client.http2.Http2ClientConnection;
import io.undertow.conduits.ByteActivityCallback;
import io.undertow.conduits.BytesReceivedStreamSourceConduit;
import io.undertow.conduits.BytesSentStreamSinkConduit;
import io.undertow.conduits.ChunkedStreamSinkConduit;
import io.undertow.conduits.ChunkedStreamSourceConduit;
import io.undertow.conduits.ConduitListener;
import io.undertow.conduits.FinishableStreamSourceConduit;
import io.undertow.conduits.FixedLengthStreamSourceConduit;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.server.Connectors;
import io.undertow.server.protocol.http.HttpContinue;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.ConnectionUtils;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.PooledAdaptor;
import io.undertow.util.Protocols;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.ssl.SslConnection;

class HttpClientConnection
extends AbstractAttachable
implements Closeable,
ClientConnection {
    public final ConduitListener<StreamSinkConduit> requestFinishListener = new ConduitListener<StreamSinkConduit>(){

        @Override
        public void handleEvent(StreamSinkConduit channel) {
            if (HttpClientConnection.this.currentRequest != null) {
                HttpClientConnection.this.currentRequest.terminateRequest();
            }
        }
    };
    public final ConduitListener<StreamSourceConduit> responseFinishedListener = new ConduitListener<StreamSourceConduit>(){

        @Override
        public void handleEvent(StreamSourceConduit channel) {
            if (HttpClientConnection.this.currentRequest != null) {
                HttpClientConnection.this.currentRequest.terminateResponse();
            }
        }
    };
    private static final Logger log = Logger.getLogger(HttpClientConnection.class);
    private final Deque<HttpClientExchange> pendingQueue = new ArrayDeque<HttpClientExchange>();
    private HttpClientExchange currentRequest;
    private HttpResponseBuilder pendingResponse;
    private final OptionMap options;
    private final StreamConnection connection;
    private final PushBackStreamSourceConduit pushBackStreamSourceConduit;
    private final ClientReadListener clientReadListener = new ClientReadListener();
    private final ByteBufferPool bufferPool;
    private PooledByteBuffer pooledBuffer;
    private final StreamSinkConduit originalSinkConduit;
    private static final int UPGRADED = 0x10000000;
    private static final int UPGRADE_REQUESTED = 0x20000000;
    private static final int CLOSE_REQ = 0x40000000;
    private static final int CLOSED = Integer.MIN_VALUE;
    private int state;
    private final ChannelListener.SimpleSetter<HttpClientConnection> closeSetter = new ChannelListener.SimpleSetter();
    private final ClientStatistics clientStatistics;
    private int requestCount;
    private int read;
    private int written;
    private boolean http2Tried = false;
    private boolean http2UpgradeReceived = false;
    private ClientConnection http2Delegate;
    private final List<ChannelListener<ClientConnection>> closeListeners = new CopyOnWriteArrayList<ChannelListener<ClientConnection>>();

    HttpClientConnection(StreamConnection connection, OptionMap options, ByteBufferPool bufferPool) {
        if (options.get(UndertowOptions.ENABLE_STATISTICS, false)) {
            this.clientStatistics = new ClientStatisticsImpl();
            connection.getSinkChannel().setConduit(new BytesSentStreamSinkConduit(connection.getSinkChannel().getConduit(), new ByteActivityCallback(){

                @Override
                public void activity(long bytes) {
                    HttpClientConnection.this.written = (int)((long)HttpClientConnection.this.written + bytes);
                }
            }));
            connection.getSourceChannel().setConduit(new BytesReceivedStreamSourceConduit(connection.getSourceChannel().getConduit(), new ByteActivityCallback(){

                @Override
                public void activity(long bytes) {
                    HttpClientConnection.this.read = (int)((long)HttpClientConnection.this.read + bytes);
                }
            }));
        } else {
            this.clientStatistics = null;
        }
        this.options = options;
        this.connection = connection;
        this.pushBackStreamSourceConduit = new PushBackStreamSourceConduit(connection.getSourceChannel().getConduit());
        this.connection.getSourceChannel().setConduit(this.pushBackStreamSourceConduit);
        this.bufferPool = bufferPool;
        this.originalSinkConduit = connection.getSinkChannel().getConduit();
        connection.getCloseSetter().set((ChannelListener<? extends StreamConnection>)new ChannelListener<StreamConnection>(){

            @Override
            public void handleEvent(StreamConnection channel) {
                log.debugf("connection to %s closed", (Object)HttpClientConnection.this.getPeerAddress());
                HttpClientConnection httpClientConnection = HttpClientConnection.this;
                httpClientConnection.state = httpClientConnection.state | Integer.MIN_VALUE;
                ChannelListeners.invokeChannelListener(HttpClientConnection.this, HttpClientConnection.this.closeSetter.get());
                try {
                    if (HttpClientConnection.this.pooledBuffer != null) {
                        HttpClientConnection.this.pooledBuffer.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                for (ChannelListener listener : HttpClientConnection.this.closeListeners) {
                    listener.handleEvent(HttpClientConnection.this);
                }
                HttpClientExchange pending = (HttpClientExchange)HttpClientConnection.this.pendingQueue.poll();
                while (pending != null) {
                    pending.setFailed(new ClosedChannelException());
                    pending = (HttpClientExchange)HttpClientConnection.this.pendingQueue.poll();
                }
                if (HttpClientConnection.this.currentRequest != null) {
                    HttpClientConnection.this.currentRequest.setFailed(new ClosedChannelException());
                    HttpClientConnection.this.currentRequest = null;
                    HttpClientConnection.this.pendingResponse = null;
                }
            }
        });
        connection.getSourceChannel().setReadListener(this.clientReadListener);
        connection.getSourceChannel().resumeReads();
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.connection.getPeerAddress();
    }

    StreamConnection getConnection() {
        return this.connection;
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return this.connection.getPeerAddress(type);
    }

    public ChannelListener.Setter<? extends HttpClientConnection> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return this.connection.getLocalAddress(type);
    }

    @Override
    public XnioWorker getWorker() {
        return this.connection.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.connection.getIoThread();
    }

    @Override
    public boolean isOpen() {
        if (this.http2Delegate != null) {
            return this.http2Delegate.isOpen();
        }
        return this.connection.isOpen() && Bits.allAreClear(this.state, -1073741824);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        if (this.http2Delegate != null) {
            return this.http2Delegate.supportsOption(option);
        }
        return this.connection.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (this.http2Delegate != null) {
            return this.http2Delegate.getOption(option);
        }
        return this.connection.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (this.http2Delegate != null) {
            return this.http2Delegate.setOption(option, value);
        }
        return this.connection.setOption(option, value);
    }

    @Override
    public boolean isUpgraded() {
        if (this.http2Delegate != null) {
            return this.http2Delegate.isUpgraded();
        }
        return Bits.anyAreSet(this.state, 0x30000000);
    }

    @Override
    public boolean isPushSupported() {
        if (this.http2Delegate != null) {
            return this.http2Delegate.isPushSupported();
        }
        return false;
    }

    @Override
    public boolean isMultiplexingSupported() {
        if (this.http2Delegate != null) {
            return this.http2Delegate.isMultiplexingSupported();
        }
        return false;
    }

    @Override
    public ClientStatistics getStatistics() {
        if (this.http2Delegate != null) {
            return this.http2Delegate.getStatistics();
        }
        return this.clientStatistics;
    }

    @Override
    public boolean isUpgradeSupported() {
        return this.http2Delegate == null;
    }

    @Override
    public void addCloseListener(ChannelListener<ClientConnection> listener) {
        this.closeListeners.add(listener);
    }

    @Override
    public void sendRequest(ClientRequest request, ClientCallback<ClientExchange> clientCallback) {
        if (this.http2Delegate != null) {
            this.http2Delegate.sendRequest(request, clientCallback);
            return;
        }
        if (Bits.anyAreSet(this.state, -268435456)) {
            clientCallback.failed(UndertowClientMessages.MESSAGES.invalidConnectionState());
            return;
        }
        HttpClientExchange httpClientExchange = new HttpClientExchange(clientCallback, request, this);
        boolean ssl = this.connection instanceof SslConnection;
        if (!ssl && !this.http2Tried && this.options.get(UndertowOptions.ENABLE_HTTP2, false) && !request.getRequestHeaders().contains(Headers.UPGRADE)) {
            request.getRequestHeaders().put(new HttpString("HTTP2-Settings"), Http2ClearClientProvider.createSettingsFrame(this.options, this.bufferPool));
            request.getRequestHeaders().put(Headers.UPGRADE, "h2c");
            request.getRequestHeaders().put(Headers.CONNECTION, "Upgrade, HTTP2-Settings");
            this.http2Tried = true;
        }
        if (this.currentRequest == null) {
            this.initiateRequest(httpClientExchange);
        } else {
            this.pendingQueue.add(httpClientExchange);
        }
    }

    private void initiateRequest(HttpClientExchange httpClientExchange) {
        ++this.requestCount;
        this.currentRequest = httpClientExchange;
        this.pendingResponse = new HttpResponseBuilder();
        ClientRequest request = httpClientExchange.getRequest();
        String connectionString = request.getRequestHeaders().getFirst(Headers.CONNECTION);
        if (connectionString != null) {
            if (Headers.CLOSE.equalToString(connectionString)) {
                this.state |= 0x40000000;
            } else if (Headers.UPGRADE.equalToString(connectionString)) {
                this.state |= 0x20000000;
            }
        } else if (request.getProtocol() != Protocols.HTTP_1_1) {
            this.state |= 0x40000000;
        }
        if (request.getRequestHeaders().contains(Headers.UPGRADE)) {
            this.state |= 0x20000000;
        }
        if (request.getMethod().equals(Methods.CONNECT)) {
            this.state |= 0x20000000;
        }
        ConduitStreamSourceChannel sourceChannel = this.connection.getSourceChannel();
        sourceChannel.setReadListener(this.clientReadListener);
        sourceChannel.resumeReads();
        ConduitStreamSinkChannel sinkChannel = this.connection.getSinkChannel();
        StreamSinkConduit conduit = this.originalSinkConduit;
        HttpRequestConduit httpRequestConduit = new HttpRequestConduit(conduit, this.bufferPool, request);
        httpClientExchange.setRequestConduit(httpRequestConduit);
        conduit = httpRequestConduit;
        String fixedLengthString = request.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        String transferEncodingString = request.getRequestHeaders().getLast(Headers.TRANSFER_ENCODING);
        boolean hasContent = true;
        if (fixedLengthString != null) {
            try {
                long length = Long.parseLong(fixedLengthString);
                conduit = new ClientFixedLengthStreamSinkConduit(conduit, length, false, false, this.currentRequest);
                hasContent = length != 0L;
            }
            catch (NumberFormatException e) {
                this.handleError(e);
                return;
            }
        } else if (transferEncodingString != null) {
            if (!transferEncodingString.toLowerCase(Locale.ENGLISH).contains(Headers.CHUNKED.toString())) {
                this.handleError(UndertowClientMessages.MESSAGES.unknownTransferEncoding(transferEncodingString));
                return;
            }
            conduit = new ChunkedStreamSinkConduit(conduit, httpClientExchange.getConnection().getBufferPool(), false, false, httpClientExchange.getRequest().getRequestHeaders(), this.requestFinishListener, httpClientExchange);
        } else {
            conduit = new ClientFixedLengthStreamSinkConduit(conduit, 0L, false, false, this.currentRequest);
            hasContent = false;
        }
        sinkChannel.setConduit(conduit);
        httpClientExchange.invokeReadReadyCallback();
        if (!hasContent) {
            try {
                sinkChannel.shutdownWrites();
                if (!sinkChannel.flush()) {
                    sinkChannel.setWriteListener((ChannelListener<? super ConduitStreamSinkChannel>)ChannelListeners.flushingChannelListener(null, new ChannelExceptionHandler<ConduitStreamSinkChannel>(){

                        @Override
                        public void handleException(ConduitStreamSinkChannel channel, IOException exception) {
                            HttpClientConnection.this.handleError(exception);
                        }
                    }));
                    sinkChannel.resumeWrites();
                }
            }
            catch (Throwable t) {
                this.handleError(t);
            }
        }
    }

    private void handleError(Throwable exception) {
        if (exception instanceof IOException) {
            this.handleError((IOException)exception);
        } else {
            this.handleError(new IOException(exception));
        }
    }

    private void handleError(IOException exception) {
        UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
        this.currentRequest.setFailed(exception);
        this.currentRequest = null;
        this.pendingResponse = null;
        IoUtils.safeClose((Closeable)this.connection);
    }

    @Override
    public StreamConnection performUpgrade() throws IOException {
        log.debugf("connection to %s is being upgraded", (Object)this.getPeerAddress());
        if (Bits.allAreSet(this.state, -805306368)) {
            throw new IOException(UndertowClientMessages.MESSAGES.connectionClosed());
        }
        this.state |= 0x10000000;
        this.connection.getSinkChannel().setConduit(this.originalSinkConduit);
        this.connection.getSourceChannel().setConduit(this.pushBackStreamSourceConduit);
        return this.connection;
    }

    @Override
    public void close() throws IOException {
        log.debugf("close called on connection to %s", (Object)this.getPeerAddress());
        if (this.http2Delegate != null) {
            this.http2Delegate.close();
        }
        if (Bits.anyAreSet(this.state, Integer.MIN_VALUE)) {
            return;
        }
        this.state |= 0xC0000000;
        ConnectionUtils.cleanClose(this.connection, new Closeable[0]);
    }

    public void exchangeDone() {
        log.debugf("exchange complete in connection to %s", (Object)this.getPeerAddress());
        this.connection.getSinkChannel().setConduit(this.originalSinkConduit);
        this.connection.getSourceChannel().setConduit(this.pushBackStreamSourceConduit);
        this.connection.getSinkChannel().suspendWrites();
        this.connection.getSinkChannel().setWriteListener((ChannelListener<? super ConduitStreamSinkChannel>)null);
        if (Bits.anyAreSet(this.state, 0x40000000)) {
            this.currentRequest = null;
            this.pendingResponse = null;
            this.state |= Integer.MIN_VALUE;
            IoUtils.safeClose((Closeable)this.connection);
        } else if (Bits.anyAreSet(this.state, 0x20000000)) {
            this.connection.getSourceChannel().suspendReads();
            this.currentRequest = null;
            this.pendingResponse = null;
            return;
        }
        this.currentRequest = null;
        this.pendingResponse = null;
        HttpClientExchange next = this.pendingQueue.poll();
        if (next == null) {
            this.connection.getSourceChannel().setReadListener(this.clientReadListener);
            this.connection.getSourceChannel().resumeReads();
        } else {
            this.initiateRequest(next);
        }
    }

    public void requestDataSent() {
        if (this.http2UpgradeReceived) {
            this.doHttp2Upgrade();
        }
    }

    protected void doHttp2Upgrade() {
        try {
            StreamConnection connectedStreamChannel = this.performUpgrade();
            Http2Channel http2Channel = new Http2Channel(connectedStreamChannel, null, this.bufferPool, null, true, true, this.options);
            Http2ClientConnection http2ClientConnection = new Http2ClientConnection(http2Channel, this.currentRequest.getResponseCallback(), this.currentRequest.getRequest(), this.currentRequest.getRequest().getRequestHeaders().getFirst(Headers.HOST), this.clientStatistics, false);
            http2ClientConnection.getCloseSetter().set((ChannelListener<? extends ClientConnection>)new ChannelListener<ClientConnection>(){

                @Override
                public void handleEvent(ClientConnection channel) {
                    ChannelListeners.invokeChannelListener(HttpClientConnection.this, HttpClientConnection.this.closeSetter.get());
                }
            });
            this.http2Delegate = http2ClientConnection;
            connectedStreamChannel.getSourceChannel().wakeupReads();
            this.currentRequest = null;
            this.pendingResponse = null;
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)this);
        }
    }

    private void prepareResponseChannel(ClientResponse response, ClientExchange exchange) {
        String encoding = response.getResponseHeaders().getLast(Headers.TRANSFER_ENCODING);
        boolean chunked = encoding != null && Headers.CHUNKED.equals(new HttpString(encoding));
        String length = response.getResponseHeaders().getFirst(Headers.CONTENT_LENGTH);
        if (exchange.getRequest().getMethod().equals(Methods.HEAD)) {
            this.connection.getSourceChannel().setConduit(new FixedLengthStreamSourceConduit(this.connection.getSourceChannel().getConduit(), 0L, this.responseFinishedListener));
        } else if (chunked) {
            this.connection.getSourceChannel().setConduit(new ChunkedStreamSourceConduit(this.connection.getSourceChannel().getConduit(), this.pushBackStreamSourceConduit, this.bufferPool, this.responseFinishedListener, exchange, (Closeable)this.connection));
        } else if (length != null) {
            try {
                long contentLength = Long.parseLong(length);
                this.connection.getSourceChannel().setConduit(new FixedLengthStreamSourceConduit(this.connection.getSourceChannel().getConduit(), contentLength, this.responseFinishedListener));
            }
            catch (NumberFormatException e) {
                this.handleError(e);
                throw e;
            }
        } else if (response.getProtocol().equals(Protocols.HTTP_1_1) && !Connectors.isEntityBodyAllowed(response.getResponseCode())) {
            this.connection.getSourceChannel().setConduit(new FixedLengthStreamSourceConduit(this.connection.getSourceChannel().getConduit(), 0L, this.responseFinishedListener));
        } else {
            this.connection.getSourceChannel().setConduit(new FinishableStreamSourceConduit(this.connection.getSourceChannel().getConduit(), this.responseFinishedListener));
            this.state |= 0x40000000;
        }
    }

    private class ClientStatisticsImpl
    implements ClientStatistics {
        private ClientStatisticsImpl() {
        }

        @Override
        public long getRequests() {
            return HttpClientConnection.this.requestCount;
        }

        @Override
        public long getRead() {
            return HttpClientConnection.this.read;
        }

        @Override
        public long getWritten() {
            return HttpClientConnection.this.written;
        }

        @Override
        public void reset() {
            HttpClientConnection.this.read = 0;
            HttpClientConnection.this.written = 0;
            HttpClientConnection.this.requestCount = 0;
        }
    }

    class ClientReadListener
    implements ChannelListener<StreamSourceChannel> {
        ClientReadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handleEvent(StreamSourceChannel channel) {
            HttpResponseBuilder builder = HttpClientConnection.this.pendingResponse;
            PooledByteBuffer pooled = HttpClientConnection.this.bufferPool.allocate();
            ByteBuffer buffer = pooled.getBuffer();
            boolean free = true;
            try {
                if (builder == null) {
                    buffer.clear();
                    try {
                        int res = channel.read(buffer);
                        if (res == -1) {
                            UndertowLogger.CLIENT_LOGGER.debugf("Connection to %s was closed by the target server", (Object)HttpClientConnection.this.connection.getPeerAddress());
                            IoUtils.safeClose((Closeable)HttpClientConnection.this);
                            return;
                        }
                        if (res == 0) return;
                        UndertowLogger.CLIENT_LOGGER.debugf("Target server %s sent unexpected data when no request pending, closing connection", (Object)HttpClientConnection.this.connection.getPeerAddress());
                        IoUtils.safeClose((Closeable)HttpClientConnection.this);
                        return;
                    }
                    catch (IOException e) {
                        if (UndertowLogger.CLIENT_LOGGER.isDebugEnabled()) {
                            UndertowLogger.CLIENT_LOGGER.debugf((Throwable)e, "Connection closed with IOException", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)HttpClientConnection.this.connection);
                    }
                    return;
                }
                ResponseParseState state = builder.getParseState();
                do {
                    int res;
                    buffer.clear();
                    try {
                        res = channel.read(buffer);
                    }
                    catch (IOException e) {
                        if (UndertowLogger.CLIENT_LOGGER.isDebugEnabled()) {
                            UndertowLogger.CLIENT_LOGGER.debugf((Throwable)e, "Connection closed with IOException", new Object[0]);
                        }
                        try {
                            if (HttpClientConnection.this.currentRequest != null) {
                                HttpClientConnection.this.currentRequest.setFailed(e);
                                HttpClientConnection.this.currentRequest = null;
                            }
                            HttpClientConnection.this.pendingResponse = null;
                        }
                        catch (Throwable throwable) {
                            IoUtils.safeClose(channel, HttpClientConnection.this);
                            throw throwable;
                        }
                        IoUtils.safeClose(channel, HttpClientConnection.this);
                        if (free) {
                            pooled.close();
                            HttpClientConnection.this.pooledBuffer = null;
                            return;
                        } else {
                            HttpClientConnection.this.pooledBuffer = pooled;
                        }
                        return;
                    }
                    if (res == 0) {
                        if (channel.isReadResumed()) return;
                        channel.getReadSetter().set(this);
                        channel.resumeReads();
                        return;
                    }
                    if (res == -1) {
                        channel.suspendReads();
                        try {
                            if (HttpClientConnection.this.currentRequest != null) {
                                HttpClientConnection.this.currentRequest.setFailed(new IOException(UndertowClientMessages.MESSAGES.connectionClosed()));
                                HttpClientConnection.this.currentRequest = null;
                            }
                            HttpClientConnection.this.pendingResponse = null;
                            return;
                        }
                        finally {
                            IoUtils.safeClose((Closeable)HttpClientConnection.this);
                        }
                    }
                    buffer.flip();
                    HttpResponseParser.INSTANCE.handle(buffer, state, builder);
                    if (!buffer.hasRemaining()) continue;
                    free = false;
                    HttpClientConnection.this.pushBackStreamSourceConduit.pushBack(new PooledAdaptor(pooled));
                    HttpClientConnection.this.pushBackStreamSourceConduit.wakeupReads();
                } while (!state.isComplete());
                ClientResponse response = builder.build();
                String connectionString = response.getResponseHeaders().getFirst(Headers.CONNECTION);
                if (!(!Bits.anyAreSet(HttpClientConnection.this.state, 0x20000000) || connectionString != null && Headers.UPGRADE.equalToString(connectionString) || response.getResponseHeaders().contains(Headers.UPGRADE) || HttpClientConnection.this.currentRequest.getRequest().getMethod().equals(Methods.CONNECT) && response.getResponseCode() == 200)) {
                    HttpClientConnection httpClientConnection = HttpClientConnection.this;
                    httpClientConnection.state = httpClientConnection.state & 0xDFFFFFFF;
                }
                boolean close = false;
                if (connectionString != null) {
                    if (Headers.CLOSE.equalToString(connectionString)) {
                        close = true;
                    } else if (!response.getProtocol().equals(Protocols.HTTP_1_1) && !Headers.KEEP_ALIVE.equalToString(connectionString)) {
                        close = true;
                    }
                } else if (!response.getProtocol().equals(Protocols.HTTP_1_1)) {
                    close = true;
                }
                if (close) {
                    void var11_20;
                    HttpClientConnection httpClientConnection = HttpClientConnection.this;
                    httpClientConnection.state = httpClientConnection.state | 0x40000000;
                    HttpClientExchange httpClientExchange = (HttpClientExchange)HttpClientConnection.this.pendingQueue.poll();
                    while (var11_20 != null) {
                        var11_20.setFailed(new IOException(UndertowClientMessages.MESSAGES.connectionClosed()));
                        HttpClientExchange httpClientExchange2 = (HttpClientExchange)HttpClientConnection.this.pendingQueue.poll();
                    }
                }
                if (response.getResponseCode() == 101 && "h2c".equals(response.getResponseHeaders().getFirst(Headers.UPGRADE))) {
                    HttpClientConnection.this.http2UpgradeReceived = true;
                    if (!HttpClientConnection.this.currentRequest.isRequestDataSent()) return;
                    HttpClientConnection.this.doHttp2Upgrade();
                    return;
                } else if (builder.getStatusCode() == 100) {
                    HttpClientConnection.this.pendingResponse = new HttpResponseBuilder();
                    HttpClientConnection.this.currentRequest.setContinueResponse(response);
                    return;
                } else {
                    HttpClientConnection.this.prepareResponseChannel(response, HttpClientConnection.this.currentRequest);
                    channel.getReadSetter().set(null);
                    channel.suspendReads();
                    HttpClientConnection.this.pendingResponse = null;
                    HttpClientConnection.this.currentRequest.setResponse(response);
                    if (response.getResponseCode() != 417 || !HttpContinue.requiresContinueResponse(HttpClientConnection.this.currentRequest.getRequest().getRequestHeaders())) return;
                    HttpClientConnection httpClientConnection = HttpClientConnection.this;
                    httpClientConnection.state = httpClientConnection.state | 0x40000000;
                    ConduitStreamSinkChannel conduitStreamSinkChannel = HttpClientConnection.this.connection.getSinkChannel();
                    conduitStreamSinkChannel.shutdownWrites();
                    if (!conduitStreamSinkChannel.flush()) {
                        conduitStreamSinkChannel.setWriteListener(ChannelListeners.flushingChannelListener(null, null));
                        conduitStreamSinkChannel.resumeWrites();
                    }
                    if (HttpClientConnection.this.currentRequest == null) return;
                    HttpClientConnection.this.currentRequest.terminateRequest();
                }
                return;
            }
            catch (Throwable t) {
                UndertowLogger.CLIENT_LOGGER.exceptionProcessingRequest(t);
                IoUtils.safeClose((Closeable)HttpClientConnection.this.connection);
                if (HttpClientConnection.this.currentRequest == null) return;
                HttpClientConnection.this.currentRequest.setFailed(new IOException(t));
                return;
            }
            finally {
                if (free) {
                    pooled.close();
                    HttpClientConnection.this.pooledBuffer = null;
                } else {
                    HttpClientConnection.this.pooledBuffer = pooled;
                }
            }
        }
    }
}

