/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert;

import java.util.EnumSet;

public enum KeyUsage {
    digitalSignature,
    nonRepudiation,
    keyEncipherment,
    dataEncipherment,
    keyAgreement,
    keyCertSign,
    cRLSign,
    encipherOnly,
    decipherOnly;

    static final int fullSize;

    public static boolean isFull(EnumSet<KeyUsage> set) {
        return set != null && set.size() == fullSize;
    }

    public boolean in(boolean[] booleans) {
        int ordinal = this.ordinal();
        return booleans.length > ordinal && booleans[ordinal];
    }

    public boolean in(KeyUsage v1) {
        return this == v1;
    }

    public boolean in(KeyUsage v1, KeyUsage v2) {
        return this == v1 || this == v2;
    }

    public boolean in(KeyUsage v1, KeyUsage v2, KeyUsage v3) {
        return this == v1 || this == v2 || this == v3;
    }

    public boolean in(KeyUsage ... values) {
        if (values != null) {
            for (KeyUsage value : values) {
                if (this != value) continue;
                return true;
            }
        }
        return false;
    }

    static KeyUsage forName(String name) {
        switch (name) {
            case "digitalSignature": {
                return digitalSignature;
            }
            case "nonRepudiation": {
                return nonRepudiation;
            }
            case "keyEncipherment": {
                return keyEncipherment;
            }
            case "dataEncipherment": {
                return dataEncipherment;
            }
            case "keyAgreement": {
                return keyAgreement;
            }
            case "keyCertSign": {
                return keyCertSign;
            }
            case "cRLSign": {
                return cRLSign;
            }
            case "encipherOnly": {
                return encipherOnly;
            }
            case "decipherOnly": {
                return decipherOnly;
            }
        }
        return null;
    }

    static {
        fullSize = KeyUsage.values().length;
    }
}

