/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.remoting;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.util.MessageTracker;
import org.jboss.remoting3.util.StreamUtils;
import org.wildfly.common.rpc.RemoteExceptionCause;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.LocalTransactionContext;
import org.wildfly.transaction.client.RemoteTransactionPermission;
import org.wildfly.transaction.client.SimpleXid;
import org.wildfly.transaction.client.XARecoverable;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.provider.remoting.Protocol;
import org.wildfly.transaction.client.provider.remoting.RemotingTransactionServer;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;

final class TransactionServerChannel {
    private final RemotingTransactionServer server;
    private final MessageTracker messageTracker;
    private final Channel channel;
    private final Channel.Receiver receiver = new ReceiverImpl();
    private final LocalTransactionContext localTransactionContext;
    private static final Attachments.Key<TransactionServerChannel> KEY = new Attachments.Key<TransactionServerChannel>(TransactionServerChannel.class);

    TransactionServerChannel(RemotingTransactionServer server, Channel channel, LocalTransactionContext localTransactionContext) {
        this.server = server;
        this.channel = channel;
        this.localTransactionContext = localTransactionContext;
        this.messageTracker = new MessageTracker(channel, channel.getOption(RemotingOptions.MAX_OUTBOUND_MESSAGES));
        channel.getConnection().getAttachments().attach(KEY, this);
    }

    void start() {
        this.channel.receiveMessage(this.receiver);
    }

    void handleCapabilityMessage(MessageInputStream message, int invId) throws IOException {
        while (message.read() != -1) {
            Protocol.readIntParam(message, StreamUtils.readPackedUnsignedInt32(message));
        }
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeShort(invId);
            outputStream.writeByte(0);
        }
    }

    void handleUserTxnRollback(MessageInputStream message, int invId) throws IOException {
        int param;
        int context = 0;
        int secContext = 0;
        boolean hasContext = false;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32(message);
            switch (param) {
                case 241: {
                    context = Protocol.readIntParam(message, len);
                    hasContext = true;
                    continue block4;
                }
                case 240: {
                    secContext = Protocol.readIntParam(message, len);
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam(message, len);
        }
        if (!hasContext) {
            this.writeParamError(invId);
            return;
        }
        RemotingTransactionServer.LocalTxn txn = this.server.getTxnMap().removeKey(context);
        if (txn == null) {
            this.writeSimpleResponse(27, invId);
            return;
        }
        SecurityIdentity securityIdentity = this.getSecurityIdentity(27, invId, secContext, hasSecContext);
        if (securityIdentity == null) {
            return;
        }
        securityIdentity.runAs(() -> {
            LocalTransaction transaction = txn.getTransaction();
            if (transaction != null) {
                try {
                    transaction.performAction(transaction::rollback);
                    this.writeSimpleResponse(27, invId);
                    return;
                }
                catch (SystemException e) {
                    this.writeExceptionResponse(27, invId, e);
                    return;
                }
                catch (Exception e) {
                    this.writeExceptionResponse(27, invId, Log.log.unexpectedException(e));
                    return;
                }
            }
            this.writeParamError(invId);
        });
    }

    void handleUserTxnCommit(MessageInputStream message, int invId) throws IOException {
        int param;
        int context = 0;
        int secContext = 0;
        boolean hasContext = false;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32(message);
            switch (param) {
                case 241: {
                    context = Protocol.readIntParam(message, len);
                    hasContext = true;
                    continue block4;
                }
                case 240: {
                    secContext = Protocol.readIntParam(message, len);
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam(message, len);
        }
        if (!hasContext) {
            this.writeParamError(invId);
            return;
        }
        RemotingTransactionServer.LocalTxn txn = this.server.getTxnMap().removeKey(context);
        if (txn == null) {
            this.writeSimpleResponse(26, invId);
            return;
        }
        SecurityIdentity securityIdentity = this.getSecurityIdentity(26, invId, secContext, hasSecContext);
        if (securityIdentity == null) {
            return;
        }
        securityIdentity.runAs(() -> {
            LocalTransaction transaction = txn.getTransaction();
            if (transaction != null) {
                try {
                    transaction.performAction(transaction::commit);
                    this.writeSimpleResponse(26, invId);
                    return;
                }
                catch (HeuristicRollbackException e) {
                    this.writeExceptionResponse(26, invId, 18, e);
                    return;
                }
                catch (RollbackException e) {
                    this.writeExceptionResponse(26, invId, 16, e);
                    return;
                }
                catch (HeuristicMixedException e) {
                    this.writeExceptionResponse(26, invId, 17, e);
                    return;
                }
                catch (SystemException e) {
                    this.writeExceptionResponse(26, invId, e);
                    return;
                }
                catch (Exception e) {
                    this.writeExceptionResponse(26, invId, Log.log.unexpectedException(e));
                    return;
                }
            }
            this.writeParamError(invId);
        });
    }

    void handleXaTxnRollback(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32(message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid(message, len);
                    continue block4;
                }
                case 240: {
                    secContext = Protocol.readIntParam(message, len);
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam(message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = this.getSecurityIdentity(18, invId, secContext, hasSecContext);
        if (securityIdentity == null) {
            return;
        }
        securityIdentity.runAsObjIntConsumer((x, i) -> {
            try {
                ImportResult<LocalTransaction> importResult = this.localTransactionContext.findOrImportTransaction((Xid)x, 0, true);
                if (importResult == null) {
                    this.writeExceptionResponse(18, i, new XAException(-4));
                    return;
                }
                importResult.getTransaction().performConsumer(SubordinateTransactionControl::rollback, importResult.getControl());
                this.writeSimpleResponse(18, i);
            }
            catch (SystemException e) {
                XAException xae = new XAException(-3);
                xae.initCause(e);
                this.writeExceptionResponse(18, i, xae);
                return;
            }
            catch (XAException e) {
                this.writeExceptionResponse(18, i, e);
                return;
            }
        }, xid, invId);
    }

    void handleXaTxnRollbackOnly(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32(message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid(message, len);
                    continue block4;
                }
                case 240: {
                    secContext = Protocol.readIntParam(message, len);
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam(message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = this.getSecurityIdentity(24, invId, secContext, hasSecContext);
        if (securityIdentity == null) {
            return;
        }
        securityIdentity.runAsObjIntConsumer((x, i) -> {
            try {
                ImportResult<LocalTransaction> importResult = this.localTransactionContext.findOrImportTransaction((Xid)x, 0, true);
                if (importResult != null) {
                    importResult.getControl().end(0x20000000);
                } else {
                    Log.log.debugf("No transaction associated with xid %s during setRollbackOnly execution", x);
                }
                this.writeSimpleResponse(24, i);
            }
            catch (XAException e) {
                this.writeExceptionResponse(24, i, e);
                return;
            }
        }, xid, invId);
    }

    void handleXaTxnBefore(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32(message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid(message, len);
                    continue block4;
                }
                case 240: {
                    secContext = Protocol.readIntParam(message, len);
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam(message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = this.getSecurityIdentity(22, invId, secContext, hasSecContext);
        if (securityIdentity == null) {
            return;
        }
        securityIdentity.runAsObjIntConsumer((x, i) -> {
            try {
                ImportResult<LocalTransaction> importResult = this.localTransactionContext.findOrImportTransaction((Xid)x, 0, true);
                if (importResult == null) {
                    this.writeExceptionResponse(22, i, new XAException(-4));
                    return;
                }
                importResult.getTransaction().performConsumer(SubordinateTransactionControl::beforeCompletion, importResult.getControl());
                this.writeSimpleResponse(22, i);
            }
            catch (SystemException e) {
                XAException xae = new XAException(-3);
                xae.initCause(e);
                this.writeExceptionResponse(22, i, xae);
                return;
            }
            catch (XAException e) {
                this.writeExceptionResponse(22, i, e);
                return;
            }
        }, xid, invId);
    }

    void handleXaTxnPrepare(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32(message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid(message, len);
                    continue block4;
                }
                case 240: {
                    secContext = Protocol.readIntParam(message, len);
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam(message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = this.getSecurityIdentity(19, invId, secContext, hasSecContext);
        if (securityIdentity == null) {
            return;
        }
        securityIdentity.runAsObjIntConsumer((x, i) -> {
            try {
                int result;
                ImportResult<LocalTransaction> importResult = this.localTransactionContext.findOrImportTransaction((Xid)x, 0, true);
                if (importResult == null) {
                    this.writeExceptionResponse(19, invId, new XAException(-4));
                    return;
                }
                int n = result = !importResult.getTransaction().isImported() ? 3 : importResult.getControl().prepare();
                if (result == 3) {
                    this.writeSimpleResponse(19, i, 7);
                } else {
                    this.writeSimpleResponse(19, i);
                }
            }
            catch (XAException e) {
                this.writeExceptionResponse(19, i, e);
                return;
            }
            catch (Exception e) {
                XAException xae = new XAException(-3);
                xae.initCause(e);
                this.writeExceptionResponse(19, i, xae);
                return;
            }
        }, xid, invId);
    }

    void handleXaTxnForget(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32(message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid(message, len);
                    continue block4;
                }
                case 240: {
                    secContext = Protocol.readIntParam(message, len);
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam(message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = this.getSecurityIdentity(21, invId, secContext, hasSecContext);
        if (securityIdentity == null) {
            return;
        }
        securityIdentity.runAsObjIntConsumer((x, i) -> {
            try {
                ImportResult<LocalTransaction> importResult = this.localTransactionContext.findOrImportTransaction((Xid)x, 0, true);
                if (importResult == null) {
                    this.writeExceptionResponse(21, i, new XAException(-4));
                    return;
                }
                importResult.getControl().forget();
                this.writeSimpleResponse(21, i);
            }
            catch (XAException e) {
                this.writeExceptionResponse(21, i, e);
                return;
            }
            catch (Exception e) {
                XAException xae = new XAException(-3);
                xae.initCause(e);
                this.writeExceptionResponse(21, i, xae);
                return;
            }
        }, xid, invId);
    }

    void handleXaTxnCommit(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        boolean onePhase = false;
        block5: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32(message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid(message, len);
                    continue block5;
                }
                case 240: {
                    secContext = Protocol.readIntParam(message, len);
                    hasSecContext = true;
                    continue block5;
                }
                case 2: {
                    onePhase = true;
                    Protocol.readIntParam(message, len);
                    continue block5;
                }
            }
            Protocol.readIntParam(message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = this.getSecurityIdentity(20, invId, secContext, hasSecContext);
        if (securityIdentity == null) {
            return;
        }
        securityIdentity.runAsConsumer((o, x) -> {
            try {
                boolean onePhaseCopy = o;
                ImportResult<LocalTransaction> importResult = this.localTransactionContext.findOrImportTransaction((Xid)x, 0, !onePhaseCopy);
                if (importResult == null) {
                    this.writeExceptionResponse(20, invId, new XAException(-4));
                    return;
                }
                importResult.getControl().commit(onePhaseCopy);
                this.writeSimpleResponse(20, invId);
            }
            catch (XAException e) {
                this.writeExceptionResponse(20, invId, e);
                return;
            }
            catch (Exception e) {
                XAException xae = new XAException(-3);
                xae.initCause(e);
                this.writeExceptionResponse(20, invId, xae);
                return;
            }
        }, onePhase, xid);
    }

    void handleXaTxnRecover(MessageInputStream message, int invId) throws IOException {
        int param;
        int secContext = 0;
        String parentName = null;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32(message);
            switch (param) {
                case 240: {
                    secContext = Protocol.readIntParam(message, len);
                    hasSecContext = true;
                    continue block4;
                }
                case 3: {
                    parentName = Protocol.readStringParam(message, len);
                    continue block4;
                }
            }
            Protocol.readIntParam(message, len);
        }
        SecurityIdentity securityIdentity = this.getSecurityIdentity(23, invId, secContext, hasSecContext);
        if (securityIdentity == null) {
            return;
        }
        String finalParentName = parentName;
        securityIdentity.runAs(() -> {
            Xid[] xids;
            XARecoverable recoverable = this.localTransactionContext.getRecoveryInterface();
            try {
                xids = recoverable.recover(0x1000000, finalParentName);
            }
            catch (XAException e) {
                this.writeExceptionResponse(23, invId, e);
                return;
            }
            try {
                MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();
                try {
                    SimpleXid gtid;
                    boolean added;
                    outputStream.writeShort(invId);
                    outputStream.writeByte(23);
                    HashSet<SimpleXid> seen = new HashSet<SimpleXid>();
                    do {
                        added = false;
                        for (Xid xid : xids) {
                            gtid = SimpleXid.of(xid).withoutBranch();
                            if (!seen.add(gtid)) continue;
                            added = true;
                            Protocol.writeParam(1, (OutputStream)outputStream, xid);
                        }
                        if (!added) continue;
                        try {
                            xids = recoverable.recover(0, finalParentName);
                        }
                        catch (XAException e) {
                            try {
                                recoverable.recover(0x800000, finalParentName);
                                this.writeExceptionResponse(23, invId, e);
                            }
                            catch (XAException e1) {
                                e1.addSuppressed(e);
                                this.writeExceptionResponse(23, invId, e1);
                            }
                            if (outputStream != null) {
                                outputStream.close();
                            }
                            return;
                        }
                    } while (xids.length > 0 && added);
                    try {
                        xids = recoverable.recover(0x800000, finalParentName);
                    }
                    catch (XAException e) {
                        try {
                            recoverable.recover(0x800000, finalParentName);
                            this.writeExceptionResponse(23, invId, e);
                        }
                        catch (XAException e1) {
                            e1.addSuppressed(e);
                            this.writeExceptionResponse(23, invId, e1);
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        return;
                    }
                    for (Xid xid : xids) {
                        gtid = SimpleXid.of(xid).withoutBranch();
                        if (!seen.add(gtid)) continue;
                        Protocol.writeParam(1, (OutputStream)outputStream, xid);
                    }
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable) {
                            Throwable seen;
                            seen.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (IOException e) {
                Log.log.outboundException(e);
                try {
                    recoverable.recover(0x800000);
                }
                catch (XAException e1) {
                    Log.log.recoverySuppressedException(e1);
                }
            }
        });
    }

    private SecurityIdentity getSecurityIdentity(int msgId, int invId, int secContext, boolean hasSecContext) {
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        if (!securityIdentity.implies(RemoteTransactionPermission.getInstance())) {
            this.writeExceptionResponse(msgId, invId, 32, Log.log.noPermission(securityIdentity.getPrincipal().getName(), RemoteTransactionPermission.getInstance()));
            return null;
        }
        return securityIdentity;
    }

    void writeSimpleResponse(int msgId, int invId, int param1) {
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeShort(invId);
            outputStream.writeByte(msgId);
            Protocol.writeParam(param1, outputStream);
        }
        catch (IOException e) {
            Log.log.outboundException(e);
        }
    }

    private void writeExceptionResponse(int msgId, int invId, int exceptionKind, Exception e) {
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeShort(invId);
            outputStream.writeByte(msgId);
            StreamUtils.writeInt8((OutputStream)outputStream, exceptionKind);
            RemoteExceptionCause remoteExceptionCause = RemoteExceptionCause.of(e);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            remoteExceptionCause.writeToStream(dos);
            dos.flush();
            StreamUtils.writePackedUnsignedInt31(outputStream, os.size());
            os.writeTo(outputStream);
        }
        catch (IOException ioe) {
            Log.log.outboundException(ioe);
        }
    }

    private void writeExceptionResponse(int msgId, int invId, int exceptionKind, Exception e, int errorCode) {
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeShort(invId);
            outputStream.writeByte(msgId);
            StreamUtils.writeInt8((OutputStream)outputStream, exceptionKind);
            RemoteExceptionCause remoteExceptionCause = RemoteExceptionCause.of(e);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeInt(errorCode);
            remoteExceptionCause.writeToStream(dos);
            dos.flush();
            StreamUtils.writePackedUnsignedInt31(outputStream, os.size());
            os.writeTo(outputStream);
        }
        catch (IOException ioe) {
            Log.log.outboundException(ioe);
        }
    }

    private void writeExceptionResponse(int msgId, int invId, SystemException e) {
        this.writeExceptionResponse(msgId, invId, 19, e, e.errorCode);
    }

    private void writeExceptionResponse(int msgId, int invId, XAException e) {
        this.writeExceptionResponse(msgId, invId, 48, e, e.errorCode);
    }

    void writeSimpleResponse(int msgId, int invId) {
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeShort(invId);
            outputStream.writeByte(msgId);
        }
        catch (IOException e) {
            Log.log.outboundException(e);
        }
    }

    void writeParamError(int invId) {
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeShort(invId);
            outputStream.writeByte(254);
        }
        catch (IOException e) {
            Log.log.outboundException(e);
        }
    }

    class ReceiverImpl
    implements Channel.Receiver {
        ReceiverImpl() {
        }

        @Override
        public void handleMessage(Channel channel, MessageInputStream messageOriginal) {
            channel.receiveMessage(this);
            try (MessageInputStream message = messageOriginal;){
                int invId = message.readUnsignedShort();
                try {
                    int id = message.readUnsignedByte();
                    switch (id) {
                        case 0: {
                            TransactionServerChannel.this.handleCapabilityMessage(message, invId);
                            break;
                        }
                        case 11: {
                            TransactionServerChannel.this.handleUserTxnRollback(message, invId);
                            break;
                        }
                        case 10: {
                            TransactionServerChannel.this.handleUserTxnCommit(message, invId);
                            break;
                        }
                        case 2: {
                            TransactionServerChannel.this.handleXaTxnRollback(message, invId);
                            break;
                        }
                        case 6: {
                            TransactionServerChannel.this.handleXaTxnBefore(message, invId);
                            break;
                        }
                        case 3: {
                            TransactionServerChannel.this.handleXaTxnPrepare(message, invId);
                            break;
                        }
                        case 5: {
                            TransactionServerChannel.this.handleXaTxnForget(message, invId);
                            break;
                        }
                        case 4: {
                            TransactionServerChannel.this.handleXaTxnCommit(message, invId);
                            break;
                        }
                        case 7: {
                            TransactionServerChannel.this.handleXaTxnRecover(message, invId);
                            break;
                        }
                        case 8: {
                            TransactionServerChannel.this.handleXaTxnRollbackOnly(message, invId);
                            break;
                        }
                        default: {
                            try (MessageOutputStream outputStream = TransactionServerChannel.this.messageTracker.openMessageUninterruptibly();){
                                outputStream.writeShort(invId);
                                outputStream.writeByte(255);
                                break;
                            }
                            catch (IOException e) {
                                Log.log.outboundException(e);
                                break;
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    try (MessageOutputStream outputStream = TransactionServerChannel.this.messageTracker.openMessageUninterruptibly();){
                        outputStream.writeShort(invId);
                        outputStream.writeByte(255);
                    }
                    catch (IOException e) {
                        Log.log.outboundException(e);
                    }
                    throw t;
                }
            }
            catch (IOException e) {
                Log.log.inboundException(e);
            }
        }

        @Override
        public void handleError(Channel channel, IOException error) {
        }

        @Override
        public void handleEnd(Channel channel) {
        }
    }
}

