/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.AbstractProducerCreditsImpl;
import org.apache.activemq.artemis.core.client.impl.ClientProducerFlowCallback;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousProducerCreditsImpl
extends AbstractProducerCreditsImpl {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    int balance;
    final ClientProducerFlowCallback callback;

    public AsynchronousProducerCreditsImpl(ClientSessionInternal session, SimpleString address, int windowSize, ClientProducerFlowCallback callback) {
        super(session, address, windowSize);
        this.balance = windowSize;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void actualAcquire(int credits) {
        AsynchronousProducerCreditsImpl asynchronousProducerCreditsImpl = this;
        synchronized (asynchronousProducerCreditsImpl) {
            this.balance -= credits;
            if (logger.isDebugEnabled()) {
                logger.debug("actualAcquire on address {} with credits={}, balance={}, callbackType={}", this.address, credits, this.balance, this.callback.getClass());
            }
            if (this.balance <= 0) {
                this.callback.onCreditsFlow(true, this);
            }
        }
    }

    @Override
    public int getBalance() {
        return this.balance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveCredits(int credits) {
        AsynchronousProducerCreditsImpl asynchronousProducerCreditsImpl = this;
        synchronized (asynchronousProducerCreditsImpl) {
            super.receiveCredits(credits);
            this.balance += credits;
            if (logger.isDebugEnabled()) {
                logger.debug("receiveCredits with credits={}, balance={}, arriving={}, callbackType={}", credits, this.balance, this.arriving, this.callback.getClass());
            }
            this.callback.onCreditsFlow(this.balance <= 0, this);
            if (this.balance < 0 && this.arriving == 0) {
                logger.debug("Starve credits counter balance");
                int request = -this.balance + this.windowSize * 2;
                this.requestCredits(request);
            }
        }
    }

    @Override
    public void receiveFailCredits(int credits) {
        super.receiveFailCredits(credits);
        if (logger.isDebugEnabled()) {
            logger.debug("creditsFail {}, callback={}", (Object)credits, (Object)this.callback.getClass());
        }
        this.callback.onCreditsFail(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseOutstanding() {
        AsynchronousProducerCreditsImpl asynchronousProducerCreditsImpl = this;
        synchronized (asynchronousProducerCreditsImpl) {
            this.balance = 0;
            this.callback.onCreditsFlow(true, this);
            if (logger.isDebugEnabled()) {
                logger.debug("releaseOutstanding credits, balance={}, callback={}", (Object)this.balance, (Object)this.callback.getClass());
            }
        }
    }
}

