/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.server;

import java.net.InetAddress;
import java.util.List;
import org.jboss.remoting3.Connection;

public interface ClusterTopologyListener {
    public void clusterTopology(List<ClusterInfo> var1);

    public void clusterRemoval(List<String> var1);

    public void clusterNewNodesAdded(ClusterInfo var1);

    public void clusterNodesRemoved(List<ClusterRemovalInfo> var1);

    public Connection getConnection();

    public static final class ClusterRemovalInfo {
        private final String clusterName;
        private final List<String> nodeNames;

        public ClusterRemovalInfo(String clusterName, List<String> nodeNames) {
            this.clusterName = clusterName;
            this.nodeNames = nodeNames;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public List<String> getNodeNames() {
            return this.nodeNames;
        }
    }

    public static final class MappingInfo {
        private final String destinationAddress;
        private final int destinationPort;
        private final InetAddress sourceAddress;
        private final int netmaskBits;

        public MappingInfo(String destinationAddress, int destinationPort, InetAddress sourceAddress, int netmaskBits) {
            this.destinationAddress = destinationAddress;
            this.destinationPort = destinationPort;
            this.sourceAddress = sourceAddress;
            this.netmaskBits = netmaskBits;
        }

        public String getDestinationAddress() {
            return this.destinationAddress;
        }

        public int getDestinationPort() {
            return this.destinationPort;
        }

        public InetAddress getSourceAddress() {
            return this.sourceAddress;
        }

        public int getNetmaskBits() {
            return this.netmaskBits;
        }
    }

    public static final class NodeInfo {
        private final String nodeName;
        private final List<MappingInfo> mappingInfoList;

        public NodeInfo(String nodeName, List<MappingInfo> mappingInfoList) {
            this.nodeName = nodeName;
            this.mappingInfoList = mappingInfoList;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public List<MappingInfo> getMappingInfoList() {
            return this.mappingInfoList;
        }
    }

    public static final class ClusterInfo {
        private final String clusterName;
        private final List<NodeInfo> nodeInfoList;

        public ClusterInfo(String clusterName, List<NodeInfo> nodeInfoList) {
            this.clusterName = clusterName;
            this.nodeInfoList = nodeInfoList;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public List<NodeInfo> getNodeInfoList() {
            return this.nodeInfoList;
        }
    }
}

