/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import org.jboss.marshalling.SerializabilityChecker;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.river.ClassDescriptor;

abstract class SerializableClassDescriptor
extends ClassDescriptor {
    protected SerializableClassDescriptor() {
    }

    @Override
    public abstract Class<?> getType();

    @Override
    public abstract int getTypeID();

    @Override
    public Class<?> getNearestType() {
        Class<?> type = this.getType();
        return type == null ? this.getSuperClassDescriptor().getNearestType() : type;
    }

    public abstract ClassDescriptor getSuperClassDescriptor();

    public abstract SerializableField[] getFields();

    public abstract SerializableClass getSerializableClass();

    public String toString() {
        ClassDescriptor superClassDescriptor = this.getSuperClassDescriptor();
        if (superClassDescriptor == null) {
            return String.format("%s for %s (id %x02)", this.getClass().getSimpleName(), this.getType(), this.getTypeID());
        }
        return String.format("%s for %s (id %x02) extends %s", this.getClass().getSimpleName(), this.getType(), this.getTypeID(), superClassDescriptor);
    }

    public Class<?> getNonSerializableSuperclass(SerializabilityChecker checker) {
        Class<?> nearestType = this.getNearestType();
        if (nearestType == null) {
            return Object.class;
        }
        while (checker.isSerializable(nearestType)) {
            nearestType = nearestType.getSuperclass();
        }
        return nearestType;
    }
}

