/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import org.jboss.marshalling.ClassNameTransformer;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;

final class TransformingClassResolver
implements ClassResolver {
    private final ClassResolver delegate;
    private final ClassNameTransformer transformer;
    private final boolean in;

    TransformingClassResolver(ClassResolver delegate, ClassNameTransformer transformer, boolean in) {
        this.delegate = delegate;
        this.transformer = transformer;
        this.in = in;
    }

    @Override
    public void annotateClass(Marshaller marshaller, Class<?> clazz) throws IOException {
        this.delegate.annotateClass(marshaller, clazz);
    }

    @Override
    public void annotateProxyClass(Marshaller marshaller, Class<?> proxyClass) throws IOException {
        this.delegate.annotateProxyClass(marshaller, proxyClass);
    }

    @Override
    public String getClassName(Class<?> clazz) throws IOException {
        return this.translate(this.delegate.getClassName(clazz));
    }

    @Override
    public String[] getProxyInterfaces(Class<?> proxyClass) throws IOException {
        String[] retVal = this.delegate.getProxyInterfaces(proxyClass);
        if (retVal != null) {
            for (int i = 0; i < retVal.length; ++i) {
                retVal[i] = this.translate(retVal[i]);
            }
        }
        return retVal;
    }

    private String translate(String className) {
        if (this.in) {
            return this.transformer.transformInput(className);
        }
        return this.transformer.transformOutput(className);
    }

    @Override
    public Class<?> resolveClass(Unmarshaller unmarshaller, String name, long serialVersionUID) throws IOException, ClassNotFoundException {
        return this.delegate.resolveClass(unmarshaller, this.translate(name), serialVersionUID);
    }

    @Override
    public Class<?> resolveProxyClass(Unmarshaller unmarshaller, String[] interfaces) throws IOException, ClassNotFoundException {
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                interfaces[i] = this.translate(interfaces[i]);
            }
        }
        return this.delegate.resolveProxyClass(unmarshaller, interfaces);
    }
}

