/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class ReadOperationHandler
extends BaseOperationCommand {
    private final ArgumentWithValue node = new ArgumentWithValue((CommandHandlerWithArguments)this, OperationRequestCompleter.ARG_VALUE_COMPLETER, "--node");
    private final ArgumentWithValue name = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

        public List<String> getAllCandidates(CommandContext ctx) {
            try {
                OperationRequestAddress address = ReadOperationHandler.this.getAddress(ctx);
                ModelNode req = new ModelNode();
                if (address.isEmpty()) {
                    req.get("address").setEmptyList();
                } else {
                    if (address.endsOnType()) {
                        return Collections.emptyList();
                    }
                    ModelNode addrNode = req.get("address");
                    for (OperationRequestAddress.Node node : address) {
                        addrNode.add(node.getType(), node.getName());
                    }
                }
                req.get("operation").set("read-operation-names");
                if (ctx.getConfig().isAccessControl()) {
                    req.get("access-control").set(true);
                }
                try {
                    ModelNode response = ctx.getModelControllerClient().execute(req);
                    return Util.getList(response);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (CommandFormatException e) {
                return Collections.emptyList();
            }
            return Collections.emptyList();
        }
    }), 0, "--name");

    public ReadOperationHandler(CommandContext ctx) {
        super(ctx, "read-operation", true);
    }

    @Override
    public ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        String name = this.name.getValue(parsedCmd);
        if (name == null || name.isEmpty()) {
            OperationRequestAddress address = this.getAddress(ctx);
            ModelNode request = Util.buildRequest(ctx, address, "read-operation-names");
            if (ctx.getConfig().isAccessControl()) {
                request.get("access-control").set(true);
            }
            return request;
        }
        OperationRequestAddress address = this.getAddress(ctx);
        ModelNode req = Util.buildRequest(ctx, address, "read-operation-description");
        req.get("name").set(name);
        return req;
    }

    @Override
    protected void handleResponse(CommandContext ctx, ModelNode response, boolean composite) throws CommandFormatException {
        boolean opDescr;
        if (!Util.isSuccess(response)) {
            throw new CommandFormatException(Util.getFailureDescription(response));
        }
        if (!response.hasDefined("result")) {
            return;
        }
        try {
            opDescr = this.name.isPresent(ctx.getParsedCommandLine());
        }
        catch (CommandFormatException e) {
            throw new CommandFormatException("Failed to read argument " + this.name.getFullName() + ": " + e.getLocalizedMessage());
        }
        if (opDescr) {
            List<Property> props;
            ModelNode result = response.get("result");
            if (result.has("description")) {
                ctx.printLine("\n\t" + result.get("description").asString());
            } else {
                ctx.printLine("Operation description is not available.");
            }
            StringBuilder buf = new StringBuilder();
            buf.append("\n\nPARAMETERS\n");
            if (result.has("request-properties")) {
                props = result.get("request-properties").asPropertyList();
                if (props.isEmpty()) {
                    buf.append("\n\tn/a\n");
                } else {
                    for (Property prop : props) {
                        buf.append('\n');
                        buf.append(prop.getName()).append("\n\n");
                        List<Property> propProps = prop.getValue().asPropertyList();
                        SimpleTable table = new SimpleTable(2, ctx.getTerminalWidth());
                        for (Property propProp : propProps) {
                            if (propProp.getName().equals("description")) {
                                buf.append('\t').append(propProp.getValue().asString()).append("\n\n");
                                continue;
                            }
                            if (propProp.getName().equals("value-type")) continue;
                            table.addLine("\t" + propProp.getName() + ":", propProp.getValue().asString());
                        }
                        table.append(buf, false);
                        buf.append('\n');
                    }
                }
            } else {
                buf.append("\n\tn/a\n");
            }
            ctx.printLine(buf.toString());
            buf.setLength(0);
            buf.append("\nRESPONSE\n");
            if (result.has("reply-properties")) {
                props = result.get("reply-properties").asPropertyList();
                if (props.isEmpty()) {
                    buf.append("\n\tn/a\n");
                } else {
                    buf.append('\n');
                    SimpleTable table = new SimpleTable(2, ctx.getTerminalWidth());
                    StringBuilder vtBuf = null;
                    for (Property prop : props) {
                        ModelType modelType = prop.getValue().getType();
                        if (prop.getName().equals("description")) {
                            buf.append('\t').append(prop.getValue().asString()).append("\n\n");
                            continue;
                        }
                        if (prop.getName().equals("value-type") && (prop.getValue().getType() == ModelType.OBJECT || prop.getValue().getType() == ModelType.LIST)) {
                            List<Property> vtProps = prop.getValue().asPropertyList();
                            if (vtProps.isEmpty()) continue;
                            vtBuf = new StringBuilder();
                            for (Property vtProp : vtProps) {
                                vtBuf.append('\n').append(vtProp.getName()).append("\n\n");
                                List<Property> vtPropProps = vtProp.getValue().asPropertyList();
                                SimpleTable vtTable = new SimpleTable(2, ctx.getTerminalWidth());
                                for (Property vtPropProp : vtPropProps) {
                                    if (vtPropProp.getName().equals("description")) {
                                        vtBuf.append('\t').append(vtPropProp.getValue().asString()).append("\n\n");
                                        continue;
                                    }
                                    if (vtPropProp.getName().equals("value-type")) continue;
                                    vtTable.addLine("\t" + vtPropProp.getName() + ":", vtPropProp.getValue().asString());
                                }
                                vtTable.append(vtBuf, false);
                                vtBuf.append('\n');
                            }
                            continue;
                        }
                        table.addLine("\t" + prop.getName() + ":", prop.getValue().asString());
                    }
                    table.append(buf, false);
                    buf.append('\n');
                    if (vtBuf != null) {
                        buf.append((CharSequence)vtBuf);
                    }
                }
            } else {
                buf.append("\n\tn/a\n");
            }
            ctx.printLine(buf.toString());
        } else {
            ctx.printColumns(Util.getList(response));
        }
    }

    protected OperationRequestAddress getAddress(CommandContext ctx) throws CommandFormatException {
        DefaultOperationRequestAddress address;
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (this.node.isPresent(args)) {
            address = new DefaultOperationRequestAddress(ctx.getCurrentNodePath());
            DefaultCallbackHandler handler = new DefaultCallbackHandler(address);
            String nodePath = args.getOriginalLine();
            int nodeArgInd = nodePath.indexOf(" --node=");
            if (nodeArgInd < 0) {
                throw new CommandFormatException("Couldn't locate ' --node=' in the line: '" + nodePath + "'");
            }
            int nodeArgEndInd = nodeArgInd + 8;
            do {
                if ((nodeArgEndInd = nodePath.indexOf(32, nodeArgEndInd)) < 0) {
                    nodeArgEndInd = nodePath.length();
                    continue;
                }
                if (nodePath.charAt(nodeArgEndInd - 1) != '\\') break;
                ++nodeArgEndInd;
            } while (nodeArgEndInd < nodePath.length());
            nodePath = nodePath.substring(nodeArgInd + 8, nodeArgEndInd);
            ctx.getCommandLineParser().parse(nodePath, handler);
        } else {
            address = new DefaultOperationRequestAddress(ctx.getCurrentNodePath());
        }
        return address;
    }
}

