/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.HashMap;
import java.util.Map;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;

public final class ClassifyingModuleLoader
extends ModuleLoader {
    private volatile Map<String, ModuleLoader> delegates;
    private final ModuleLoader defaultLoader;
    private final String name;

    public ClassifyingModuleLoader(String name, Map<String, ModuleLoader> delegates, ModuleLoader defaultLoader) {
        super(true, false);
        this.defaultLoader = defaultLoader;
        this.delegates = new HashMap<String, ModuleLoader>(delegates);
        this.name = name;
    }

    @Override
    protected Module preloadModule(String name) throws ModuleLoadException {
        Map<String, ModuleLoader> delegates = this.delegates;
        ModuleLoader loader;
        while ((loader = delegates.get(name)) == null) {
            int idx = name.lastIndexOf(46);
            if (idx == -1) {
                return ClassifyingModuleLoader.preloadModule(name, this.defaultLoader);
            }
            name = name.substring(0, idx);
        }
        return ClassifyingModuleLoader.preloadModule(name, loader);
    }

    @Override
    protected ModuleSpec findModule(String name) throws ModuleLoadException {
        return null;
    }

    public void setDelegates(Map<String, ModuleLoader> delegates) {
        this.delegates = new HashMap<String, ModuleLoader>(delegates);
    }

    @Override
    public String toString() {
        return String.format("Classifying Module Loader @%x \"%s\"", this.hashCode(), this.name);
    }
}

