/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionSynchronizationRegistry;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client._private.Log;

public final class ContextTransactionSynchronizationRegistry
implements TransactionSynchronizationRegistry {
    private static final ContextTransactionSynchronizationRegistry instance = new ContextTransactionSynchronizationRegistry();

    private ContextTransactionSynchronizationRegistry() {
    }

    public static ContextTransactionSynchronizationRegistry getInstance() {
        return instance;
    }

    @Override
    public Object getTransactionKey() {
        AbstractTransaction transaction = ContextTransactionManager.getInstance().getStateRef().get().transaction;
        return transaction == null ? null : transaction.getKey();
    }

    @Override
    public int getTransactionStatus() {
        try {
            return ContextTransactionManager.getInstance().getStatus();
        }
        catch (SystemException e) {
            return 5;
        }
    }

    @Override
    public boolean getRollbackOnly() throws IllegalStateException {
        AbstractTransaction transaction = ContextTransactionManager.getInstance().getStateRef().get().transaction;
        if (transaction == null) {
            throw Log.log.noTransaction();
        }
        return transaction.getRollbackOnly();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException {
        try {
            ContextTransactionManager.getInstance().setRollbackOnly();
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    @Override
    public void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
        AbstractTransaction transaction = ContextTransactionManager.getInstance().getStateRef().get().transaction;
        if (transaction == null) {
            throw Log.log.noTransaction();
        }
        transaction.registerInterposedSynchronization(sync);
    }

    @Override
    public Object getResource(Object key) throws IllegalStateException {
        AbstractTransaction transaction = ContextTransactionManager.getInstance().getStateRef().get().transaction;
        if (transaction == null) {
            throw Log.log.noTransaction();
        }
        return transaction.getResource(key);
    }

    @Override
    public void putResource(Object key, Object value) throws IllegalStateException {
        AbstractTransaction transaction = ContextTransactionManager.getInstance().getStateRef().get().transaction;
        if (transaction == null) {
            throw Log.log.noTransaction();
        }
        transaction.putResource(key, value);
    }
}

