/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded.logging;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleLoader;
import org.wildfly.core.embedded.Context;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.logging.EmbeddedLogger;

public class EmbeddedLogger_$logger
extends DelegatingBasicLogger
implements EmbeddedLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = EmbeddedLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public EmbeddedLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String invalidJBossHome$str() {
        return "WFLYEMB0011: Invalid JBoss home directory: %s";
    }

    @Override
    public final IllegalStateException invalidJBossHome(String jbossHome) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidJBossHome$str(), jbossHome));
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String moduleLoaderError$str() {
        return "WFLYEMB0014: Cannot load module %s from: %s";
    }

    @Override
    public final RuntimeException moduleLoaderError(Throwable cause, String msg, ModuleLoader moduleLoader) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.moduleLoaderError$str(), msg, moduleLoader), cause);
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullVar$str() {
        return "WFLYEMB0015: %s is null";
    }

    @Override
    public final IllegalArgumentException nullVar(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullVar$str(), name));
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotLoadEmbeddedServerFactory$str() {
        return "WFLYEMB0017: Cannot load embedded server factory: %s";
    }

    @Override
    public final IllegalStateException cannotLoadEmbeddedServerFactory(ClassNotFoundException cause, String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotLoadEmbeddedServerFactory$str(), className), cause);
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotGetReflectiveMethod$str() {
        return "WFLYEMB0018: Cannot get reflective method '%s' for: %s";
    }

    @Override
    public final IllegalStateException cannotGetReflectiveMethod(NoSuchMethodException cause, String method, String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotGetReflectiveMethod$str(), method, className), cause);
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateStandaloneServer$str() {
        return "WFLYEMB0019: Cannot create standalone server using factory: %s";
    }

    @Override
    public final IllegalStateException cannotCreateStandaloneServer(Throwable cause, Method createMethod) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotCreateStandaloneServer$str(), createMethod), cause);
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotSetupEmbeddedServer$str() {
        return "WFLYEMB0020: Cannot setup embedded process";
    }

    @Override
    public final IllegalStateException cannotSetupEmbeddedServer(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotSetupEmbeddedServer$str(), new Object[0]), cause);
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotStartEmbeddedServer$str() {
        return "WFLYEMB0021: Cannot start embedded process";
    }

    @Override
    public final EmbeddedProcessStartException cannotStartEmbeddedServer(Throwable cause) {
        EmbeddedProcessStartException result = new EmbeddedProcessStartException(String.format(this.getLoggingLocale(), this.cannotStartEmbeddedServer$str(), new Object[0]), cause);
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInvokeStandaloneServer$str() {
        return "WFLYEMB0022: Cannot invoke '%s' on embedded process";
    }

    @Override
    public final IllegalStateException cannotInvokeStandaloneServer(Throwable cause, String methodName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotInvokeStandaloneServer$str(), methodName), cause);
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String processIsStopping$str() {
        return "WFLYEMB0023: The embedded server is stopping and invocations on the ModelControllerClient are not available";
    }

    @Override
    public final IllegalStateException processIsStopping() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.processIsStopping$str(), new Object[0]));
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String processIsReloading$str() {
        return "WFLYEMB0024: The embedded server is reloading and invocations on the ModelControllerClient are not yet available";
    }

    @Override
    public final IllegalStateException processIsReloading() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.processIsReloading$str(), new Object[0]));
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateHostController$str() {
        return "WFLYEMB0026: Cannot create host controller using factory: %s";
    }

    @Override
    public final IllegalStateException cannotCreateHostController(Throwable cause, Method createMethod) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotCreateHostController$str(), createMethod), cause);
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String processIsStopped$str() {
        return "WFLYEMB0027: The embedded server is stopped and invocations on the ModelControllerClient are not available";
    }

    @Override
    public final IllegalStateException processIsStopped() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.processIsStopped$str(), new Object[0]));
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorCopyingFile$str() {
        return "WFLYEMB0028: Error copying '%s' to '%s' (%s)";
    }

    @Override
    public final RuntimeException errorCopyingFile(String absolutePath, String absolutePath2, IOException e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorCopyingFile$str(), absolutePath, absolutePath2, e));
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String propertySpecifiedFileIsNotADirectory$str() {
        return "WFLYEMB0029: -D%s=%s is not a directory";
    }

    @Override
    public final IllegalArgumentException propertySpecifiedFileIsNotADirectory(String property, String absolutePath) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.propertySpecifiedFileIsNotADirectory$str(), property, absolutePath));
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String propertySpecifiedFileDoesNotExist$str() {
        return "WFLYEMB0144: -D%s=%s does not exist";
    }

    @Override
    public final IllegalArgumentException propertySpecifiedFileDoesNotExist(String property, String absolutePath) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.propertySpecifiedFileDoesNotExist$str(), property, absolutePath));
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String embeddedServerDirectoryNotFound$str() {
        return "WFLYEMB0143: No directory called '%s' exists under '%s'";
    }

    @Override
    public final IllegalArgumentException embeddedServerDirectoryNotFound(String string, String absolutePath) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.embeddedServerDirectoryNotFound$str(), string, absolutePath));
        EmbeddedLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void moduleLoaderAlreadyConfigured(String propertyName) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.moduleLoaderAlreadyConfigured$str(), (Object)propertyName);
    }

    protected String moduleLoaderAlreadyConfigured$str() {
        return "WFLYEMB0145: The module loader has already been configured. Changing the %s property will have no effect.";
    }

    @Override
    public final void failedToRestoreContext(Throwable cause, Context context) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToRestoreContext$str(), (Object)context);
    }

    protected String failedToRestoreContext$str() {
        return "WFLYEMB0146: Failed to restore context %s";
    }

    @Override
    public final void errorExitingEmbeddedProcess(Throwable cause, String processType, String error) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorExitingEmbeddedProcess$str(), (Object)processType, (Object)error);
    }

    protected String errorExitingEmbeddedProcess$str() {
        return "WFLYEMB0147: Error exiting embedded %s: %s";
    }
}

