/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.wildfly.httpclient.naming.HttpRootContext;
import org.wildfly.naming.client.util.FastHashtable;

final class HttpRemoteContext
implements Context {
    private final HttpRootContext rootContext;
    private final String rootName;
    private final Hashtable<Object, Object> environment;

    public HttpRemoteContext(HttpRootContext rootContext, String rootName) {
        this.rootContext = rootContext;
        this.rootName = rootName;
        try {
            this.environment = new FastHashtable<Object, Object>(rootContext.getEnvironment());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.rootContext.lookupNative(this.getNameOf(name));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.rootContext.lookupNative(this.getNameOf(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.rootContext.bindNative(this.getNameOf(name), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.rootContext.bindNative(this.getNameOf(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rootContext.rebindNative(this.getNameOf(name), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rootContext.rebindNative(this.getNameOf(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.rootContext.unbindNative(this.getNameOf(name));
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.rootContext.unbindNative(this.getNameOf(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.rootContext.renameNative(this.getNameOf(oldName), this.getNameOf(newName));
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rootContext.renameNative(this.getNameOf(oldName), this.getNameOf(newName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.rootContext.listNative(this.getNameOf(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.rootContext.listNative(this.getNameOf(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.rootContext.listBindingsNative(this.getNameOf(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.rootContext.listBindingsNative(this.getNameOf(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.rootContext.destroySubcontextNative(this.getNameOf(name));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.rootContext.destroySubcontextNative(this.getNameOf(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.rootContext.createSubcontextNative(this.getNameOf(name));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.rootContext.createSubcontextNative(this.getNameOf(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.rootContext.lookupLinkNative(this.getNameOf(name));
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.rootContext.lookupLinkNative(this.getNameOf(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.rootContext.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.rootContext.getNameParser(name);
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.rootContext.composeName(name, prefix);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.rootContext.composeName(name, prefix);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.rootName;
    }

    private CompositeName getNameOf(Object name) throws InvalidNameException {
        if (name == null) {
            throw new InvalidNameException();
        }
        return new CompositeName(this.rootName + "/" + name);
    }
}

