/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.component.ServerLogsTable;
import org.jboss.as.cli.gui.component.ServerLogsTableModel;
import org.jboss.as.cli.gui.metacommand.DownloadServerLogDialog;
import org.jboss.dmr.ModelNode;

public class ServerLogsPanel
extends JPanel {
    private final ServerLogsTable table;
    private final ServerLogsTableModel tableModel;
    private final CliGuiContext cliGuiCtx;

    public ServerLogsPanel(CliGuiContext cliGuiCtx) {
        this.cliGuiCtx = cliGuiCtx;
        this.setLayout(new BorderLayout());
        this.table = new ServerLogsTable();
        this.tableModel = new ServerLogsTableModel(cliGuiCtx, this.table);
        this.table.setModel(this.tableModel);
        this.tableModel.refresh();
        JScrollPane scroller = new JScrollPane(this.table);
        this.add((Component)scroller, "Center");
        this.add((Component)this.makeButtonPanel(), "South");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServerLogsPanel.this.drawDownloadDialog();
                }
            }
        });
    }

    public static boolean isLogDownloadAvailable(CliGuiContext cliGuiCtx) {
        ModelNode readOps = null;
        try {
            readOps = cliGuiCtx.getExecutor().doCommand("/subsystem=logging:read-children-types");
        }
        catch (IOException | CommandFormatException e) {
            return false;
        }
        if (!readOps.get("result").isDefined()) {
            return false;
        }
        for (ModelNode op : readOps.get("result").asList()) {
            if (!"log-file".equals(op.asString())) continue;
            return true;
        }
        return false;
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(new DownloadButton());
        buttonPanel.add(new RefreshButton());
        return buttonPanel;
    }

    private String getSelectedFileName() {
        return (String)this.table.getValueAt(this.table.getSelectedRow(), 0);
    }

    private Long getSelectedFileSize() {
        return (Long)this.table.getValueAt(this.table.getSelectedRow(), 2);
    }

    private void drawDownloadDialog() {
        DownloadServerLogDialog dialog = new DownloadServerLogDialog(this.cliGuiCtx, this.getSelectedFileName(), this.getSelectedFileSize());
        dialog.setLocationRelativeTo(this.cliGuiCtx.getMainWindow());
        dialog.setVisible(true);
    }

    private class DownloadButton
    extends JButton {
        public DownloadButton() {
            super("Download");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServerLogsPanel.this.drawDownloadDialog();
                }
            });
        }
    }

    private class RefreshButton
    extends JButton {
        public RefreshButton() {
            super("Refresh List");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServerLogsPanel.this.tableModel.refresh();
                }
            });
        }
    }
}

