/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.IOException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.client.logging.ControllerClientLogger;
import org.jboss.dmr.ModelNode;

public interface LocalModelControllerClient
extends ModelControllerClient {
    @Override
    default public ModelNode execute(ModelNode operation) {
        return this.execute(Operation.Factory.create(operation), OperationMessageHandler.DISCARD);
    }

    @Override
    default public ModelNode execute(Operation operation) {
        return this.execute(operation, OperationMessageHandler.DISCARD);
    }

    @Override
    default public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) {
        return this.execute(Operation.Factory.create(operation), messageHandler);
    }

    @Override
    default public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) {
        OperationResponse or = this.executeOperation(operation, messageHandler);
        ModelNode result = or.getResponseNode();
        try {
            or.close();
        }
        catch (IOException e) {
            ControllerClientLogger.ROOT_LOGGER.debugf((Throwable)e, "Failed closing response to %s", (Object)operation);
        }
        return result;
    }

    @Override
    public OperationResponse executeOperation(Operation var1, OperationMessageHandler var2);

    @Override
    public void close();
}

