/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.groovy;

import groovy.lang.Script;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.PropertyResolver;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.groovy.MavenBaseScript;
import org.commonjava.maven.ext.core.impl.Version;
import org.commonjava.maven.ext.core.state.VersioningState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseScriptUtils
extends Script
implements MavenBaseScript {
    final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void inlineProperty(Project currentProject, ProjectRef groupArtifact) throws ManipulationException {
        this.logger.debug("Inlining property for {} with reference {}", (Object)currentProject, (Object)groupArtifact);
        try {
            currentProject.getResolvedManagedDependencies(this.getSession()).entrySet().stream().filter(a -> groupArtifact.getArtifactId().equals("*") && ((ArtifactRef)a.getKey()).getGroupId().equals(groupArtifact.getGroupId()) || ((ArtifactRef)a.getKey()).asProjectRef().equals(groupArtifact) && ((Dependency)a.getValue()).getVersion().contains("$")).forEach(a -> {
                this.logger.debug("Found managed artifact {} (original dependency {})", a.getKey(), a.getValue());
                ((Dependency)a.getValue()).setVersion(PropertyResolver.resolvePropertiesUnchecked(this.getSession(), currentProject.getInheritedList(), ((Dependency)a.getValue()).getVersion()));
            });
            currentProject.getResolvedDependencies(this.getSession()).entrySet().stream().filter(a -> groupArtifact.getArtifactId().equals("*") && ((ArtifactRef)a.getKey()).getGroupId().equals(groupArtifact.getGroupId()) || ((ArtifactRef)a.getKey()).asProjectRef().equals(groupArtifact) && ((Dependency)a.getValue()).getVersion().contains("$")).forEach(a -> {
                this.logger.debug("Found artifact {} (original dependency {})", a.getKey(), a.getValue());
                ((Dependency)a.getValue()).setVersion(PropertyResolver.resolvePropertiesUnchecked(this.getSession(), currentProject.getInheritedList(), ((Dependency)a.getValue()).getVersion()));
            });
        }
        catch (ManipulationUncheckedException e) {
            throw (ManipulationException)e.getCause();
        }
    }

    public void inlineProperty(Project currentProject, String propertyKey) throws ManipulationException {
        this.logger.debug("Inlining property for {} with reference {}", (Object)currentProject, (Object)propertyKey);
        try {
            currentProject.getResolvedManagedDependencies(this.getSession()).entrySet().stream().filter(a -> ((Dependency)a.getValue()).getVersion().equals("${" + propertyKey + "}")).forEach(a -> {
                this.logger.debug("Found managed artifact {} (original dependency {})", a.getKey(), a.getValue());
                ((Dependency)a.getValue()).setVersion(PropertyResolver.resolvePropertiesUnchecked(this.getSession(), currentProject.getInheritedList(), ((Dependency)a.getValue()).getVersion()));
            });
            currentProject.getResolvedDependencies(this.getSession()).entrySet().stream().filter(a -> ((Dependency)a.getValue()).getVersion().equals("${" + propertyKey + "}")).forEach(a -> {
                this.logger.debug("Found artifact {} (original dependency {})", a.getKey(), a.getValue());
                ((Dependency)a.getValue()).setVersion(PropertyResolver.resolvePropertiesUnchecked(this.getSession(), currentProject.getInheritedList(), ((Dependency)a.getValue()).getVersion()));
            });
        }
        catch (ManipulationUncheckedException e) {
            throw (ManipulationException)e.getCause();
        }
    }

    protected void validateSession() throws ManipulationException {
        if (!(this.getSession() instanceof ManipulationSession)) {
            throw new ManipulationException("Unable to access session instance in {}", this.getSession());
        }
    }

    protected void reinitialiseSessionStates() throws ManipulationException {
        this.validateSession();
        ((ManipulationSession)this.getSession()).reinitialiseStates();
    }

    public void overrideProjectVersion(ProjectVersionRef gav) throws ManipulationException {
        ArrayList<ProjectVersionRef> source = new ArrayList<ProjectVersionRef>();
        source.add(gav);
        source.add(this.getGAV());
        Map<ProjectVersionRef, String> restResult = this.getRESTAPI().lookupVersions(source);
        String targetBuild = restResult.get(gav);
        String thisMapping = restResult.get(this.getGAV());
        if (targetBuild == null) {
            this.logger.error("REST result was {}", (Object)restResult);
            throw new ManipulationException("Multiple results returned ; unable to reset version.", new Object[0]);
        }
        if (thisMapping != null) {
            String suffix;
            this.logger.info("Comparing requested GAV {} with target GAV build {} to this GAV {} with known build {}", gav, targetBuild, this.getGAV(), thisMapping);
            if (!gav.getVersionString().equals(this.getGAV().getVersionString())) {
                this.logger.error("Alignment failure: Target is {} and this is {}", (Object)gav.getVersionString(), (Object)this.getGAV());
                throw new ManipulationException("Unable to set version suffix as versions do not match", new Object[0]);
            }
            VersioningState vs = ((ManipulationSession)this.getSession()).getState(VersioningState.class);
            List<String> suffixes = vs.getSuffixAlternatives();
            if (!suffixes.isEmpty() && thisMapping.contains(suffix = vs.getIncrementalSerialSuffix()) && targetBuild.contains(suffix) && Version.getIntegerBuildNumber(thisMapping) >= Version.getIntegerBuildNumber(targetBuild)) {
                this.logger.error("Alignment failure: Target is {} and this is {}", (Object)Version.getIntegerBuildNumber(targetBuild), (Object)Version.getIntegerBuildNumber(thisMapping));
                throw new ManipulationException("Unable to set version suffix as dependent build has been built more or the same number of times than the original target", new Object[0]);
            }
        }
        String newSuffix = targetBuild.substring(gav.getVersionString().length() + 1);
        this.logger.info("From version {}, updating versionSuffix to {}", (Object)targetBuild, (Object)newSuffix);
        this.getUserProperties().setProperty("versionSuffix", newSuffix);
        this.reinitialiseSessionStates();
    }

    public Logger getLogger() {
        return this.logger;
    }
}

