/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.impl.Version;
import org.commonjava.maven.ext.core.state.DependencyState;
import org.commonjava.maven.ext.core.state.PluginState;
import org.commonjava.maven.ext.core.state.ProfileInjectionState;
import org.commonjava.maven.ext.core.state.RESTState;
import org.commonjava.maven.ext.core.util.PropertiesUtils;
import org.commonjava.maven.ext.io.rest.RestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="rest-bom-manipulator")
@Singleton
public class RESTBOMCollector
implements Manipulator {
    private static final Logger logger = LoggerFactory.getLogger(RESTBOMCollector.class);
    private ManipulationSession session;

    @Override
    public void init(ManipulationSession session) {
        this.session = session;
        session.setState(new RESTState(session));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws RestException {
        this.populateBOMVersions();
        return Collections.emptySet();
    }

    @Override
    public int getExecutionIndex() {
        return 4;
    }

    private void populateBOMVersions() throws RestException {
        RESTState state = this.session.getState(RESTState.class);
        DependencyState ds = this.session.getState(DependencyState.class);
        PluginState ps = this.session.getState(PluginState.class);
        ProfileInjectionState pis = this.session.getState(ProfileInjectionState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return;
        }
        ArrayList<ProjectVersionRef> restParam = new ArrayList<ProjectVersionRef>();
        this.populateRestParam(restParam, "dependencyManagement", ds.getRemoteBOMDepMgmt());
        this.populateRestParam(restParam, "pluginManagement", ps.getRemotePluginMgmt());
        this.populateRestParam(restParam, "profileInjectionManagement", pis.getRemoteProfileInjectionMgmt());
        if (restParam.size() > 0) {
            logger.debug("Passing {} BOM GAVs following into the REST client api {}", (Object)restParam.size(), (Object)restParam);
            logger.info("Calling REST client for BOMs...");
            Map<ProjectVersionRef, String> restResult = state.getVersionTranslator().lookupVersions(restParam);
            logger.debug("REST Client returned for BOMs {}", (Object)restResult);
            ListIterator emptyIterator = Collections.emptyList().listIterator();
            this.updateBOM(ds.getRemoteBOMDepMgmt() == null ? emptyIterator : ds.getRemoteBOMDepMgmt().listIterator(), restResult);
            this.updateBOM(ps.getRemotePluginMgmt() == null ? emptyIterator : ps.getRemotePluginMgmt().listIterator(), restResult);
            this.updateBOM(pis.getRemoteProfileInjectionMgmt() == null ? emptyIterator : pis.getRemoteProfileInjectionMgmt().listIterator(), restResult);
        } else {
            logger.debug("No BOM GAVS to pass into REST client.");
        }
    }

    private void populateRestParam(ArrayList<ProjectVersionRef> restParam, String log, List<ProjectVersionRef> bomMgmt) {
        RESTBOMCollector.asStream(bomMgmt).filter(b -> !Version.hasBuildNumber(b.getVersionString()) && b.getVersionString().contains(PropertiesUtils.getSuffix(this.session))).forEach(bom -> {
            SimpleProjectVersionRef newBom = new SimpleProjectVersionRef(bom.asProjectRef(), bom.getVersionString() + "-0");
            logger.debug("Adding {} BOM {} into REST call.", (Object)log, (Object)newBom);
            restParam.add(newBom);
        });
    }

    private void updateBOM(ListIterator<ProjectVersionRef> iterator, Map<ProjectVersionRef, String> restResult) {
        while (iterator.hasNext()) {
            SimpleProjectVersionRef newBom;
            ProjectVersionRef pvr = iterator.next();
            if (Version.hasBuildNumber(pvr.getVersionString()) || !pvr.getVersionString().contains(PropertiesUtils.getSuffix(this.session)) || !restResult.containsKey(newBom = new SimpleProjectVersionRef(pvr.asProjectRef(), pvr.getVersionString() + "-0"))) continue;
            SimpleProjectVersionRef replacementBOM = new SimpleProjectVersionRef(pvr.asProjectRef(), restResult.get(newBom));
            logger.debug("Replacing BOM value of {} with {}.", (Object)pvr, (Object)replacementBOM);
            iterator.remove();
            iterator.add(replacementBOM);
        }
    }

    private static Stream<ProjectVersionRef> asStream(Collection<ProjectVersionRef> collection) {
        return collection == null ? Stream.empty() : collection.stream();
    }
}

