/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.commonjava.util.jhttpc.model.SiteTrustType;

public final class SiteConfig {
    public static final int DEFAULT_REQUEST_TIMEOUT_SECONDS = 10;
    public static final int DEFAULT_PROXY_PORT = 8080;
    public static final int DEFAULT_MAX_CONNECTIONS = 4;
    public static final int DEFAULT_CONNECTION_POOL_TIMEOUT_SECONDS = 60;
    private final String id;
    private final String uri;
    private final String user;
    private final String proxyHost;
    private final Integer proxyPort;
    private final String proxyUser;
    private final SiteTrustType trustType;
    private final String keyCertPem;
    private final String serverCertPem;
    private final ConnectionConfig connectionConfig;
    private final SocketConfig socketConfig;
    private Map<String, Object> attributes;
    private final Integer requestTimeoutSeconds;
    private final Integer maxConnections;
    private final Integer connectionPoolTimeoutSeconds;
    private Integer maxPerRoute;
    private RequestConfig requestConfig;
    private HttpClientContext clientContextPrototype;
    private final boolean ignoreHostnameVerification;

    SiteConfig(String id, String uri, String user, String proxyHost, Integer proxyPort, String proxyUser, SiteTrustType trustType, String keyCertPem, String serverCertPem, Integer requestTimeoutSeconds, Integer connectionPoolTimeoutSeconds, Integer maxConnections, Integer maxPerRoute, ConnectionConfig connectionConfig, SocketConfig socketConfig, RequestConfig requestConfig, HttpClientContext clientContextPrototype, boolean ignoreHostnameVerification, Map<String, Object> attributes) {
        this.id = id;
        this.uri = uri;
        this.user = user;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.trustType = trustType;
        this.keyCertPem = keyCertPem;
        this.serverCertPem = serverCertPem;
        this.requestTimeoutSeconds = requestTimeoutSeconds;
        this.connectionPoolTimeoutSeconds = connectionPoolTimeoutSeconds;
        this.maxConnections = maxConnections;
        this.maxPerRoute = maxPerRoute;
        this.connectionConfig = connectionConfig;
        this.socketConfig = socketConfig;
        this.requestConfig = requestConfig;
        this.clientContextPrototype = clientContextPrototype;
        this.ignoreHostnameVerification = ignoreHostnameVerification;
        this.attributes = attributes == null ? new HashMap() : attributes;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String getId() {
        return this.id;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort == null ? 8080 : this.proxyPort;
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() throws MalformedURLException {
        return new URL(this.getUri()).getHost();
    }

    public int getPort() throws MalformedURLException {
        URL u = new URL(this.getUri());
        int port = u.getPort();
        if (port < 1) {
            port = u.getDefaultPort();
        }
        return port;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getKeyCertPem() {
        return this.keyCertPem;
    }

    public String getUri() {
        return this.uri;
    }

    public String getServerCertPem() {
        return this.serverCertPem;
    }

    public int getConnectionPoolTimeoutSeconds() {
        return this.connectionPoolTimeoutSeconds == null ? 60 : this.connectionPoolTimeoutSeconds;
    }

    public int getRequestTimeoutSeconds() {
        return this.requestTimeoutSeconds == null ? 10 : this.requestTimeoutSeconds;
    }

    public <T> T getAttribute(String key, Class<T> type) {
        Object value = this.getAttribute(key);
        return value == null ? null : (T)type.cast(value);
    }

    public <T> T getAttribute(String key, Class<T> type, T defaultValue) {
        Object value = this.getAttribute(key);
        return value == null ? defaultValue : type.cast(value);
    }

    public synchronized Object setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributes == null ? null : this.attributes.get(key);
    }

    public int getMaxConnections() {
        return this.maxConnections == null ? 4 : this.maxConnections;
    }

    public int getMaxPerRoute() {
        return this.maxPerRoute == null ? this.getMaxConnections() : this.maxPerRoute.intValue();
    }

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public SocketConfig getSocketConfig() {
        return this.socketConfig;
    }

    public SiteTrustType getTrustType() {
        return this.trustType == null ? SiteTrustType.DEFAULT : this.trustType;
    }

    public Object removeAttribute(String key) {
        if (this.attributes != null) {
            return this.attributes.remove(key);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SiteConfig)) {
            return false;
        }
        SiteConfig that = (SiteConfig)o;
        return !(this.getId() == null ? that.getId() != null : !this.getId().equals(that.getId()));
    }

    public int hashCode() {
        return 13 + (this.getId() != null ? this.getId().hashCode() : 0);
    }

    public String toString() {
        return "SiteConfig{id='" + this.id + '\'' + '}';
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public HttpClientContext getClientContextPrototype() {
        return this.clientContextPrototype;
    }

    public boolean isIgnoreHostnameVerification() {
        return this.ignoreHostnameVerification;
    }
}

