/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.ChannelRequirement;
import org.wildfly.channel.Stream;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.Vendor;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.channel.version.VersionMatcher;

public class Channel
implements AutoCloseable {
    private static final String CLASSIFIER = "channel";
    private static final String EXTENSION = "yaml";
    private final String name;
    private final String description;
    private final Vendor vendor;
    private List<ChannelRequirement> channelRequirements;
    private List<Channel> requiredChannels = Collections.emptyList();
    private Set<Stream> streams;
    private MavenVersionsResolver resolver;

    public Channel(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="vendor") Vendor vendor, @JsonProperty(value="requires") @JsonInclude(value=JsonInclude.Include.NON_EMPTY) List<ChannelRequirement> channelRequirements, @JsonProperty(value="streams") Collection<Stream> streams) {
        this.name = name;
        this.description = description;
        this.vendor = vendor;
        this.channelRequirements = channelRequirements != null ? channelRequirements : Collections.emptyList();
        this.streams = new TreeSet<Stream>();
        if (streams != null) {
            this.streams.addAll(streams);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Vendor getVendor() {
        return this.vendor;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<ChannelRequirement> getChannelRequirements() {
        return this.channelRequirements;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Collection<Stream> getStreams() {
        return this.streams;
    }

    void addStream(Stream stream) {
        Objects.requireNonNull(stream);
        this.streams.add(stream);
    }

    void init(MavenVersionsResolver.Factory factory) {
        this.resolver = factory.create();
        if (!this.channelRequirements.isEmpty()) {
            this.requiredChannels = new ArrayList<Channel>();
        }
        for (ChannelRequirement channelRequirement : this.channelRequirements) {
            String groupId = channelRequirement.getGroupId();
            String artifactId = channelRequirement.getArtifactId();
            String version = channelRequirement.getVersion();
            if (version == null) {
                Set<String> versions = this.resolver.getAllVersions(groupId, artifactId, EXTENSION, CLASSIFIER);
                Optional<String> latest = VersionMatcher.getLatestVersion(versions);
                version = latest.orElseThrow(() -> new RuntimeException(String.format("Can not determine the latest version for Maven artifact %s:%s:%s:%s", groupId, artifactId, EXTENSION, CLASSIFIER)));
            }
            try {
                File file = this.resolver.resolveArtifact(groupId, artifactId, EXTENSION, CLASSIFIER, version);
                Channel requiredChannel = ChannelMapper.from(file.toURI().toURL());
                requiredChannel.init(factory);
                this.requiredChannels.add(requiredChannel);
            }
            catch (MalformedURLException | UnresolvedMavenArtifactException e) {
                throw new RuntimeException(String.format("Unable to resolve required channel %s:%s", groupId, artifactId, version));
            }
        }
    }

    @Override
    public void close() {
        for (Channel requiredChannel : this.requiredChannels) {
            requiredChannel.close();
        }
        this.resolver.close();
        this.resolver = null;
    }

    Optional<ResolveLatestVersionResult> resolveLatestVersion(String groupId, String artifactId, String extension, String classifier) {
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(this.resolver);
        Optional<Stream> foundStream = this.findStreamFor(groupId, artifactId);
        if (!foundStream.isPresent()) {
            HashMap<String, Channel> foundVersions = new HashMap<String, Channel>();
            for (Channel requiredChannel : this.requiredChannels) {
                Optional<ResolveLatestVersionResult> found = requiredChannel.resolveLatestVersion(groupId, artifactId, extension, classifier);
                if (!found.isPresent()) continue;
                foundVersions.put(found.get().version, found.get().channel);
            }
            Optional<String> foundVersionInRequiredChannels = foundVersions.keySet().stream().sorted(VersionMatcher.COMPARATOR.reversed()).findFirst();
            if (foundVersionInRequiredChannels.isPresent()) {
                return Optional.of(new ResolveLatestVersionResult(foundVersionInRequiredChannels.get(), (Channel)foundVersions.get(foundVersionInRequiredChannels.get())));
            }
            return Optional.empty();
        }
        Stream stream = foundStream.get();
        Optional<Object> foundVersion = Optional.empty();
        if (stream.getVersion() != null) {
            foundVersion = Optional.of(stream.getVersion());
        } else if (stream.getVersionPattern() != null) {
            Set<String> versions = this.resolver.getAllVersions(groupId, artifactId, extension, classifier);
            foundVersion = foundStream.get().getVersionComparator().matches(versions);
        }
        if (foundVersion.isPresent()) {
            return Optional.of(new ResolveLatestVersionResult((String)foundVersion.get(), this));
        }
        return Optional.empty();
    }

    ResolveArtifactResult resolveArtifact(String groupId, String artifactId, String extension, String classifier, String version) throws UnresolvedMavenArtifactException {
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(version);
        Objects.requireNonNull(this.resolver);
        for (Channel requiredChannel : this.requiredChannels) {
            try {
                return requiredChannel.resolveArtifact(groupId, artifactId, extension, classifier, version);
            }
            catch (UnresolvedMavenArtifactException unresolvedMavenArtifactException) {
            }
        }
        return new ResolveArtifactResult(this.resolver.resolveArtifact(groupId, artifactId, extension, classifier, version), this);
    }

    public Optional<Stream> findStreamFor(String groupId, String artifactId) {
        Optional<Stream> stream = this.streams.stream().filter(s -> s.getGroupId().equals(groupId) && s.getArtifactId().equals(artifactId)).findFirst();
        if (stream.isPresent()) {
            return stream;
        }
        stream = this.streams.stream().filter(s -> s.getGroupId().equals(groupId) && s.getArtifactId().equals("*")).findFirst();
        return stream;
    }

    public String toString() {
        return "Channel{, name='" + this.name + "', description='" + this.description + "', vendor=" + this.vendor + ", channelRequirements=" + this.channelRequirements + ", streams=" + this.streams + "}";
    }

    static class ResolveArtifactResult {
        File file;
        Channel channel;

        ResolveArtifactResult(File file, Channel channel) {
            this.file = file;
            this.channel = channel;
        }
    }

    static class ResolveLatestVersionResult {
        final String version;
        final Channel channel;

        ResolveLatestVersionResult(String version, Channel channel) {
            this.version = version;
            this.channel = channel;
        }
    }
}

