/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Regex;
import org.joni.Syntax;
import org.joni.exception.SyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternValidator
implements JsonValidator {
    private final JsonValidator delegate;
    private final ValidationContext validationContext;

    public PatternValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        this.validationContext = validationContext;
        this.delegate = validationContext.getConfig() != null && validationContext.getConfig().isEcma262Validator() ? new PatternValidatorEcma262(schemaPath, schemaNode, parentSchema, validationContext) : new PatternValidatorJava(schemaPath, schemaNode, parentSchema, validationContext);
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode rootNode) {
        return this.delegate.validate(rootNode);
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        return this.delegate.validate(node, rootNode, at);
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        return this.delegate.walk(node, rootNode, at, shouldValidateSchema);
    }

    private static class PatternValidatorEcma262
    extends BaseJsonValidator
    implements JsonValidator {
        private static final Logger logger = LoggerFactory.getLogger(PatternValidator.class);
        private String pattern = "";
        private Regex compiledRegex;

        public PatternValidatorEcma262(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
            super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.PATTERN, validationContext);
            if (schemaNode != null && schemaNode.isTextual()) {
                this.pattern = schemaNode.textValue();
                try {
                    this.compileRegexPattern(this.pattern, validationContext.getConfig() != null && validationContext.getConfig().isEcma262Validator());
                }
                catch (SyntaxException se) {
                    logger.error("Failed to compile pattern : Invalid syntax [" + this.pattern + "]", se);
                    throw se;
                }
            }
            this.validationContext = validationContext;
            this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
        }

        private void compileRegexPattern(String regex, boolean useEcma262Validator) {
            byte[] regexBytes = regex.getBytes();
            this.compiledRegex = new Regex(regexBytes, 0, regexBytes.length, 0, (Encoding)UTF8Encoding.INSTANCE, Syntax.ECMAScript);
        }

        private boolean matches(String value) {
            if (this.compiledRegex == null) {
                return true;
            }
            byte[] bytes = value.getBytes();
            return this.compiledRegex.matcher(bytes).search(0, bytes.length, 0) >= 0;
        }

        @Override
        public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
            this.debug(logger, node, rootNode, at);
            JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
            if (nodeType != JsonType.STRING) {
                return Collections.emptySet();
            }
            try {
                if (!this.matches(node.asText())) {
                    return Collections.singleton(this.buildValidationMessage(at, this.pattern));
                }
            }
            catch (PatternSyntaxException pse) {
                logger.error("Failed to apply pattern on " + at + ": Invalid syntax [" + this.pattern + "]", pse);
            }
            return Collections.emptySet();
        }
    }

    private static class PatternValidatorJava
    extends BaseJsonValidator
    implements JsonValidator {
        private static final Logger logger = LoggerFactory.getLogger(PatternValidator.class);
        private String pattern = "";
        private Pattern compiledPattern;

        public PatternValidatorJava(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
            super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.PATTERN, validationContext);
            if (schemaNode != null && schemaNode.isTextual()) {
                this.pattern = schemaNode.textValue();
                try {
                    this.compiledPattern = Pattern.compile(this.pattern);
                }
                catch (PatternSyntaxException pse) {
                    logger.error("Failed to compile pattern : Invalid syntax [" + this.pattern + "]", pse);
                    throw pse;
                }
            }
            this.validationContext = validationContext;
            this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
        }

        private boolean matches(String value) {
            return this.compiledPattern == null || this.compiledPattern.matcher(value).find();
        }

        @Override
        public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
            this.debug(logger, node, rootNode, at);
            JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
            if (nodeType != JsonType.STRING) {
                return Collections.emptySet();
            }
            try {
                if (!this.matches(node.asText())) {
                    return Collections.singleton(this.buildValidationMessage(at, this.pattern));
                }
            }
            catch (PatternSyntaxException pse) {
                logger.error("Failed to apply pattern on " + at + ": Invalid syntax [" + this.pattern + "]", pse);
            }
            return Collections.emptySet();
        }
    }
}

