/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Scm;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseDescriptorBuilder;
import org.apache.maven.shared.release.config.ReleaseDescriptorStore;
import org.apache.maven.shared.release.config.ReleaseDescriptorStoreException;
import org.apache.maven.shared.release.config.ReleaseStageVersions;
import org.apache.maven.shared.release.config.ReleaseUtils;
import org.apache.maven.shared.release.scm.IdentifiedScm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

@Component(role=ReleaseDescriptorStore.class, hint="properties")
public class PropertiesReleaseDescriptorStore
extends AbstractLogEnabled
implements ReleaseDescriptorStore {
    @Requirement(role=SecDispatcher.class, hint="mng-4384")
    private DefaultSecDispatcher secDispatcher;

    @Override
    public ReleaseDescriptorBuilder read(ReleaseDescriptorBuilder mergeDescriptor) throws ReleaseDescriptorStoreException {
        return this.read(mergeDescriptor, PropertiesReleaseDescriptorStore.getDefaultReleasePropertiesFile(mergeDescriptor.build()));
    }

    public ReleaseDescriptorBuilder read(File file) throws ReleaseDescriptorStoreException {
        return this.read(null, file);
    }

    public ReleaseDescriptorBuilder read(ReleaseDescriptorBuilder mergeDescriptor, File file) throws ReleaseDescriptorStoreException {
        Properties properties = new Properties();
        try (FileInputStream inStream = new FileInputStream(file);){
            properties.load(inStream);
        }
        catch (FileNotFoundException e) {
            this.getLogger().debug(file.getName() + " not found - using empty properties");
        }
        catch (IOException e) {
            throw new ReleaseDescriptorStoreException("Error reading properties file '" + file.getName() + "': " + e.getMessage(), e);
        }
        try {
            this.decryptProperties(properties);
        }
        catch (IllegalStateException | PlexusCipherException | SecDispatcherException e) {
            this.getLogger().debug(e.getMessage());
        }
        ReleaseDescriptorBuilder builder = mergeDescriptor != null ? mergeDescriptor : new ReleaseDescriptorBuilder();
        ReleaseUtils.copyPropertiesToReleaseDescriptor(properties, builder);
        return builder;
    }

    @Override
    public void write(ReleaseDescriptor config) throws ReleaseDescriptorStoreException {
        this.write((ReleaseDescriptorBuilder.BuilderReleaseDescriptor)config, PropertiesReleaseDescriptorStore.getDefaultReleasePropertiesFile(config));
    }

    @Override
    public void delete(ReleaseDescriptor config) {
        File file = PropertiesReleaseDescriptorStore.getDefaultReleasePropertiesFile(config);
        if (file.exists()) {
            file.delete();
        }
    }

    public void write(ReleaseDescriptorBuilder.BuilderReleaseDescriptor config, File file) throws ReleaseDescriptorStoreException {
        Properties properties = new Properties();
        properties.setProperty("completedPhase", config.getCompletedPhase());
        if (config.isCommitByProject()) {
            properties.setProperty("commitByProject", "true");
        }
        properties.setProperty("scm.url", config.getScmSourceUrl());
        if (config.getScmId() != null) {
            properties.setProperty("scm.id", config.getScmId());
        }
        if (config.getScmUsername() != null) {
            properties.setProperty("scm.username", config.getScmUsername());
        }
        if (config.getScmPassword() != null) {
            String password = config.getScmPassword();
            try {
                password = this.encryptAndDecorate(password);
            }
            catch (IllegalStateException | PlexusCipherException | SecDispatcherException exception) {
                this.getLogger().debug(exception.getMessage());
            }
            properties.setProperty("scm.password", password);
        }
        if (config.getScmPrivateKey() != null) {
            properties.setProperty("scm.privateKey", config.getScmPrivateKey());
        }
        if (config.getScmPrivateKeyPassPhrase() != null) {
            Iterator<Map.Entry<String, Scm>> passPhrase = config.getScmPrivateKeyPassPhrase();
            try {
                passPhrase = this.encryptAndDecorate((String)((Object)passPhrase));
            }
            catch (IllegalStateException | PlexusCipherException | SecDispatcherException exception) {
                this.getLogger().debug(exception.getMessage());
            }
            properties.setProperty("scm.passphrase", (String)((Object)passPhrase));
        }
        if (config.getScmTagBase() != null) {
            properties.setProperty("scm.tagBase", config.getScmTagBase());
        }
        if (config.getScmBranchBase() != null) {
            properties.setProperty("scm.branchBase", config.getScmBranchBase());
        }
        if (config.getScmReleaseLabel() != null) {
            properties.setProperty("scm.tag", config.getScmReleaseLabel());
        }
        if (config.getScmTagNameFormat() != null) {
            properties.setProperty("scm.tagNameFormat", config.getScmTagNameFormat());
        }
        if (config.getScmCommentPrefix() != null) {
            properties.setProperty("scm.commentPrefix", config.getScmCommentPrefix());
        }
        if (config.getScmDevelopmentCommitComment() != null) {
            properties.setProperty("scm.developmentCommitComment", config.getScmDevelopmentCommitComment());
        }
        if (config.getScmReleaseCommitComment() != null) {
            properties.setProperty("scm.releaseCommitComment", config.getScmReleaseCommitComment());
        }
        if (config.getScmBranchCommitComment() != null) {
            properties.setProperty("scm.branchCommitComment", config.getScmBranchCommitComment());
        }
        if (config.getScmRollbackCommitComment() != null) {
            properties.setProperty("scm.rollbackCommitComment", config.getScmRollbackCommitComment());
        }
        if (config.getAdditionalArguments() != null) {
            properties.setProperty("exec.additionalArguments", config.getAdditionalArguments());
        }
        if (config.getPomFileName() != null) {
            properties.setProperty("exec.pomFileName", config.getPomFileName());
        }
        if (!config.getActivateProfiles().isEmpty()) {
            properties.setProperty("exec.activateProfiles", StringUtils.join(config.getActivateProfiles().iterator(), ","));
        }
        if (config.getPreparationGoals() != null) {
            properties.setProperty("preparationGoals", config.getPreparationGoals());
        }
        if (config.getCompletionGoals() != null) {
            properties.setProperty("completionGoals", config.getCompletionGoals());
        }
        if (config.getProjectVersionPolicyId() != null) {
            properties.setProperty("projectVersionPolicyId", config.getProjectVersionPolicyId());
        }
        if (config.getProjectNamingPolicyId() != null) {
            properties.setProperty("projectNamingPolicyId", config.getProjectNamingPolicyId());
        }
        if (config.getReleaseStrategyId() != null) {
            properties.setProperty("releaseStrategyId", config.getReleaseStrategyId());
        }
        properties.setProperty("exec.snapshotReleasePluginAllowed", Boolean.toString(config.isSnapshotReleasePluginAllowed()));
        properties.setProperty("remoteTagging", Boolean.toString(config.isRemoteTagging()));
        properties.setProperty("pinExternals", Boolean.toString(config.isPinExternals()));
        properties.setProperty("pushChanges", Boolean.toString(config.isPushChanges()));
        if (config.getWorkItem() != null) {
            properties.setProperty("workItem", config.getWorkItem());
        }
        if (config.getAutoResolveSnapshots() != null) {
            properties.setProperty("autoResolveSnapshots", config.getAutoResolveSnapshots());
        }
        for (Map.Entry entry : config.getProjectVersions().entrySet()) {
            if (((ReleaseStageVersions)entry.getValue()).getRelease() != null) {
                properties.setProperty("project.rel." + (String)entry.getKey(), ((ReleaseStageVersions)entry.getValue()).getRelease());
            }
            if (((ReleaseStageVersions)entry.getValue()).getDevelopment() == null) continue;
            properties.setProperty("project.dev." + (String)entry.getKey(), ((ReleaseStageVersions)entry.getValue()).getDevelopment());
        }
        for (Map.Entry<String, Scm> entry : config.getOriginalScmInfo().entrySet()) {
            Scm scm = entry.getValue();
            String prefix = "project.scm." + entry.getKey();
            if (scm != null) {
                IdentifiedScm identifiedScm;
                if (scm.getConnection() != null) {
                    properties.setProperty(prefix + ".connection", scm.getConnection());
                }
                if (scm.getDeveloperConnection() != null) {
                    properties.setProperty(prefix + ".developerConnection", scm.getDeveloperConnection());
                }
                if (scm.getUrl() != null) {
                    properties.setProperty(prefix + ".url", scm.getUrl());
                }
                if (scm.getTag() != null) {
                    properties.setProperty(prefix + ".tag", scm.getTag());
                }
                if (!(scm instanceof IdentifiedScm) || (identifiedScm = (IdentifiedScm)scm).getId() == null) continue;
                properties.setProperty(prefix + ".id", identifiedScm.getId());
                continue;
            }
            properties.setProperty(prefix + ".empty", "true");
        }
        if (config.getResolvedSnapshotDependencies() != null && config.getResolvedSnapshotDependencies().size() > 0) {
            this.processResolvedDependencies(properties, config.getResolvedSnapshotDependencies());
        }
        try {
            Throwable throwable = null;
            try (FileOutputStream outStream = new FileOutputStream(file);){
                properties.store(outStream, "release configuration");
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new ReleaseDescriptorStoreException("Error writing properties file '" + file.getName() + "': " + e.getMessage(), e);
        }
    }

    private void processResolvedDependencies(Properties prop, Map<String, ReleaseStageVersions> resolvedDependencies) {
        for (Map.Entry<String, ReleaseStageVersions> currentEntry : resolvedDependencies.entrySet()) {
            ReleaseStageVersions versionMap = currentEntry.getValue();
            prop.setProperty("dependency." + currentEntry.getKey() + ".release", versionMap.getRelease());
            prop.setProperty("dependency." + currentEntry.getKey() + ".development", versionMap.getDevelopment());
        }
    }

    private static File getDefaultReleasePropertiesFile(ReleaseDescriptor mergeDescriptor) {
        return new File(mergeDescriptor.getWorkingDirectory(), "release.properties");
    }

    private void decryptProperties(Properties properties) throws IllegalStateException, SecDispatcherException, PlexusCipherException {
        String[] keys;
        for (String key : keys = new String[]{"scm.password", "scm.passphrase"}) {
            String value = properties.getProperty(key);
            if (value == null) continue;
            properties.put(key, this.decrypt(value));
        }
    }

    private String encryptAndDecorate(String passwd) throws IllegalStateException, SecDispatcherException, PlexusCipherException {
        String master = this.getMaster();
        DefaultPlexusCipher cipher = new DefaultPlexusCipher();
        String masterPasswd = cipher.decryptDecorated(master, "settings.security");
        return cipher.encryptAndDecorate(passwd, masterPasswd);
    }

    private String decrypt(String value) throws IllegalStateException, SecDispatcherException, PlexusCipherException {
        String master = this.getMaster();
        DefaultPlexusCipher cipher = new DefaultPlexusCipher();
        String masterPasswd = cipher.decryptDecorated(master, "settings.security");
        return cipher.decryptDecorated(value, masterPasswd);
    }

    private String getMaster() throws SecDispatcherException {
        String configurationFile = this.secDispatcher.getConfigurationFile();
        if (configurationFile.startsWith("~")) {
            configurationFile = System.getProperty("user.home") + configurationFile.substring(1);
        }
        String file = System.getProperty("settings.security", configurationFile);
        String master = null;
        SettingsSecurity sec = SecUtil.read(file, true);
        if (sec != null) {
            master = sec.getMaster();
        }
        if (master == null) {
            throw new IllegalStateException("Master password is not set in the setting security file: " + file);
        }
        return master;
    }
}

