/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view.meta;

import java.util.ArrayList;
import java.util.List;
import org.commonjava.maven.atlas.ident.util.VersionUtils;
import org.commonjava.maven.atlas.ident.version.SingleVersion;
import org.commonjava.maven.galley.maven.model.view.meta.LatestSnapshotView;
import org.commonjava.maven.galley.maven.model.view.meta.MavenMetadataElementView;
import org.commonjava.maven.galley.maven.model.view.meta.MavenMetadataView;
import org.commonjava.maven.galley.maven.model.view.meta.SnapshotArtifactView;
import org.w3c.dom.Element;

public class VersioningView
extends MavenMetadataElementView {
    public VersioningView(MavenMetadataView xmlView, Element element) {
        super(xmlView, element);
    }

    public LatestSnapshotView getLatestSnapshot() {
        Element e = this.getElement("snapshot");
        if (e != null) {
            return new LatestSnapshotView((MavenMetadataView)this.xmlView, e);
        }
        return null;
    }

    public List<SnapshotArtifactView> getSnapshotArtifacts() {
        List<Element> elements = this.getElements("snapshotVersions/snapshotVersion");
        if (elements != null) {
            ArrayList<SnapshotArtifactView> views = new ArrayList<SnapshotArtifactView>();
            for (Element element : elements) {
                views.add(new SnapshotArtifactView((MavenMetadataView)this.xmlView, element));
            }
            return views;
        }
        return null;
    }

    public List<SingleVersion> getVersions() {
        List<String> versionList = ((MavenMetadataView)this.xmlView).resolveXPathToAggregatedStringListFrom(this.elementContext, "versions/version", true);
        ArrayList<SingleVersion> versions = new ArrayList<SingleVersion>();
        if (versionList != null && !versionList.isEmpty()) {
            for (String v : versionList) {
                versions.add(VersionUtils.createSingleVersion(v));
            }
        }
        return versions;
    }

    public SingleVersion getReleaseVersion() {
        Element element = this.getElement("release");
        if (element != null) {
            return VersionUtils.createSingleVersion(element.getTextContent().trim());
        }
        return null;
    }

    public SingleVersion getLatestVersion() {
        Element element = this.getElement("latest");
        if (element != null) {
            return VersionUtils.createSingleVersion(element.getTextContent().trim());
        }
        return null;
    }
}

