/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.ProfileInjectionState;
import org.commonjava.maven.ext.io.ModelIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="profile-injection")
@Singleton
public class ProfileInjectionManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ModelIO modelBuilder;
    private ManipulationSession session;

    @Inject
    public ProfileInjectionManipulator(ModelIO modelBuilder) {
        this.modelBuilder = modelBuilder;
    }

    @Override
    public void init(ManipulationSession session) {
        this.session = session;
        session.setState(new ProfileInjectionState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        ProfileInjectionState state = this.session.getState(ProfileInjectionState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        for (ProjectVersionRef p : state.getRemoteProfileInjectionMgmt()) {
            List<Profile> remoteProfiles = this.modelBuilder.resolveRawModel(p).getProfiles();
            projects.stream().filter(Project::isInheritanceRoot).forEach(project -> {
                this.logger.info("Applying changes to: {}:{}", (Object)project.getGroupId(), (Object)project.getArtifactId());
                project.updateProfiles(remoteProfiles);
                changed.add((Project)project);
            });
        }
        return changed;
    }

    @Override
    public int getExecutionIndex() {
        return 5;
    }
}

