/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.galley.io.SpecialPathConstants;
import org.commonjava.maven.galley.io.SpecialPathSet;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.SpecialPathInfo;
import org.commonjava.maven.galley.model.SpecialPathMatcher;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.spi.io.SpecialPathManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SpecialPathManagerImpl
implements SpecialPathManager {
    private static final Logger logger = LoggerFactory.getLogger(SpecialPathManagerImpl.class);
    private List<SpecialPathInfo> stdSpecialPaths;
    private Map<String, SpecialPathSet> pkgtypes;

    public SpecialPathManagerImpl() {
        this.initPkgPathSets();
    }

    @PostConstruct
    public void initPkgPathSets() {
        this.stdSpecialPaths = new ArrayList<SpecialPathInfo>();
        this.stdSpecialPaths.addAll(SpecialPathConstants.STANDARD_SPECIAL_PATHS);
        this.pkgtypes = new ConcurrentHashMap<String, SpecialPathSet>();
        this.pkgtypes.put(SpecialPathConstants.MVN_SP_PATH_SET.getPackageType(), SpecialPathConstants.MVN_SP_PATH_SET);
        this.pkgtypes.put(SpecialPathConstants.NPM_SP_PATH_SET.getPackageType(), SpecialPathConstants.NPM_SP_PATH_SET);
    }

    @Override
    public synchronized void registerSpecialPathInfo(SpecialPathInfo pathInfo) {
        this.stdSpecialPaths.add(pathInfo);
    }

    @Override
    public void registerSpecialPathInfo(SpecialPathInfo pathInfo, String pkgType) {
        this.pkgtypes.get(pkgType).registerSpecialPathInfo(pathInfo);
    }

    @Override
    public synchronized void deregisterSpecialPathInfo(SpecialPathInfo pathInfo) {
        this.stdSpecialPaths.remove(pathInfo);
    }

    @Override
    public void deregisterSpecialPathInfo(SpecialPathInfo pathInfo, String pkgType) {
        this.pkgtypes.get(pkgType).deregisterSpecialPathInfo(pathInfo);
    }

    @Override
    public void registerSpecialPathSet(SpecialPathSet pathSet) {
        if (this.pkgtypes.containsKey(pathSet.getPackageType())) {
            logger.warn("[Galley] The package types already contains the path set for this package type {}, will override it", (Object)pathSet.getPackageType());
        }
        this.pkgtypes.put(pathSet.getPackageType(), pathSet);
        if (logger.isTraceEnabled()) {
            ArrayList<SpecialPathMatcher> pathMatchers = new ArrayList<SpecialPathMatcher>();
            for (SpecialPathInfo info : pathSet.getSpecialPathInfos()) {
                pathMatchers.add(info.getMatcher());
            }
            logger.trace("Enabling special paths for package: '{}'\n  - {}\n\nCalled from: {}", pathSet.getPackageType(), StringUtils.join(pathMatchers, "\n  - "), Thread.currentThread().getStackTrace()[1]);
        }
    }

    @Override
    public SpecialPathSet deregesterSpecialPathSet(SpecialPathSet pathSet) {
        if (!this.pkgtypes.containsKey(pathSet.getPackageType())) {
            logger.warn("[Galley] The package does not contain the path set for this package type {}, no deregister operation there", (Object)pathSet.getPackageType());
        }
        return this.pkgtypes.remove(pathSet.getPackageType());
    }

    @Override
    @Deprecated
    public SpecialPathInfo getSpecialPathInfo(ConcreteResource resource) {
        return this.getSpecialPathInfo(resource, "maven");
    }

    @Override
    public SpecialPathInfo getSpecialPathInfo(ConcreteResource resource, String pkgType) {
        if (resource != null) {
            return this.getSpecialPathInfo(resource.getLocation(), resource.getPath(), pkgType);
        }
        return null;
    }

    @Override
    @Deprecated
    public SpecialPathInfo getSpecialPathInfo(Transfer transfer) {
        return this.getSpecialPathInfo(transfer, "maven");
    }

    @Override
    public SpecialPathInfo getSpecialPathInfo(Transfer transfer, String pkgType) {
        if (transfer != null) {
            return this.getSpecialPathInfo(transfer.getLocation(), transfer.getPath(), pkgType);
        }
        return null;
    }

    @Override
    public SpecialPathInfo getSpecialPathInfo(Location location, String path, String pkgType) {
        SpecialPathInfo info = this.getPathInfo(location, path, this.stdSpecialPaths);
        if (info != null) {
            return info;
        }
        if (this.pkgtypes.containsKey(pkgType) && (info = this.getPathInfo(location, path, this.pkgtypes.get(pkgType).getSpecialPathInfos())) != null) {
            return info;
        }
        return null;
    }

    private SpecialPathInfo getPathInfo(Location location, String path, Collection<SpecialPathInfo> from) {
        SpecialPathInfo firstHit = null;
        if (path != null) {
            for (SpecialPathInfo info : from) {
                if (!info.getMatcher().matches(location, path)) continue;
                if (firstHit != null) {
                    Logger logger = LoggerFactory.getLogger(this.getClass());
                    logger.error("Duplicate special-path registration for: {}:{}. Using: {}", location, path, firstHit);
                    continue;
                }
                firstHit = info;
            }
        }
        return firstHit;
    }

    @Override
    @Deprecated
    public SpecialPathInfo getSpecialPathInfo(Location location, String path) {
        return this.getSpecialPathInfo(location, path, "maven");
    }

    @Override
    public SpecialPathInfo getSpecialPathInfo(String path) {
        return path == null ? null : this.getSpecialPathInfo(null, path, "maven");
    }
}

