/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.commonjava.util.jhttpc.model.SiteConfig;
import org.commonjava.util.jhttpc.model.SiteTrustType;

public class SiteConfigBuilder {
    private String id;
    private String uri;
    private String user;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private SiteTrustType trustType;
    private String keyCertPem;
    private String serverCertPem;
    private Map<String, Object> attributes;
    private Integer requestTimeoutSeconds;
    private Integer connectionPoolTimeoutSeconds;
    private Integer maxConnections;
    private Integer maxPerRoute;
    private ConnectionConfig connectionConfig;
    private SocketConfig socketConfig;
    private RequestConfig requestConfig;
    private HttpClientContext clientContextProtoype;
    private boolean ignoreHostnameVerification;

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public SiteConfigBuilder() {
    }

    public SiteConfigBuilder(String id, String uri) {
        this.id = id;
        this.uri = uri;
    }

    public SiteConfig build() {
        return new SiteConfig(this.id, this.uri, this.user, this.proxyHost, this.proxyPort, this.proxyUser, this.trustType, this.keyCertPem, this.serverCertPem, this.requestTimeoutSeconds, this.connectionPoolTimeoutSeconds, this.maxConnections, this.maxPerRoute, this.connectionConfig, this.socketConfig, this.requestConfig, this.clientContextProtoype, this.ignoreHostnameVerification, this.attributes);
    }

    public String getId() {
        return this.id;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort == null ? 8080 : this.proxyPort;
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() throws MalformedURLException {
        return new URL(this.getUri()).getHost();
    }

    public int getPort() throws MalformedURLException {
        URL u = new URL(this.getUri());
        int port = u.getPort();
        if (port < 1) {
            port = u.getDefaultPort();
        }
        return port;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getKeyCertPem() {
        return this.keyCertPem;
    }

    public String getUri() {
        return this.uri;
    }

    public String getServerCertPem() {
        return this.serverCertPem;
    }

    public int getRequestTimeoutSeconds() {
        return this.requestTimeoutSeconds == null ? 10 : this.requestTimeoutSeconds;
    }

    public int getConnectionPoolTimeoutSeconds() {
        return this.connectionPoolTimeoutSeconds == null ? 60 : this.connectionPoolTimeoutSeconds;
    }

    public synchronized Object setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributes == null ? null : this.attributes.get(key);
    }

    public SiteConfigBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public SiteConfigBuilder withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public SiteConfigBuilder withUser(String user) {
        this.user = user;
        return this;
    }

    public SiteConfigBuilder withProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public SiteConfigBuilder withProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public SiteConfigBuilder withProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    public SiteConfigBuilder withTrustType(SiteTrustType trustType) {
        this.trustType = trustType;
        return this;
    }

    public SiteConfigBuilder withKeyCertPem(String keyCertPem) {
        this.keyCertPem = keyCertPem;
        return this;
    }

    public SiteConfigBuilder withServerCertPem(String serverCertPem) {
        this.serverCertPem = serverCertPem;
        return this;
    }

    public SiteConfigBuilder withAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public SiteConfigBuilder withRequestTimeoutSeconds(Integer requestTimeoutSeconds) {
        this.requestTimeoutSeconds = requestTimeoutSeconds;
        return this;
    }

    public SiteConfigBuilder withConnectionPoolTimeoutSeconds(Integer timeoutSeconds) {
        this.connectionPoolTimeoutSeconds = timeoutSeconds;
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections == null ? 4 : this.maxConnections;
    }

    public SiteConfigBuilder withMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public int getMaxPerRoute() {
        return this.maxPerRoute == null ? this.getMaxConnections() : this.maxPerRoute.intValue();
    }

    public SiteConfigBuilder withMaxPerRoute(Integer maxPerRoute) {
        this.maxPerRoute = maxPerRoute;
        return this;
    }

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public SiteConfigBuilder withConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
        return this;
    }

    public SiteConfigBuilder withIgnoreHostnameVerification(boolean ignoreHostnameVerification) {
        this.ignoreHostnameVerification = ignoreHostnameVerification;
        return this;
    }

    public SocketConfig getSocketConfig() {
        return this.socketConfig;
    }

    public SiteConfigBuilder withSocketConfig(SocketConfig socketConfig) {
        this.socketConfig = socketConfig;
        return this;
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public SiteConfigBuilder withRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
        return this;
    }

    public HttpClientContext getClientContextProtoype() {
        return this.clientContextProtoype;
    }

    public SiteConfigBuilder withClientContextPrototype(HttpClientContext clientContextPrototype) {
        this.clientContextProtoype = clientContextPrototype;
        return this;
    }

    public SiteTrustType getTrustType() {
        return this.trustType == null ? SiteTrustType.DEFAULT : this.trustType;
    }

    public void removeAttribute(String key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SiteConfigBuilder)) {
            return false;
        }
        SiteConfigBuilder that = (SiteConfigBuilder)o;
        return !(this.getId() == null ? that.getId() != null : !this.getId().equals(that.getId()));
    }

    public int hashCode() {
        return 13 + (this.getId() != null ? this.getId().hashCode() : 0);
    }

    public String toString() {
        return "SiteConfig{id='" + this.id + '\'' + '}';
    }
}

